/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.relational;

import java.util.List;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LOCube
extends LogicalRelationalOperator {
    private MultiMap<Integer, LogicalExpressionPlan> mExpressionPlans;
    private List<String> operations;

    public LOCube(LogicalPlan plan) {
        super("LOCube", plan);
    }

    public LOCube(OperatorPlan plan, MultiMap<Integer, LogicalExpressionPlan> expressionPlans) {
        super("LOCube", plan);
        this.mExpressionPlans = expressionPlans;
    }

    @Override
    public LogicalSchema getSchema() throws FrontendException {
        return null;
    }

    @Override
    public void accept(PlanVisitor v) throws FrontendException {
        try {
            ((LogicalRelationalNodesVisitor)v).visit(this);
        }
        catch (ClassCastException cce) {
            throw new FrontendException("Expected LogicalPlanVisitor", cce);
        }
    }

    @Override
    public boolean isEqual(Operator other) throws FrontendException {
        try {
            LOCube cube = (LOCube)other;
            for (Integer key : this.mExpressionPlans.keySet()) {
                if (!cube.mExpressionPlans.containsKey(key)) {
                    return false;
                }
                List<LogicalExpressionPlan> lepList1 = this.mExpressionPlans.get(key);
                List<LogicalExpressionPlan> lepList2 = cube.mExpressionPlans.get(key);
                for (LogicalExpressionPlan lep1 : lepList1) {
                    for (LogicalExpressionPlan lep2 : lepList2) {
                        if (lep1.isEqual(lep2)) continue;
                        return false;
                    }
                }
            }
            return this.checkEquality((LogicalRelationalOperator)other);
        }
        catch (ClassCastException cce) {
            throw new FrontendException("Exception while casting CUBE operator", cce);
        }
    }

    public MultiMap<Integer, LogicalExpressionPlan> getExpressionPlans() {
        return this.mExpressionPlans;
    }

    public void setExpressionPlans(MultiMap<Integer, LogicalExpressionPlan> plans) {
        this.mExpressionPlans = plans;
    }

    @Override
    public void resetUid() {
    }

    public List<Operator> getInputs(LogicalPlan plan) {
        return plan.getPredecessors(this);
    }

    public List<String> getOperations() {
        return this.operations;
    }

    public void setOperations(List<String> operations) {
        this.operations = operations;
    }
}

