/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.plan;

import java.io.Serializable;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.PlanVisitor;
import org.apache.pig.impl.plan.ProjectionMap;
import org.apache.pig.impl.plan.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Operator<V extends PlanVisitor>
implements Serializable,
Comparable<Operator>,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected OperatorKey mKey;

    public Operator(OperatorKey k) {
        this.mKey = k;
    }

    public OperatorKey getOperatorKey() {
        return this.mKey;
    }

    public abstract void visit(V var1) throws VisitorException;

    public abstract boolean supportsMultipleInputs();

    public abstract boolean supportsMultipleOutputs();

    public abstract String name();

    public String toString() {
        return "(Name: " + this.name() + " Operator Key: " + this.mKey + ")";
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public int hashCode() {
        return this.mKey.hashCode();
    }

    @Override
    public int compareTo(Operator o) {
        return this.mKey.compareTo(o.mKey);
    }

    protected Object clone() throws CloneNotSupportedException {
        Object o = super.clone();
        Operator opClone = (Operator)o;
        opClone.mKey = new OperatorKey(this.mKey.scope, NodeIdGenerator.getGenerator().getNextNodeId(this.mKey.scope));
        return opClone;
    }

    public ProjectionMap getProjectionMap() {
        return null;
    }

    public void unsetProjectionMap() {
    }

    public ProjectionMap regenerateProjectionMap() {
        this.unsetProjectionMap();
        return this.getProjectionMap();
    }

    public void rewire(Operator<V> oldPred, int oldPredIndex, Operator<V> newPred, boolean useOldPred) throws PlanException {
        if (oldPred == null) {
            return;
        }
    }
}

