/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.io;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.pig.Expression;
import org.apache.pig.FileInputLoadFunc;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadMetadata;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.StoreFunc;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.data.BinSedesTuple;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.Utils;

@InterfaceAudience.Private
public class SequenceFileInterStorage
extends FileInputLoadFunc
implements StoreFuncInterface,
LoadMetadata {
    private static final Log mLog = LogFactory.getLog(SequenceFileInterStorage.class);
    public static final String useLog = "SequenceFile storage in use";
    private final NullWritable KEY0 = NullWritable.get();
    RecordReader<NullWritable, BinSedesTuple> recReader;
    RecordWriter<NullWritable, BinSedesTuple> recWriter;

    public SequenceFileInterStorage() throws IOException {
        mLog.debug((Object)useLog);
    }

    public Tuple getNext() throws IOException {
        try {
            if (this.recReader.nextKeyValue()) {
                return (Tuple)this.recReader.getCurrentValue();
            }
            return null;
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public void putNext(Tuple t) throws IOException {
        try {
            this.recWriter.write((Object)this.KEY0, (Object)((BinSedesTuple)t));
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public InputFormat getInputFormat() {
        return new SequenceFileInputFormat();
    }

    public void setLocation(String location, Job job) throws IOException {
        FileInputFormat.setInputPaths((Job)job, (String)location);
    }

    public ResourceSchema getSchema(String location, Job job) throws IOException {
        return Utils.getSchema(this, location, true, job);
    }

    public void prepareToRead(RecordReader reader, PigSplit split) throws IOException {
        this.recReader = reader;
    }

    public ResourceStatistics getStatistics(String location, Job job) throws IOException {
        return null;
    }

    public String[] getPartitionKeys(String location, Job job) throws IOException {
        return null;
    }

    public void setPartitionFilter(Expression partitionFilter) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String relToAbsPathForStoreLocation(String location, Path curDir) throws IOException {
        return LoadFunc.getAbsolutePath(location, curDir);
    }

    public OutputFormat getOutputFormat() throws IOException {
        return new SequenceFileTupleOutputFormat();
    }

    public void setStoreLocation(String location, Job job) throws IOException {
        Configuration conf = job.getConfiguration();
        Utils.setMapredCompressionCodecProps(conf);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(location));
    }

    public void checkSchema(ResourceSchema s) throws IOException {
    }

    public void prepareToWrite(RecordWriter writer) throws IOException {
        this.recWriter = writer;
    }

    public void setStoreFuncUDFContextSignature(String signature) {
    }

    public void cleanupOnFailure(String location, Job job) throws IOException {
        StoreFunc.cleanupOnFailureImpl(location, job);
    }

    public void cleanupOnSuccess(String location, Job job) throws IOException {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SequenceFileTupleOutputFormat
    extends SequenceFileOutputFormat<NullWritable, BinSedesTuple> {
        protected SequenceFile.Writer getSequenceWriter(TaskAttemptContext context) throws IOException {
            Configuration conf = context.getConfiguration();
            CompressionCodec codec = null;
            SequenceFile.CompressionType compressionType = SequenceFile.CompressionType.NONE;
            if (SequenceFileTupleOutputFormat.getCompressOutput((JobContext)context)) {
                compressionType = SequenceFileTupleOutputFormat.getOutputCompressionType((JobContext)context);
                Class codecClass = SequenceFileTupleOutputFormat.getOutputCompressorClass((JobContext)context, DefaultCodec.class);
                codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)conf);
            }
            Path file = this.getDefaultWorkFile(context, "");
            FileSystem fs = file.getFileSystem(conf);
            return SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)file, NullWritable.class, BinSedesTuple.class, (SequenceFile.CompressionType)compressionType, (CompressionCodec)codec, (Progressable)context);
        }

        public RecordWriter<NullWritable, BinSedesTuple> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
            final SequenceFile.Writer out = this.getSequenceWriter(context);
            return new RecordWriter<NullWritable, BinSedesTuple>(){

                public void write(NullWritable key, BinSedesTuple value) throws IOException {
                    out.append((Writable)key, (Writable)value);
                }

                public void close(TaskAttemptContext context) throws IOException {
                    out.close();
                }
            };
        }
    }
}

