/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.builtin;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.builtin.SampleLoader;

public class RandomSampleLoader
extends SampleLoader {
    Tuple[] samples = null;
    protected int nextSampleIdx = 0;

    public RandomSampleLoader(String funcSpec, String ns) {
        super(funcSpec);
        super.setNumSamples(Integer.valueOf(ns));
    }

    public Tuple getNext() throws IOException {
        if (this.samples != null) {
            return this.getSample();
        }
        this.samples = new Tuple[this.numSamples];
        Tuple t = null;
        for (int i = 0; i < this.numSamples && (t = this.loader.getNext()) != null; ++i) {
            this.samples[i] = t;
        }
        int rowNum = this.numSamples + 1;
        Random randGen = new Random();
        if (t != null) {
            while (true) {
                int rand;
                if ((rand = randGen.nextInt(rowNum)) < this.numSamples) {
                    Tuple sampleTuple = this.loader.getNext();
                    if (sampleTuple == null) break;
                    this.samples[rand] = sampleTuple;
                } else if (!this.skipNext()) break;
                ++rowNum;
            }
        }
        return this.getSample();
    }

    public void prepareToRead(RecordReader reader, PigSplit split) throws IOException {
        super.prepareToRead(reader, split);
        this.samples = null;
        this.nextSampleIdx = 0;
    }

    private Tuple getSample() {
        if (this.nextSampleIdx < this.samples.length) {
            return this.samples[this.nextSampleIdx++];
        }
        return null;
    }
}

