/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.builtin;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.pig.ComparisonFunc;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.partitioners.CountingMap;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.InternalMap;
import org.apache.pig.data.NonSpillableDataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.PigContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindQuantiles
extends EvalFunc<Map<String, Object>> {
    public static final String QUANTILES_LIST = "quantiles.list";
    public static final String WEIGHTED_PARTS = "weighted.parts";
    BagFactory mBagFactory = BagFactory.getInstance();
    TupleFactory mTupleFactory = TupleFactory.getInstance();
    boolean[] mAsc;
    State mState;
    private Comparator<Tuple> mComparator = new SortComparator();
    private FuncSpec mUserComparisonFuncSpec;
    private ComparisonFunc mUserComparisonFunc;

    private void instantiateFunc() {
        if (this.mUserComparisonFunc != null) {
            this.mUserComparisonFunc = (ComparisonFunc)((Object)PigContext.instantiateFuncFromSpec(this.mUserComparisonFuncSpec));
            this.mUserComparisonFunc.setReporter(this.reporter);
            this.mComparator = this.mUserComparisonFunc;
        }
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        is.defaultReadObject();
        this.instantiateFunc();
    }

    public FindQuantiles() {
        this.mState = State.ALL_ASC;
    }

    public FindQuantiles(String[] args) {
        int startIndex = 0;
        int ascFlagsLength = args.length;
        if (args[0].startsWith("user.comparator.func:")) {
            this.mUserComparisonFuncSpec = new FuncSpec(args[0].substring("user.comparator.func:".length()));
            ++startIndex;
            --ascFlagsLength;
        }
        this.mAsc = new boolean[ascFlagsLength];
        boolean sawAsc = false;
        boolean sawDesc = false;
        for (int i = startIndex; i < ascFlagsLength; ++i) {
            this.mAsc[i] = Boolean.parseBoolean(args[i]);
            if (this.mAsc[i]) {
                sawAsc = true;
                continue;
            }
            sawDesc = true;
        }
        this.mState = sawAsc && sawDesc ? State.MIXED : (sawDesc ? State.ALL_DESC : State.ALL_ASC);
    }

    @Override
    public Map<String, Object> exec(Tuple in) throws IOException {
        HashMap<String, Object> output = new HashMap<String, Object>();
        if (in == null || in.size() == 0) {
            return null;
        }
        Integer numQuantiles = null;
        DataBag samples = null;
        ArrayList<Tuple> quantilesList = new ArrayList<Tuple>();
        InternalMap weightedParts = new InternalMap();
        try {
            numQuantiles = (Integer)in.get(0);
            samples = (DataBag)in.get(1);
            long numSamples = samples.size();
            long toSkip = numSamples / (long)numQuantiles.intValue();
            if (toSkip == 0L) {
                numQuantiles = (int)numSamples;
                toSkip = 1L;
            }
            long ind = 0L;
            long j = -1L;
            long nextQuantile = toSkip - 1L;
            for (Tuple it : samples) {
                if (ind == nextQuantile) {
                    quantilesList.add(it);
                    nextQuantile += toSkip;
                    if (++j == (long)(numQuantiles - 1)) break;
                }
                if (++ind % 1000L != 0L) continue;
                this.progress();
            }
            long i = -1L;
            HashMap contribs = new HashMap();
            for (Tuple it : samples) {
                int partInd;
                if (++i % 1000L == 0L) {
                    this.progress();
                }
                if ((partInd = (int)(i / toSkip)) == numQuantiles) break;
                if (partInd < numQuantiles - 1 && this.areEqual(it, quantilesList.get(partInd))) {
                    if (!contribs.containsKey(it)) {
                        CountingMap<Integer> cm = new CountingMap<Integer>();
                        cm.put(Integer.valueOf(partInd), 1);
                        contribs.put(it, cm);
                        continue;
                    }
                    ((CountingMap)contribs.get(it)).put(Integer.valueOf(partInd), 1);
                    continue;
                }
                if (!contribs.containsKey(it)) continue;
                ((CountingMap)contribs.get(it)).put(Integer.valueOf(partInd), 1);
            }
            int k = 0;
            for (Map.Entry ent : contribs.entrySet()) {
                if (k % 1000 == 0) {
                    this.progress();
                }
                Tuple key = (Tuple)ent.getKey();
                CountingMap value = (CountingMap)ent.getValue();
                long total = value.getTotalCount();
                Tuple probVec = this.mTupleFactory.newTuple(numQuantiles);
                for (int l = 0; l < numQuantiles; ++l) {
                    probVec.set(l, new Float(0.0));
                }
                for (Map.Entry valEnt : value.entrySet()) {
                    probVec.set((Integer)valEnt.getKey(), Float.valueOf((float)((Integer)valEnt.getValue()).intValue() / (float)total));
                }
                weightedParts.put(key, probVec);
            }
            output.put(QUANTILES_LIST, new NonSpillableDataBag(quantilesList));
            output.put(WEIGHTED_PARTS, weightedParts);
            return output;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private boolean areEqual(Tuple it, Tuple tuple) {
        return this.mComparator.compare(it, tuple) == 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SortComparator
    implements Comparator<Tuple> {
        private SortComparator() {
        }

        @Override
        public int compare(Tuple t1, Tuple t2) {
            switch (FindQuantiles.this.mState) {
                case ALL_ASC: {
                    return t1.compareTo(t2);
                }
                case ALL_DESC: {
                    return t2.compareTo(t1);
                }
                case MIXED: {
                    int sz1 = t1.size();
                    int sz2 = t2.size();
                    if (sz2 < sz1) {
                        return 1;
                    }
                    if (sz2 > sz1) {
                        return -1;
                    }
                    for (int i = 0; i < sz1; ++i) {
                        try {
                            int c = DataType.compare(t1.get(i), t2.get(i));
                            if (c == 0) continue;
                            if (!FindQuantiles.this.mAsc[i]) {
                                c *= -1;
                            }
                            return c;
                        }
                        catch (ExecException e) {
                            throw new RuntimeException("Unable to compare tuples", e);
                        }
                    }
                    return 0;
                }
            }
            return -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        ALL_ASC,
        ALL_DESC,
        MIXED;

    }
}

