/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.pen.util.ExampleTuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POLocalRearrange
extends PhysicalOperator {
    private static final Log log = LogFactory.getLog(POLocalRearrange.class);
    protected static final long serialVersionUID = 1L;
    protected static final TupleFactory mTupleFactory = TupleFactory.getInstance();
    private static final Result ERR_RESULT = new Result();
    protected List<PhysicalPlan> plans;
    protected List<PhysicalPlan> secondaryPlans;
    protected List<ExpressionOperator> leafOps;
    protected List<ExpressionOperator> secondaryLeafOps;
    protected byte index = (byte)-1;
    protected byte keyType;
    protected byte mainKeyType;
    protected byte secondaryKeyType;
    protected boolean mIsDistinct = false;
    protected boolean isCross = false;
    private final Map<Integer, Integer> mProjectedColsMap;
    private final Map<Integer, Integer> mSecondaryProjectedColsMap;
    protected Tuple mFakeTuple = null;
    private boolean mProjectStar = false;
    private boolean mSecondaryProjectStar = false;
    private boolean isKeyTuple = false;
    private boolean isKeyCompound = false;
    private boolean isSecondaryKeyTuple = false;
    private int mProjectedColsMapSize = 0;
    private int mSecondaryProjectedColsMapSize = 0;
    private boolean useSecondaryKey = false;
    private boolean stripKeyFromValue = true;

    public POLocalRearrange(OperatorKey k) {
        this(k, -1, null);
    }

    public POLocalRearrange(OperatorKey k, int rp) {
        this(k, rp, null);
    }

    public POLocalRearrange(OperatorKey k, List<PhysicalOperator> inp) {
        this(k, -1, inp);
    }

    public POLocalRearrange(OperatorKey k, int rp, List<PhysicalOperator> inp) {
        super(k, rp, inp);
        this.leafOps = new ArrayList<ExpressionOperator>();
        this.secondaryLeafOps = new ArrayList<ExpressionOperator>();
        this.mProjectedColsMap = new HashMap<Integer, Integer>();
        this.mSecondaryProjectedColsMap = new HashMap<Integer, Integer>();
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitLocalRearrange(this);
    }

    @Override
    public String name() {
        return this.getAliasString() + "Local Rearrange" + "[" + DataType.findTypeName(this.resultType) + "]" + "{" + DataType.findTypeName(this.keyType) + "}" + "(" + this.mIsDistinct + ") - " + this.mKey.toString();
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }

    public byte getIndex() {
        return this.index;
    }

    public void setIndex(int index) throws ExecException {
        this.setIndex(index, false);
    }

    public void setMultiQueryIndex(int index) throws ExecException {
        this.setIndex(index, true);
    }

    private void setIndex(int index, boolean multiQuery) throws ExecException {
        if (index > 127) {
            int errCode = 1082;
            String msg = multiQuery ? "Merge more than 127 map-reduce jobs not supported." : "Cogroups with more than 127 inputs not supported.";
            throw new ExecException(msg, errCode, 2);
        }
        this.index = multiQuery ? (byte)(index | 0xFFFFFF80) : (byte)index;
    }

    public boolean isDistinct() {
        return this.mIsDistinct;
    }

    public void setDistinct(boolean isDistinct) {
        this.mIsDistinct = isDistinct;
        if (this.mIsDistinct) {
            this.mFakeTuple = mTupleFactory.newTuple();
        }
    }

    @Override
    public void attachInput(Tuple t) {
        super.attachInput(t);
    }

    @Override
    public Result getNextTuple() throws ExecException {
        Result inp;
        block17: {
            inp = null;
            Result res = ERR_RESULT;
            do {
                inp = this.processInput();
                if (inp.returnStatus == 3 || inp.returnStatus == 2) break block17;
            } while (inp.returnStatus == 1);
            for (PhysicalPlan ep : this.plans) {
                ep.attachInput((Tuple)inp.result);
            }
            ArrayList<Result> resLst = new ArrayList<Result>();
            if (this.secondaryPlans != null) {
                for (PhysicalPlan ep : this.secondaryPlans) {
                    ep.attachInput((Tuple)inp.result);
                }
            }
            ArrayList<Result> secondaryResLst = null;
            if (this.secondaryLeafOps != null) {
                secondaryResLst = new ArrayList<Result>();
            }
            for (ExpressionOperator op : this.leafOps) {
                switch (op.getResultType()) {
                    case 5: 
                    case 10: 
                    case 15: 
                    case 20: 
                    case 25: 
                    case 30: 
                    case 50: 
                    case 55: 
                    case 65: 
                    case 70: 
                    case 100: 
                    case 110: 
                    case 120: {
                        res = op.getNext(op.getResultType());
                        break;
                    }
                    default: {
                        log.error((Object)("Invalid result type: " + DataType.findType(op.getResultType())));
                    }
                }
                if (res.returnStatus != 0) {
                    return res;
                }
                resLst.add(res);
            }
            if (this.secondaryLeafOps != null) {
                for (ExpressionOperator op : this.secondaryLeafOps) {
                    switch (op.getResultType()) {
                        case 5: 
                        case 10: 
                        case 15: 
                        case 20: 
                        case 25: 
                        case 30: 
                        case 50: 
                        case 55: 
                        case 65: 
                        case 70: 
                        case 100: 
                        case 110: 
                        case 120: {
                            res = op.getNext(op.getResultType());
                            break;
                        }
                        default: {
                            log.error((Object)("Invalid result type: " + DataType.findType(op.getResultType())));
                        }
                    }
                    if (res.returnStatus != 0 && res.returnStatus != 1) {
                        return new Result();
                    }
                    secondaryResLst.add(res);
                }
            }
            res.result = this.constructLROutput(resLst, secondaryResLst, (Tuple)inp.result);
            res.returnStatus = 0;
            this.detachPlans(this.plans);
            if (this.secondaryPlans != null) {
                this.detachPlans(this.secondaryPlans);
            }
            res.result = this.illustratorMarkup(inp.result, res.result, 0);
            return res;
        }
        return inp;
    }

    private void detachPlans(List<PhysicalPlan> plans) {
        for (PhysicalPlan ep : plans) {
            ep.detachInput();
        }
    }

    protected Object getKeyFromResult(List<Result> resLst, byte type) throws ExecException {
        Object key;
        if (resLst.size() > 1) {
            Tuple t = mTupleFactory.newTuple(resLst.size());
            int i = -1;
            for (Result res : resLst) {
                t.set(++i, res.result);
            }
            key = t;
        } else if (resLst.size() == 1 && type == 110) {
            Object obj = resLst.get((int)0).result;
            if (obj instanceof Tuple) {
                key = obj;
            } else {
                Tuple t = mTupleFactory.newTuple(1);
                t.set(0, resLst.get((int)0).result);
                key = t;
            }
        } else {
            key = resLst.get((int)0).result;
        }
        return key;
    }

    protected Tuple constructLROutput(List<Result> resLst, List<Result> secondaryResLst, Tuple value) throws ExecException {
        Object key;
        Tuple lrOutput = mTupleFactory.newTuple(3);
        lrOutput.set(0, this.index);
        Object secondaryKey = null;
        if (secondaryResLst != null && secondaryResLst.size() > 0) {
            key = this.getKeyFromResult(resLst, this.mainKeyType);
            secondaryKey = this.getKeyFromResult(secondaryResLst, this.secondaryKeyType);
        } else {
            key = this.getKeyFromResult(resLst, this.keyType);
        }
        if (!this.stripKeyFromValue) {
            lrOutput.set(1, key);
            lrOutput.set(2, value);
            return lrOutput;
        }
        if (this.mIsDistinct) {
            lrOutput.set(1, key);
            if (this.illustrator != null) {
                lrOutput.set(2, key);
            } else {
                lrOutput.set(2, this.mFakeTuple);
            }
            return lrOutput;
        }
        if (this.isCross) {
            for (int i = 0; i < this.plans.size(); ++i) {
                value.getAll().remove(0);
            }
            lrOutput.set(1, key);
            lrOutput.set(2, value);
            return lrOutput;
        }
        if (this.useSecondaryKey) {
            Tuple compoundKey = mTupleFactory.newTuple(2);
            compoundKey.set(0, key);
            compoundKey.set(1, secondaryKey);
            lrOutput.set(1, compoundKey);
        } else {
            lrOutput.set(1, key);
        }
        if (this.mProjectedColsMapSize != 0 || this.mProjectStar) {
            Tuple minimalValue = null;
            if (!this.mProjectStar) {
                minimalValue = mTupleFactory.newTuple();
                for (int i = 0; i < value.size(); ++i) {
                    if (this.mProjectedColsMap.get(i) != null) continue;
                    minimalValue.append(value.get(i));
                }
                minimalValue = this.illustratorMarkup(value, minimalValue, -1);
            } else {
                minimalValue = mTupleFactory.newTuple(0);
            }
            lrOutput.set(2, minimalValue);
        } else {
            lrOutput.set(2, value);
        }
        return lrOutput;
    }

    public byte getKeyType() {
        return this.keyType;
    }

    public void setKeyType(byte keyType) {
        if (this.useSecondaryKey) {
            this.mainKeyType = keyType;
        } else {
            this.keyType = keyType;
        }
    }

    public List<PhysicalPlan> getPlans() {
        return this.plans;
    }

    public void setUseSecondaryKey(boolean useSecondaryKey) {
        this.useSecondaryKey = useSecondaryKey;
        this.mainKeyType = this.keyType;
    }

    public void setPlans(List<PhysicalPlan> plans) throws PlanException {
        this.plans = plans;
        this.leafOps.clear();
        int keyIndex = 0;
        for (PhysicalPlan plan : plans) {
            ExpressionOperator leaf = (ExpressionOperator)plan.getLeaves().get(0);
            this.leafOps.add(leaf);
            if (this.isCross) continue;
            if (leaf instanceof POProject) {
                List<ExpressionOperator> preds;
                POProject project = (POProject)leaf;
                if (project.isStar()) {
                    this.mProjectStar = true;
                    this.isKeyTuple = true;
                    break;
                }
                if (project.isProjectToEnd()) {
                    preds = plan.getPredecessors(project);
                    if (preds != null && preds.size() != 0) {
                        throw new AssertionError((Object)"project-range has predecessors");
                    }
                    break;
                }
                try {
                    preds = plan.getPredecessors(leaf);
                    if (preds == null || !(preds.get(0) instanceof POProject)) {
                        this.mProjectedColsMap.put(project.getColumn(), keyIndex);
                    }
                }
                catch (ExecException e) {
                    int errCode = 2070;
                    String msg = "Problem in accessing column from project operator.";
                    throw new PlanException(msg, errCode, 4);
                }
                if (project.getResultType() == 110) {
                    this.isKeyTuple = true;
                }
            }
            ++keyIndex;
        }
        if (keyIndex > 1) {
            this.isKeyTuple = true;
            this.isKeyCompound = true;
        }
        this.mProjectedColsMapSize = this.mProjectedColsMap.size();
    }

    public void setSecondaryPlans(List<PhysicalPlan> plans) throws PlanException {
        this.secondaryPlans = plans;
        this.secondaryLeafOps.clear();
        int keyIndex = 0;
        for (PhysicalPlan plan : plans) {
            ExpressionOperator leaf = (ExpressionOperator)plan.getLeaves().get(0);
            this.secondaryLeafOps.add(leaf);
            if (this.isCross) continue;
            if (leaf instanceof POProject) {
                List<ExpressionOperator> preds;
                POProject project = (POProject)leaf;
                if (project.isStar()) {
                    this.mSecondaryProjectStar = true;
                    this.isSecondaryKeyTuple = true;
                    break;
                }
                if (project.isProjectToEnd()) {
                    preds = plan.getPredecessors(project);
                    if (preds != null && preds.size() != 0) {
                        throw new AssertionError((Object)"project-range has predecessors");
                    }
                    break;
                }
                try {
                    preds = plan.getPredecessors(leaf);
                    if (preds == null || !(preds.get(0) instanceof POProject)) {
                        this.mSecondaryProjectedColsMap.put(project.getColumn(), keyIndex);
                    }
                }
                catch (ExecException e) {
                    int errCode = 2070;
                    String msg = "Problem in accessing column from project operator.";
                    throw new PlanException(msg, errCode, 4);
                }
                if (project.getResultType() == 110) {
                    this.isSecondaryKeyTuple = true;
                }
            }
            ++keyIndex;
        }
        if (keyIndex > 1) {
            this.isSecondaryKeyTuple = true;
        }
        this.mainKeyType = this.keyType;
        this.keyType = (byte)110;
        this.secondaryKeyType = plans.size() > 1 ? (byte)110 : ((PhysicalOperator)plans.get(0).getLeaves().get(0)).getResultType();
        this.mSecondaryProjectedColsMapSize = this.mSecondaryProjectedColsMap.size();
    }

    @Override
    public POLocalRearrange clone() throws CloneNotSupportedException {
        ArrayList<PhysicalPlan> clonePlans = new ArrayList<PhysicalPlan>(this.plans.size());
        for (PhysicalPlan plan : this.plans) {
            clonePlans.add(plan.clone());
        }
        POLocalRearrange clone = new POLocalRearrange(new OperatorKey(this.mKey.scope, NodeIdGenerator.getGenerator().getNextNodeId(this.mKey.scope)), this.requestedParallelism);
        try {
            clone.setPlans(clonePlans);
        }
        catch (PlanException pe) {
            CloneNotSupportedException cnse = new CloneNotSupportedException("Problem with setting plans of " + this.getClass().getSimpleName());
            cnse.initCause(pe);
            throw cnse;
        }
        clone.keyType = this.keyType;
        clone.mainKeyType = this.mainKeyType;
        clone.secondaryKeyType = this.secondaryKeyType;
        clone.useSecondaryKey = this.useSecondaryKey;
        clone.index = this.index;
        clone.setDistinct(this.mIsDistinct);
        clone.addOriginalLocation(this.alias, this.getOriginalLocations());
        return clone;
    }

    public boolean isCross() {
        return this.isCross;
    }

    public void setCross(boolean isCross) {
        this.isCross = isCross;
    }

    public Map<Integer, Integer> getProjectedColsMap() {
        return this.mProjectedColsMap;
    }

    public Map<Integer, Integer> getSecondaryProjectedColsMap() {
        return this.mSecondaryProjectedColsMap;
    }

    public boolean isProjectStar() {
        return this.mProjectStar;
    }

    public boolean isSecondaryProjectStar() {
        return this.mSecondaryProjectStar;
    }

    public boolean isKeyTuple() {
        return this.isKeyTuple;
    }

    public boolean isKeyCompound() {
        return this.isKeyCompound;
    }

    public boolean isSecondaryKeyTuple() {
        return this.isSecondaryKeyTuple;
    }

    public void setPlansFromCombiner(List<PhysicalPlan> plans) throws PlanException {
        this.plans = plans;
        this.leafOps.clear();
        this.mProjectedColsMap.clear();
        int keyIndex = 0;
        for (PhysicalPlan plan : plans) {
            ExpressionOperator leaf = (ExpressionOperator)plan.getLeaves().get(0);
            this.leafOps.add(leaf);
            if (this.isCross) continue;
            if (leaf instanceof POProject) {
                POProject project = (POProject)leaf;
                if (project.isProjectToEnd()) {
                    int errCode = 2021;
                    String msg = "Internal error. Unexpected operator project(*) or (..) in local rearrange inner plan.";
                    throw new PlanException(msg, errCode, 4);
                }
                try {
                    this.mProjectedColsMap.put(project.getColumn(), keyIndex);
                }
                catch (ExecException e) {
                    int errCode = 2070;
                    String msg = "Problem in accessing column from project operator.";
                    throw new PlanException(msg, errCode, 4);
                }
                if (project.getResultType() == 110) {
                    this.isKeyTuple = true;
                }
            }
            ++keyIndex;
        }
        if (keyIndex > 1) {
            this.isKeyTuple = true;
        }
        this.mProjectedColsMapSize = this.mProjectedColsMap.size();
    }

    protected void setStripKeyFromValue(boolean stripKeyFromValue) {
        this.stripKeyFromValue = stripKeyFromValue;
    }

    @Override
    public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
        if (this.illustrator != null && !(out instanceof ExampleTuple)) {
            ExampleTuple tOut = new ExampleTuple((Tuple)out);
            this.illustrator.getLineage().insert(tOut);
            this.illustrator.addData(tOut);
            this.illustrator.getLineage().union(tOut, (Tuple)in);
            tOut.synthetic = ((ExampleTuple)in).synthetic;
            return tOut;
        }
        return (Tuple)out;
    }
}

