/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans;

import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROperPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POCollectedGroup;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POMergeCogroup;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POMergeJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPartialAgg;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStream;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;

public class EndOfAllInputSetter
extends MROpPlanVisitor {
    public EndOfAllInputSetter(MROperPlan plan) {
        super(plan, (PlanWalker<MapReduceOper, MROperPlan>)new DepthFirstWalker<MapReduceOper, MROperPlan>(plan));
    }

    public void visitMROp(MapReduceOper mr) throws VisitorException {
        EndOfAllInputChecker checker = new EndOfAllInputChecker(mr.mapPlan);
        checker.visit();
        if (checker.isEndOfAllInputPresent()) {
            mr.setEndOfAllInputInMap(true);
        }
        checker = new EndOfAllInputChecker(mr.reducePlan);
        checker.visit();
        if (checker.isEndOfAllInputPresent()) {
            mr.setEndOfAllInputInReduce(true);
        }
    }

    static class EndOfAllInputChecker
    extends PhyPlanVisitor {
        private boolean endOfAllInputFlag = false;

        public EndOfAllInputChecker(PhysicalPlan plan) {
            super(plan, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DepthFirstWalker<PhysicalOperator, PhysicalPlan>(plan));
        }

        public void visitStream(POStream stream) throws VisitorException {
            this.endOfAllInputFlag = true;
        }

        public void visitMergeJoin(POMergeJoin join) throws VisitorException {
            this.endOfAllInputFlag = true;
        }

        public void visitCollectedGroup(POCollectedGroup mg) throws VisitorException {
            this.endOfAllInputFlag = true;
        }

        public void visitMergeCoGroup(POMergeCogroup mergeCoGrp) throws VisitorException {
            this.endOfAllInputFlag = true;
        }

        public void visitPartialAgg(POPartialAgg partAgg) {
            this.endOfAllInputFlag = true;
        }

        public boolean isEndOfAllInputPresent() {
            return this.endOfAllInputFlag;
        }
    }
}

