/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine;

import java.io.OutputStream;
import java.util.Iterator;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.LoadFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.executionengine.ExecJob;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.io.ReadToEndLoader;
import org.apache.pig.tools.pigstats.PigStats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HJob
implements ExecJob {
    private final Log log = LogFactory.getLog(this.getClass());
    protected ExecJob.JOB_STATUS status;
    protected PigContext pigContext;
    protected FileSpec outFileSpec;
    protected Exception backendException;
    protected String alias;
    protected POStore poStore;
    private PigStats stats;

    public HJob(ExecJob.JOB_STATUS status, PigContext pigContext, POStore store, String alias) {
        this.status = status;
        this.pigContext = pigContext;
        this.poStore = store;
        this.outFileSpec = this.poStore.getSFile();
        this.alias = alias;
    }

    public HJob(ExecJob.JOB_STATUS status, PigContext pigContext, POStore store, String alias, PigStats stats) {
        this.status = status;
        this.pigContext = pigContext;
        this.poStore = store;
        this.outFileSpec = this.poStore.getSFile();
        this.alias = alias;
        this.stats = stats;
    }

    @Override
    public ExecJob.JOB_STATUS getStatus() {
        return this.status;
    }

    @Override
    public boolean hasCompleted() throws ExecException {
        return true;
    }

    @Override
    public Iterator<Tuple> getResults() throws ExecException {
        ReadToEndLoader p;
        try {
            LoadFunc originalLoadFunc = (LoadFunc)PigContext.instantiateFuncFromSpec(this.outFileSpec.getFuncSpec());
            p = new ReadToEndLoader(originalLoadFunc, ConfigurationUtil.toConfiguration(this.pigContext.getProperties()), this.outFileSpec.getFileName(), 0, this.pigContext);
        }
        catch (Exception e) {
            int errCode = 2088;
            String msg = "Unable to get results for: " + this.outFileSpec;
            throw new ExecException(msg, errCode, 4, e);
        }
        return new Iterator<Tuple>(){
            Tuple t;
            boolean atEnd;

            @Override
            public boolean hasNext() {
                if (this.atEnd) {
                    return false;
                }
                try {
                    if (this.t == null) {
                        this.t = p.getNext();
                    }
                    if (this.t == null) {
                        this.atEnd = true;
                    }
                }
                catch (Exception e) {
                    HJob.this.log.error((Object)e);
                    this.t = null;
                    this.atEnd = true;
                    throw new Error(e);
                }
                return !this.atEnd;
            }

            @Override
            public Tuple next() {
                Tuple next = this.t;
                if (next != null) {
                    this.t = null;
                    return next;
                }
                try {
                    next = p.getNext();
                }
                catch (Exception e) {
                    HJob.this.log.error((Object)e);
                }
                if (next == null) {
                    this.atEnd = true;
                }
                return next;
            }

            @Override
            public void remove() {
                throw new RuntimeException("Removal not supported");
            }
        };
    }

    @Override
    public Properties getConfiguration() {
        return this.pigContext.getProperties();
    }

    @Override
    public PigStats getStatistics() {
        return this.stats;
    }

    @Override
    public void completionNotification(Object cookie) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void kill() throws ExecException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void getLogs(OutputStream log) throws ExecException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void getSTDOut(OutputStream out) throws ExecException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void getSTDError(OutputStream error) throws ExecException {
        throw new UnsupportedOperationException();
    }

    public void setException(Exception e) {
        this.backendException = e;
    }

    @Override
    public Exception getException() {
        return this.backendException;
    }

    @Override
    public String getAlias() throws ExecException {
        return this.alias;
    }

    @Override
    public POStore getPOStore() {
        return this.poStore;
    }
}

