/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.datastorage;

import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.ExecType;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.backend.hadoop.executionengine.shims.HadoopShims;

public class ConfigurationUtil {
    public static Configuration toConfiguration(Properties properties) {
        assert (properties != null);
        Configuration config = new Configuration(false);
        Enumeration<Object> iter = properties.keys();
        while (iter.hasMoreElements()) {
            String key = (String)iter.nextElement();
            String val = properties.getProperty(key);
            config.set(key, val);
        }
        return config;
    }

    public static Properties toProperties(Configuration configuration) {
        Properties properties = new Properties();
        assert (configuration != null);
        for (Map.Entry entry : configuration) {
            properties.put(entry.getKey(), entry.getValue());
        }
        return properties;
    }

    public static void mergeConf(Configuration origConf, Configuration replaceConf) {
        for (Map.Entry entry : replaceConf) {
            origConf.set((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public static Properties getLocalFSProperties() {
        Configuration localConf;
        if (PigMapReduce.sJobContext != null && PigMapReduce.sJobContext.getConfiguration().get("exectype").equals(ExecType.LOCAL.toString())) {
            localConf = new Configuration(false);
            localConf.addResource("core-default.xml");
        } else {
            localConf = new Configuration(true);
            HadoopShims.unsetConf(localConf, "mapreduce.job.cache.files");
        }
        localConf.set("fs.default.name", "file:///");
        Properties props = ConfigurationUtil.toProperties(localConf);
        return props;
    }

    public static void replaceConfigForLocalMode(Configuration configuration) {
        for (Map.Entry entry : configuration) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.startsWith("pig.local.")) continue;
            String realConfKey = key.substring("pig.local.".length());
            configuration.set(realConfKey, value);
        }
    }
}

