/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.jlink;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.jlink.AbstractJLinkMojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.java.DefaultJavaToolChain;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.languages.java.jpms.JavaModuleDescriptor;
import org.codehaus.plexus.languages.java.jpms.LocationManager;
import org.codehaus.plexus.languages.java.jpms.ResolvePathsRequest;
import org.codehaus.plexus.languages.java.jpms.ResolvePathsResult;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.Commandline;

@Mojo(name="jlink", requiresDependencyCollection=ResolutionScope.RUNTIME, defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true)
public class JLinkMojo
extends AbstractJLinkMojo {
    private static final String JMODS = "jmods";
    private List<String> classpathElements;
    private List<String> modulepathElements;
    private Map<String, JavaModuleDescriptor> pathElements;
    @Component
    private LocationManager locationManager;
    @Parameter
    private Map<String, String> jdkToolchain;
    @Parameter(defaultValue="false")
    private boolean stripDebug;
    @Parameter
    private Integer compression;
    @Parameter
    private List<String> limitModules;
    @Parameter
    private List<String> addModules;
    @Parameter
    private String pluginModulePath;
    @Parameter(defaultValue="${project.build.directory}/maven-jlink", required=true, readonly=true)
    private File outputDirectoryImage;
    @Parameter(defaultValue="${project.build.directory}", required=true, readonly=true)
    private File outputDirectory;
    @Parameter
    private String endian;
    private List<String> modulePaths;
    @Parameter(defaultValue="false")
    private boolean bindServices;
    @Parameter
    private String disablePlugin;
    @Parameter(defaultValue="false")
    private boolean ignoreSigningInformation;
    @Parameter(defaultValue="false")
    private boolean noHeaderFiles;
    @Parameter(defaultValue="false")
    private boolean noManPages;
    @Parameter
    private List<String> suggestProviders;
    @Parameter(defaultValue="false")
    private boolean verbose;
    @Component(role=Archiver.class, hint="zip")
    private ZipArchiver zipArchiver;
    @Parameter(defaultValue="${project.build.finalName}", readonly=true)
    private String finalName;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Commandline cmd;
        String jLinkExec = this.getExecutable();
        this.getLog().info((CharSequence)("Toolchain in maven-jlink-plugin: jlink [ " + jLinkExec + " ]"));
        File jLinkExecuteable = new File(jLinkExec);
        File jLinkParent = jLinkExecuteable.getParentFile().getParentFile();
        File jmodsFolder = new File(jLinkParent, JMODS);
        this.getLog().debug((CharSequence)(" Parent: " + jLinkParent.getAbsolutePath()));
        this.getLog().debug((CharSequence)(" jmodsFolder: " + jmodsFolder.getAbsolutePath()));
        this.failIfParametersAreNotInTheirValidValueRanges();
        this.ifOutputDirectoryExistsDelteIt();
        this.preparePaths();
        this.getLog().info((CharSequence)"The following dependencies will be linked into the runtime image:");
        this.addModules = new ArrayList<String>();
        this.modulePaths = new ArrayList<String>();
        for (Map.Entry<String, JavaModuleDescriptor> item : this.pathElements.entrySet()) {
            if (item.getValue() == null) {
                String message = "The given dependency " + item.getKey() + " does not have a module-info.java file. So it can't be linked.";
                this.getLog().error((CharSequence)message);
                throw new MojoFailureException(message);
            }
            this.getLog().debug((CharSequence)("pathElements Item:" + item.getKey() + " v:" + item.getValue().name()));
            this.getLog().info((CharSequence)(" -> module: " + item.getValue().name() + " ( " + item.getKey() + " )"));
            this.addModules.add(item.getValue().name());
            this.modulePaths.add(item.getKey());
        }
        this.modulePaths.add(jmodsFolder.getAbsolutePath());
        try {
            cmd = this.createJLinkCommandLine();
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        cmd.setExecutable(jLinkExec);
        this.executeCommand(cmd, this.outputDirectoryImage);
        File createZipArchiveFromImage = this.createZipArchiveFromImage(this.outputDirectory, this.outputDirectoryImage);
        if (this.projectHasAlreadySetAnArtifact()) {
            throw new MojoExecutionException("You have to use a classifier to attach supplemental artifacts to the project instead of replacing them.");
        }
        this.getProject().getArtifact().setFile(createZipArchiveFromImage);
    }

    private List<File> getCompileClasspathElements(MavenProject project) {
        ArrayList<File> list = new ArrayList<File>(project.getArtifacts().size() + 1);
        for (Artifact a : project.getArtifacts()) {
            list.add(a.getFile());
        }
        return list;
    }

    private void preparePaths() {
        this.modulepathElements = new ArrayList<String>();
        this.classpathElements = new ArrayList<String>();
        this.pathElements = new LinkedHashMap<String, JavaModuleDescriptor>();
        try {
            List<File> dependencyArtifacts = this.getCompileClasspathElements(this.getProject());
            ResolvePathsRequest request = ResolvePathsRequest.withFiles(dependencyArtifacts);
            Toolchain toolchain = this.getToolchain();
            if (toolchain != null && toolchain instanceof DefaultJavaToolChain) {
                request.setJdkHome((Object)new File(((DefaultJavaToolChain)toolchain).getJavaHome()));
            }
            ResolvePathsResult resolvePathsResult = this.locationManager.resolvePaths(request);
            JavaModuleDescriptor moduleDescriptor = resolvePathsResult.getMainModuleDescriptor();
            for (Map.Entry entry : resolvePathsResult.getModulepathElements().entrySet()) {
                if (!ResolvePathsResult.ModuleNameSource.FILENAME.equals(entry.getValue())) continue;
                String message = "Required filename-based automodules detected. Please don't publish this project to a public artifact repository!";
                if (moduleDescriptor.exports().isEmpty()) {
                    this.getLog().info((CharSequence)"Required filename-based automodules detected. Please don't publish this project to a public artifact repository!");
                    break;
                }
                this.writeBoxedWarning("Required filename-based automodules detected. Please don't publish this project to a public artifact repository!");
                break;
            }
            for (Map.Entry entry : resolvePathsResult.getPathElements().entrySet()) {
                this.pathElements.put(((File)entry.getKey()).getPath(), (JavaModuleDescriptor)entry.getValue());
            }
            for (File file : resolvePathsResult.getClasspathElements()) {
                this.classpathElements.add(file.getPath());
            }
            for (File file : resolvePathsResult.getModulepathElements().keySet()) {
                this.modulepathElements.add(file.getPath());
            }
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)e.getMessage());
        }
    }

    private String getExecutable() throws MojoFailureException {
        String jLinkExec;
        try {
            jLinkExec = this.getJLinkExecutable();
        }
        catch (IOException e) {
            throw new MojoFailureException("Unable to find jlink command: " + e.getMessage(), (Throwable)e);
        }
        return jLinkExec;
    }

    private boolean projectHasAlreadySetAnArtifact() {
        if (this.getProject().getArtifact().getFile() != null) {
            return this.getProject().getArtifact().getFile().isFile();
        }
        return false;
    }

    private File createZipArchiveFromImage(File outputDirectory, File outputDirectoryImage) throws MojoExecutionException {
        this.zipArchiver.addDirectory(outputDirectoryImage);
        File resultArchive = this.getArchiveFile(outputDirectory, this.finalName, null, "zip");
        this.zipArchiver.setDestFile(resultArchive);
        try {
            this.zipArchiver.createArchive();
        }
        catch (ArchiverException e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        return resultArchive;
    }

    private void failIfParametersAreNotInTheirValidValueRanges() throws MojoFailureException {
        if (this.compression != null && (this.compression < 0 || this.compression > 2)) {
            String message = "The given compression parameters " + this.compression + " is not in the valid value range from 0..2";
            this.getLog().error((CharSequence)message);
            throw new MojoFailureException(message);
        }
        if (!(this.endian == null || "big".equals(this.endian) && "little".equals(this.endian))) {
            String message = "The given endian parameter " + this.endian + " does not contain one of the following values: 'little' or 'big'.";
            this.getLog().error((CharSequence)message);
            throw new MojoFailureException(message);
        }
    }

    private void ifOutputDirectoryExistsDelteIt() throws MojoExecutionException {
        if (this.outputDirectoryImage.exists()) {
            try {
                this.getLog().debug((CharSequence)("Deleting existing " + this.outputDirectoryImage.getAbsolutePath()));
                FileUtils.forceDelete((File)this.outputDirectoryImage);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"IOException", (Throwable)e);
                throw new MojoExecutionException("Failure during deletion of " + this.outputDirectoryImage.getAbsolutePath() + " occured.");
            }
        }
    }

    private Commandline createJLinkCommandLine() throws IOException {
        CharSequence sb;
        File file = new File(this.outputDirectoryImage.getParentFile(), "jlinkArgs");
        if (!this.getLog().isDebugEnabled()) {
            file.deleteOnExit();
        }
        file.getParentFile().mkdirs();
        file.createNewFile();
        PrintStream argsFile = new PrintStream(file);
        if (this.stripDebug) {
            argsFile.println("--strip-debug");
        }
        if (this.bindServices) {
            argsFile.println("--bind-services");
        }
        if (this.endian != null) {
            argsFile.println("--endians");
            argsFile.println(this.endian);
        }
        if (this.ignoreSigningInformation) {
            argsFile.println("--ignore-signing-information");
        }
        if (this.compression != null) {
            argsFile.println("--compression");
            argsFile.println(this.compression);
        }
        if (this.disablePlugin != null) {
            argsFile.println("--disable-plugin");
            argsFile.append('\"').append(this.disablePlugin).println('\"');
        }
        if (this.modulePaths != null) {
            argsFile.println("--module-path");
            argsFile.append('\"').append(this.getPlatformDependSeparateList(this.modulePaths).replace("\\", "\\\\")).println('\"');
        }
        if (this.noHeaderFiles) {
            argsFile.println("--no-header-files");
        }
        if (this.noManPages) {
            argsFile.println("--no-man-pages");
        }
        if (this.hasSuggestProviders()) {
            argsFile.println("--suggest-providers");
            sb = this.getCommaSeparatedList(this.suggestProviders);
            argsFile.println((String)sb);
        }
        if (this.hasLimitModules()) {
            argsFile.println("--limit-modules");
            sb = this.getCommaSeparatedList(this.limitModules);
            argsFile.println((String)sb);
        }
        if (this.hasModules()) {
            argsFile.println("--add-modules");
            sb = this.getCommaSeparatedList(this.addModules);
            argsFile.append('\"').append(((String)sb).replace("\\", "\\\\")).println('\"');
        }
        if (this.pluginModulePath != null) {
            argsFile.println("--plugin-module-path");
            sb = this.convertSeparatedModulePathToPlatformSeparatedModulePath(this.pluginModulePath);
            argsFile.append('\"').append(((StringBuilder)sb).toString().replace("\\", "\\\\")).println('\"');
        }
        if (this.outputDirectory != null) {
            argsFile.println("--output");
            argsFile.println(this.outputDirectoryImage);
        }
        if (this.verbose) {
            argsFile.println("--verbose");
        }
        argsFile.close();
        Commandline cmd = new Commandline();
        cmd.createArg().setValue('@' + file.getAbsolutePath());
        return cmd;
    }

    private boolean hasSuggestProviders() {
        return this.suggestProviders != null && !this.suggestProviders.isEmpty();
    }

    private boolean hasLimitModules() {
        return this.limitModules != null && !this.limitModules.isEmpty();
    }

    private boolean hasModules() {
        return this.addModules != null && !this.addModules.isEmpty();
    }

    private void writeBoxedWarning(String message) {
        String line = StringUtils.repeat((String)"*", (int)(message.length() + 4));
        this.getLog().warn((CharSequence)line);
        this.getLog().warn((CharSequence)("* " + MessageUtils.buffer().strong((Object)message) + " *"));
        this.getLog().warn((CharSequence)line);
    }
}

