/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules.property;

import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rules.property.AbstractPropertyEnforcerRule;
import org.apache.maven.enforcer.rules.utils.ExpressionEvaluator;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;

@Named(value="requireProperty")
public final class RequireProperty
extends AbstractPropertyEnforcerRule {
    private String property = null;
    private final ExpressionEvaluator evaluator;

    @Inject
    public RequireProperty(ExpressionEvaluator evaluator) {
        this.evaluator = Objects.requireNonNull(evaluator);
    }

    public void setProperty(String property) {
        this.property = property;
    }

    @Override
    public Object resolveValue() throws EnforcerRuleException {
        try {
            return this.evaluator.evaluate("${" + this.property + "}");
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException((Throwable)e);
        }
    }

    @Override
    public String getPropertyName() {
        return this.property;
    }

    @Override
    public String getName() {
        return "Property";
    }

    public String toString() {
        return String.format("RequireProperty[message=%s, property=%s, regex=%s, regexMessage=%s]", this.getMessage(), this.property, this.getRegex(), this.getRegexMessage());
    }
}

