/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules.dependency;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.util.graph.visitor.TreeDependencyVisitor;

@Named
class ResolverUtil {
    private final RepositorySystem repositorySystem;
    private final MavenSession session;

    @Inject
    ResolverUtil(RepositorySystem repositorySystem, MavenSession session) {
        this.repositorySystem = Objects.requireNonNull(repositorySystem);
        this.session = Objects.requireNonNull(session);
    }

    DependencyNode resolveTransitiveDependenciesVerbose(List<String> excludedScopes) throws EnforcerRuleException {
        return this.resolveTransitiveDependencies(true, true, excludedScopes);
    }

    DependencyNode resolveTransitiveDependencies() throws EnforcerRuleException {
        return this.resolveTransitiveDependencies(false, true, Arrays.asList("test", "provided"));
    }

    DependencyNode resolveTransitiveDependencies(boolean excludeOptional, List<String> excludedScopes) throws EnforcerRuleException {
        return this.resolveTransitiveDependencies(false, excludeOptional, excludedScopes);
    }

    private DependencyNode resolveTransitiveDependencies(boolean verbose, boolean excludeOptional, List<String> excludedScopes) throws EnforcerRuleException {
        try {
            RepositorySystemSession repositorySystemSession = this.session.getRepositorySession();
            if (verbose) {
                DefaultRepositorySystemSession defaultRepositorySystemSession = new DefaultRepositorySystemSession(repositorySystemSession);
                defaultRepositorySystemSession.setConfigProperty("aether.conflictResolver.verbose", (Object)true);
                defaultRepositorySystemSession.setConfigProperty("aether.dependencyManager.verbose", (Object)true);
                repositorySystemSession = defaultRepositorySystemSession;
            }
            MavenProject project = this.session.getCurrentProject();
            ArtifactTypeRegistry artifactTypeRegistry = this.session.getRepositorySession().getArtifactTypeRegistry();
            List dependencies = project.getDependencies().stream().filter(d -> !excludeOptional || !d.isOptional()).filter(d -> !excludedScopes.contains(d.getScope())).map(d -> RepositoryUtils.toDependency((Dependency)d, (ArtifactTypeRegistry)artifactTypeRegistry)).collect(Collectors.toList());
            List managedDependencies = Optional.ofNullable(project.getDependencyManagement()).map(DependencyManagement::getDependencies).map(list -> list.stream().map(d -> RepositoryUtils.toDependency((Dependency)d, (ArtifactTypeRegistry)artifactTypeRegistry)).collect(Collectors.toList())).orElse(null);
            CollectRequest collectRequest = new CollectRequest(dependencies, managedDependencies, project.getRemoteProjectRepositories());
            collectRequest.setRootArtifact(RepositoryUtils.toArtifact((Artifact)project.getArtifact()));
            return this.repositorySystem.collectDependencies(repositorySystemSession, collectRequest).getRoot();
        }
        catch (DependencyCollectionException e) {
            throw new EnforcerRuleException("Could not build dependency tree " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }

    public CharSequence dumpTree(DependencyNode rootNode) {
        final StringBuilder result = new StringBuilder(System.lineSeparator());
        rootNode.accept((DependencyVisitor)new TreeDependencyVisitor(new DependencyVisitor(){
            String indent = "";

            public boolean visitEnter(DependencyNode dependencyNode) {
                result.append(this.indent);
                result.append("Node: ").append(dependencyNode);
                result.append(" data map: ").append(dependencyNode.getData());
                result.append(System.lineSeparator());
                this.indent = this.indent + "  ";
                return true;
            }

            public boolean visitLeave(DependencyNode dependencyNode) {
                this.indent = this.indent.substring(0, this.indent.length() - 2);
                return true;
            }
        }));
        return result;
    }
}

