/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules.dependency;

import java.text.ChoiceFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rules.AbstractStandardEnforcerRule;
import org.apache.maven.enforcer.rules.dependency.ResolverUtil;
import org.apache.maven.enforcer.rules.utils.ArtifactMatcher;
import org.apache.maven.enforcer.rules.utils.ArtifactUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.util.graph.visitor.TreeDependencyVisitor;
import org.eclipse.aether.version.VersionConstraint;

@Named(value="banDynamicVersions")
public final class BanDynamicVersions
extends AbstractStandardEnforcerRule {
    private static final String RELEASE = "RELEASE";
    private static final String LATEST = "LATEST";
    private static final String SNAPSHOT_SUFFIX = "-SNAPSHOT";
    private boolean allowSnapshots;
    private boolean allowLatest;
    private boolean allowRelease;
    private boolean allowRanges;
    private boolean allowRangesWithIdenticalBounds;
    private boolean excludeOptionals;
    private List<String> excludedScopes;
    private List<String> ignores = null;
    private final ResolverUtil resolverUtil;

    @Inject
    public BanDynamicVersions(MavenProject project, RepositorySystem repoSystem, MavenSession mavenSession, ResolverUtil resolverUtil) {
        this.resolverUtil = Objects.requireNonNull(resolverUtil);
    }

    public void execute() throws EnforcerRuleException {
        try {
            DependencyNode rootDependency = this.resolverUtil.resolveTransitiveDependencies(this.excludeOptionals, this.excludedScopes);
            List<String> violations = this.collectDependenciesWithBannedDynamicVersions(rootDependency);
            if (!violations.isEmpty()) {
                ChoiceFormat dependenciesFormat = new ChoiceFormat("1#dependency|1<dependencies");
                throw new EnforcerRuleException("Found " + violations.size() + " " + dependenciesFormat.format(violations.size()) + " with dynamic versions." + System.lineSeparator() + String.join((CharSequence)System.lineSeparator(), violations));
            }
        }
        catch (DependencyCollectionException e) {
            throw new EnforcerRuleException("Could not retrieve dependency metadata for project", (Exception)((Object)e));
        }
    }

    private static String dumpIntermediatePath(Collection<DependencyNode> path) {
        if (path.isEmpty()) {
            return "";
        }
        return " via " + path.stream().map(n -> n.getArtifact().toString()).collect(Collectors.joining(" -> "));
    }

    private List<String> collectDependenciesWithBannedDynamicVersions(DependencyNode rootDependency) throws DependencyCollectionException {
        ExcludeArtifactPatternsPredicate predicate = this.ignores != null && !this.ignores.isEmpty() ? new ExcludeArtifactPatternsPredicate(this.ignores) : d -> true;
        BannedDynamicVersionCollector bannedDynamicVersionCollector = new BannedDynamicVersionCollector(predicate);
        TreeDependencyVisitor depVisitor = new TreeDependencyVisitor((DependencyVisitor)bannedDynamicVersionCollector);
        rootDependency.accept((DependencyVisitor)depVisitor);
        return bannedDynamicVersionCollector.getViolations();
    }

    public String toString() {
        return String.format("BanDynamicVersions[allowSnapshots=%b, allowLatest=%b, allowRelease=%b, allowRanges=%b, allowRangesWithIdenticalBounds=%b, excludeOptionals=%b, excludedScopes=%s, ignores=%s]", this.allowSnapshots, this.allowLatest, this.allowRelease, this.allowRanges, this.allowRangesWithIdenticalBounds, this.excludeOptionals, this.excludedScopes, this.ignores);
    }

    private static final class ExcludeArtifactPatternsPredicate
    implements Predicate<DependencyNode> {
        private final ArtifactMatcher artifactMatcher;

        ExcludeArtifactPatternsPredicate(List<String> excludes) {
            this.artifactMatcher = new ArtifactMatcher(excludes, Collections.emptyList());
        }

        @Override
        public boolean test(DependencyNode depNode) {
            return this.artifactMatcher.match(ArtifactUtils.toArtifact(depNode));
        }
    }

    private final class BannedDynamicVersionCollector
    implements DependencyVisitor {
        private final Deque<DependencyNode> nodeStack = new ArrayDeque<DependencyNode>();
        private boolean isRoot = true;
        private List<String> violations;
        private final Predicate<DependencyNode> predicate;

        public List<String> getViolations() {
            return this.violations;
        }

        BannedDynamicVersionCollector(Predicate<DependencyNode> predicate) {
            this.predicate = predicate;
            this.isRoot = true;
            this.violations = new ArrayList<String>();
        }

        private boolean isBannedDynamicVersion(VersionConstraint versionConstraint) {
            if (versionConstraint.getVersion() != null) {
                if (versionConstraint.getVersion().toString().equals(BanDynamicVersions.LATEST)) {
                    return !BanDynamicVersions.this.allowLatest;
                }
                if (versionConstraint.getVersion().toString().equals(BanDynamicVersions.RELEASE)) {
                    return !BanDynamicVersions.this.allowRelease;
                }
                if (versionConstraint.getVersion().toString().endsWith(BanDynamicVersions.SNAPSHOT_SUFFIX)) {
                    return !BanDynamicVersions.this.allowSnapshots;
                }
            } else {
                if (versionConstraint.getRange() != null) {
                    if (BanDynamicVersions.this.allowRangesWithIdenticalBounds && Objects.equals(versionConstraint.getRange().getLowerBound(), versionConstraint.getRange().getUpperBound())) {
                        return false;
                    }
                    return !BanDynamicVersions.this.allowRanges;
                }
                BanDynamicVersions.this.getLog().warn((CharSequence)("Unexpected version constraint found: " + versionConstraint));
            }
            return false;
        }

        public boolean visitEnter(DependencyNode node) {
            if (this.isRoot) {
                this.isRoot = false;
            } else {
                BanDynamicVersions.this.getLog().debug((CharSequence)("Found node " + node + " with version constraint " + node.getVersionConstraint()));
                if (this.predicate.test(node) && this.isBannedDynamicVersion(node.getVersionConstraint())) {
                    this.violations.add("Dependency " + node.getDependency() + BanDynamicVersions.dumpIntermediatePath(this.nodeStack) + " is referenced with a banned dynamic version " + node.getVersionConstraint());
                    return false;
                }
                this.nodeStack.addLast(node);
            }
            return true;
        }

        public boolean visitLeave(DependencyNode node) {
            if (!this.nodeStack.isEmpty()) {
                this.nodeStack.removeLast();
            }
            return true;
        }
    }
}

