/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kafka.api.ApiVersion$;
import kafka.api.LeaderAndIsr;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.security.auth.Acl;
import kafka.security.auth.Allow$;
import kafka.security.auth.Deny$;
import kafka.security.auth.Group$;
import kafka.security.auth.Operation;
import kafka.security.auth.PermissionType;
import kafka.security.auth.Read$;
import kafka.security.auth.Resource;
import kafka.security.auth.ResourceType;
import kafka.security.auth.ResourceType$;
import kafka.security.auth.SimpleAclAuthorizer;
import kafka.security.auth.Topic$;
import kafka.server.ConfigType$;
import kafka.utils.CoreUtils$;
import kafka.zk.AdminZNode$;
import kafka.zk.BrokerInfo;
import kafka.zk.BrokerInfo$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import kafka.zk.ConfigEntityZNode$;
import kafka.zk.ConsumerOffset$;
import kafka.zk.ControllerEpochZNode$;
import kafka.zk.ControllerZNode$;
import kafka.zk.DelegationTokenChangeNotificationZNode$;
import kafka.zk.DelegationTokensZNode$;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import kafka.zk.KafkaZkClientTest$;
import kafka.zk.ReassignPartitionsZNode$;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zk.TopicZNode$;
import kafka.zk.ZkAclStore;
import kafka.zk.ZkAclStore$;
import kafka.zk.ZkData$;
import kafka.zk.ZkVersion$;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zookeeper.CreateResponse;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.ResponseMetadata;
import kafka.zookeeper.SetDataResponse;
import kafka.zookeeper.ZNodeChangeHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\rEd\u0001B\u0001\u0003\u0001\u001d\u0011\u0011cS1gW\u0006T6n\u00117jK:$H+Z:u\u0015\t\u0019A!\u0001\u0002{W*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\u000b\u001b\u0005\u0011\u0011BA\u0006\u0003\u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tg\")Q\u0002\u0001C\u0001\u001d\u00051A(\u001b8jiz\"\u0012a\u0004\t\u0003\u0013\u0001Aq!\u0005\u0001C\u0002\u0013%!#A\u0003he>,\b/F\u0001\u0014!\t!\u0012$D\u0001\u0016\u0015\t1r#\u0001\u0003mC:<'\"\u0001\r\u0002\t)\fg/Y\u0005\u00035U\u0011aa\u0015;sS:<\u0007B\u0002\u000f\u0001A\u0003%1#\u0001\u0004he>,\b\u000f\t\u0005\b=\u0001\u0011\r\u0011\"\u0003\u0013\u0003\u0019!x\u000e]5dc!1\u0001\u0005\u0001Q\u0001\nM\tq\u0001^8qS\u000e\f\u0004\u0005C\u0004#\u0001\t\u0007I\u0011\u0002\n\u0002\rQ|\u0007/[23\u0011\u0019!\u0003\u0001)A\u0005'\u00059Ao\u001c9jGJ\u0002\u0003b\u0002\u0014\u0001\u0005\u0004%\taJ\u0001\u0011i>\u0004\u0018n\u0019)beRLG/[8ocA*\u0012\u0001\u000b\t\u0003SEj\u0011A\u000b\u0006\u0003W1\naaY8n[>t'BA\u0003.\u0015\tqs&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002a\u0005\u0019qN]4\n\u0005IR#A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0007i\u0001\u0001\u000b\u0011\u0002\u0015\u0002#Q|\u0007/[2QCJ$\u0018\u000e^5p]F\u0002\u0004\u0005C\u00047\u0001\t\u0007I\u0011A\u0014\u0002!Q|\u0007/[2QCJ$\u0018\u000e^5p]F\n\u0004B\u0002\u001d\u0001A\u0003%\u0001&A\tu_BL7\rU1si&$\u0018n\u001c82c\u0001BqA\u000f\u0001C\u0002\u0013\u0005q%\u0001\tu_BL7\rU1si&$\u0018n\u001c83a!1A\b\u0001Q\u0001\n!\n\u0011\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gN\r\u0019!\u0011\u001dq\u0004A1A\u0005\u0002}\nA\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gn]\u00191?F\nT#\u0001!\u0011\u0007\u00053\u0005&D\u0001C\u0015\t\u0019E)\u0001\u0006d_2dWm\u0019;j_:T\u0011!R\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000f\n\u00131aU3r\u0011\u0019I\u0005\u0001)A\u0005\u0001\u0006)Bo\u001c9jGB\u000b'\u000f^5uS>t7/\r\u0019`cE\u0002\u0003\"C&\u0001\u0001\u0004\u0005\r\u0011\"\u0001M\u00035yG\u000f[3s5.\u001cE.[3oiV\tQ\n\u0005\u0002\n\u001d&\u0011qJ\u0001\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\t\u0013E\u0003\u0001\u0019!a\u0001\n\u0003\u0011\u0016!E8uQ\u0016\u0014(l[\"mS\u0016tGo\u0018\u0013fcR\u00111k\u0016\t\u0003)Vk\u0011\u0001R\u0005\u0003-\u0012\u0013A!\u00168ji\"9\u0001\fUA\u0001\u0002\u0004i\u0015a\u0001=%c!1!\f\u0001Q!\n5\u000bab\u001c;iKJT6n\u00117jK:$\b\u0005C\u0003]\u0001\u0011\u0005S,A\u0003tKR,\u0006\u000fF\u0001TQ\tYv\f\u0005\u0002aG6\t\u0011M\u0003\u0002c_\u0005)!.\u001e8ji&\u0011A-\u0019\u0002\u0007\u0005\u00164wN]3\t\u000b\u0019\u0004A\u0011I/\u0002\u0011Q,\u0017M\u001d#po:D#!\u001a5\u0011\u0005\u0001L\u0017B\u00016b\u0005\u0015\te\r^3s\u0011\u001da\u0007A1A\u0005\n\u001d\na\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004o\u0001\u0001\u0006I\u0001K\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8oA!)\u0001\u000f\u0001C\u0001;\u0006YB/Z:u'\u0016$\u0018I\u001c3HKR\u001cuN\\:v[\u0016\u0014xJ\u001a4tKRD#a\u001c:\u0011\u0005\u0001\u001c\u0018B\u0001;b\u0005\u0011!Vm\u001d;\t\u000bY\u0004A\u0011A/\u00027Q,7\u000f^$fi\u000e{gn];nKJ|eMZ:fi:{G)\u0019;bQ\t)(\u000fC\u0003z\u0001\u0011\u0005Q,A\nuKN$H)\u001a7fi\u0016\u0014VmY;sg&4X\r\u000b\u0002ye\")A\u0010\u0001C\u0001;\u0006\u0019B/Z:u\u0007J,\u0017\r^3SK\u000e,(o]5wK\"\u00121P\u001d\u0005\u0006\u007f\u0002!\t!X\u0001\u001bi\u0016\u001cH\u000fV8qS\u000e\f5o]5h]6,g\u000e^'fi\"|Gm\u001d\u0015\u0003}JDa!!\u0002\u0001\t\u0003i\u0016!\u0006;fgR<U\r\u001e#bi\u0006\fe\u000e\u001a,feNLwN\u001c\u0015\u0004\u0003\u0007\u0011\bBBA\u0006\u0001\u0011\u0005Q,A\ruKN$8i\u001c8eSRLwN\\1m+B$\u0017\r^3QCRD\u0007fAA\u0005e\"1\u0011\u0011\u0003\u0001\u0005\u0002u\u000b!\u0005^3ti\u000e\u0013X-\u0019;f'\u0016\fX/\u001a8uS\u0006d\u0007+\u001a:tSN$XM\u001c;QCRD\u0007fAA\be\"1\u0011q\u0003\u0001\u0005\u0002u\u000bq\u0003^3tiB\u0013x\u000e]1hCR,\u0017j\u001d:DQ\u0006tw-Z:)\u0007\u0005U!\u000f\u0003\u0004\u0002\u001e\u0001!\t!X\u0001!i\u0016\u001cH/S:s\u0007\"\fgnZ3O_RLg-[2bi&|gnR3ui\u0016\u00148\u000fK\u0002\u0002\u001cIDa!a\t\u0001\t\u0003i\u0016A\t;fgRL5O]\"iC:<WMT8uS\u001aL7-\u0019;j_:\u001cH)\u001a7fi&|g\u000eK\u0002\u0002\"IDa!!\u000b\u0001\t\u0003i\u0016a\u0005;fgR\u0004&o\u001c9bO\u0006$X\rT8h\t&\u0014\bfAA\u0014e\"1\u0011q\u0006\u0001\u0005\u0002u\u000b\u0011\u0003^3ti2{w\rR5s\u000f\u0016$H/\u001a:tQ\r\tiC\u001d\u0005\u0007\u0003k\u0001A\u0011A/\u0002IQ,7\u000f\u001e'pO\u0012K'/\u0012<f]Rtu\u000e^5gS\u000e\fG/[8og\u0012+G.\u001a;j_:D3!a\rs\u0011\u0019\tY\u0004\u0001C\u0001;\u0006AC/Z:u'\u0016$x)\u001a;B]\u0012$U\r\\3uKB\u000b'\u000f^5uS>t'+Z1tg&<g.\\3oi\"\u001a\u0011\u0011\b:\t\r\u0005\u0005\u0003\u0001\"\u0001^\u0003I!Xm\u001d;HKR$\u0015\r^1B]\u0012\u001cF/\u0019;)\u0007\u0005}\"\u000f\u0003\u0004\u0002H\u0001!\t!X\u0001\u0010i\u0016\u001cHoR3u\u0007\"LG\u000e\u001a:f]\"\u001a\u0011Q\t:\t\r\u00055\u0003\u0001\"\u0001^\u0003a!Xm\u001d;BG2l\u0015M\\1hK6,g\u000e^'fi\"|Gm\u001d\u0015\u0004\u0003\u0017\u0012\bBBA*\u0001\u0011\u0005Q,\u0001\buKN$H)\u001a7fi\u0016\u0004\u0016\r\u001e5)\u0007\u0005E#\u000f\u0003\u0004\u0002Z\u0001!\t!X\u0001\u0015i\u0016\u001cH\u000fR3mKR,Gk\u001c9jGjsu\u000eZ3)\u0007\u0005]#\u000f\u0003\u0004\u0002`\u0001!\t!X\u0001\u001bi\u0016\u001cH\u000fR3mKR,Gk\u001c9jGB\u000bG\u000f['fi\"|Gm\u001d\u0015\u0004\u0003;\u0012\bbBA3\u0001\u0011%\u0011qM\u0001\u001bCN\u001cXM\u001d;QCRDW\t_5ti\u0016t7-Z!oI\u0012\u000bG/\u0019\u000b\u0006'\u0006%\u0014\u0011\u0010\u0005\t\u0003W\n\u0019\u00071\u0001\u0002n\u0005aQ\r\u001f9fGR,G\rU1uQB!\u0011qNA;\u001d\r!\u0016\u0011O\u0005\u0004\u0003g\"\u0015A\u0002)sK\u0012,g-C\u0002\u001b\u0003oR1!a\u001dE\u0011!\tY(a\u0019A\u0002\u00055\u0014\u0001\u00023bi\u0006Da!a \u0001\t\u0003i\u0016!\t;fgR\u001c%/Z1uKR{7.\u001a8DQ\u0006tw-\u001a(pi&4\u0017nY1uS>t\u0007fAA?e\"1\u0011Q\u0011\u0001\u0005\u0002u\u000b\u0011\u0005^3ti\u0016sG/\u001b;z\u0007>tg-[4NC:\fw-Z7f]RlU\r\u001e5pIND3!a!s\u0011\u0019\tY\t\u0001C\u0001;\u0006\u0011C/Z:u\u0007J,\u0017\r^3D_:4\u0017nZ\"iC:<WMT8uS\u001aL7-\u0019;j_:D3!!#s\u0011\u001d\t\t\n\u0001C\u0005\u0003'\u000bab\u0019:fCR,Gj\\4Qe>\u00048\u000f\u0006\u0003\u0002\u0016\u0006\u0005\u0006\u0003BAL\u0003;k!!!'\u000b\u0007\u0005mu#\u0001\u0003vi&d\u0017\u0002BAP\u00033\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0011!\t\u0019+a$A\u0002\u0005\u0015\u0016!\u00032zi\u0016\u001c\bK]8q!\r!\u0016qU\u0005\u0004\u0003S#%aA%oi\"I\u0011Q\u0016\u0001C\u0002\u0013%\u0011qV\u0001\tY><\u0007K]8qgV\u0011\u0011Q\u0013\u0005\t\u0003g\u0003\u0001\u0015!\u0003\u0002\u0016\u0006IAn\\4Qe>\u00048\u000f\t\u0005\u0007\u0003o\u0003A\u0011A/\u0002#Q,7\u000f^$fi2{wmQ8oM&<7\u000fK\u0002\u00026JDq!!0\u0001\t\u0013\ty,\u0001\tde\u0016\fG/\u001a\"s_.,'/\u00138g_Ra\u0011\u0011YAd\u0003\u0017\fy-a5\u0002hB\u0019\u0011\"a1\n\u0007\u0005\u0015'A\u0001\u0006Ce>\\WM]%oM>D\u0001\"!3\u0002<\u0002\u0007\u0011QU\u0001\u0003S\u0012D\u0001\"!4\u0002<\u0002\u0007\u0011QN\u0001\u0005Q>\u001cH\u000f\u0003\u0005\u0002R\u0006m\u0006\u0019AAS\u0003\u0011\u0001xN\u001d;\t\u0011\u0005U\u00171\u0018a\u0001\u0003/\f\u0001c]3dkJLG/\u001f)s_R|7m\u001c7\u0011\t\u0005e\u00171]\u0007\u0003\u00037TA!!8\u0002`\u0006!\u0011-\u001e;i\u0015\r\t\tOK\u0001\tg\u0016\u001cWO]5us&!\u0011Q]An\u0005A\u0019VmY;sSRL\bK]8u_\u000e|G\u000e\u0003\u0006\u0002j\u0006m\u0006\u0013!a\u0001\u0003W\fAA]1dWB)A+!<\u0002n%\u0019\u0011q\u001e#\u0003\r=\u0003H/[8o\u0011\u0019\t\u0019\u0010\u0001C\u0001;\u00061B/Z:u%\u0016<\u0017n\u001d;fe\n\u0013xn[3s\u0013:4w\u000eK\u0002\u0002rJDa!!?\u0001\t\u0003i\u0016\u0001\u0006;fgR<U\r\u001e\"s_.,'/T3uQ>$7\u000fK\u0002\u0002xJDa!a@\u0001\t\u0003i\u0016\u0001\u0006;fgR,\u0006\u000fZ1uK\n\u0013xn[3s\u0013:4w\u000eK\u0002\u0002~JDqA!\u0002\u0001\t\u0013\u00119!A\bti\u0006$x+\u001b;i-\u0016\u00148/[8o)\u0011\u0011IAa\u0006\u0011\t\t-!1C\u0007\u0003\u0005\u001bQA!a\u001f\u0003\u0010)\u0019!\u0011C\u0017\u0002\u0013i|wn[3fa\u0016\u0014\u0018\u0002\u0002B\u000b\u0005\u001b\u0011Aa\u0015;bi\"A!\u0011\u0004B\u0002\u0001\u0004\t)+A\u0004wKJ\u001c\u0018n\u001c8\t\u000f\tu\u0001\u0001\"\u0003\u0003 \u0005aB.Z1eKJL5O]!oI\u000e{g\u000e\u001e:pY2,'/\u00129pG\"\u001cHC\u0002B\u0011\u0005g\u00119\u0004E\u0004\u0002p\t\r\u0002Fa\n\n\t\t\u0015\u0012q\u000f\u0002\u0004\u001b\u0006\u0004\b\u0003\u0002B\u0015\u0005_i!Aa\u000b\u000b\u0007\t5B!\u0001\u0006d_:$(o\u001c7mKJLAA!\r\u0003,\tYB*Z1eKJL5O]!oI\u000e{g\u000e\u001e:pY2,'/\u00129pG\"D\u0001B!\u000e\u0003\u001c\u0001\u0007\u0011QU\u0001\u0006gR\fG/\u001a\u0005\t\u0005s\u0011Y\u00021\u0001\u0002&\u0006I!p\u001b,feNLwN\u001c\u0005\n\u0005{\u0001!\u0019!C\u0001\u0005\u007f\t1%\u001b8ji&\fG\u000eT3bI\u0016\u0014\u0018j\u001d:B]\u0012\u001cuN\u001c;s_2dWM]#q_\u000eD7/\u0006\u0002\u0003\"!A!1\t\u0001!\u0002\u0013\u0011\t#\u0001\u0013j]&$\u0018.\u00197MK\u0006$WM]%te\u0006sGmQ8oiJ|G\u000e\\3s\u000bB|7\r[:!\u0011%\u00119\u0005\u0001b\u0001\n\u0003\u0011I%A\tj]&$\u0018.\u00197MK\u0006$WM]%teN,\"Aa\u0013\u0011\u000f\u0005=$1\u0005\u0015\u0003NA!!q\nB+\u001b\t\u0011\tFC\u0002\u0003T\u0011\t1!\u00199j\u0013\u0011\u00119F!\u0015\u0003\u00191+\u0017\rZ3s\u0003:$\u0017j\u001d:\t\u0011\tm\u0003\u0001)A\u0005\u0005\u0017\n!#\u001b8ji&\fG\u000eT3bI\u0016\u0014\u0018j\u001d:tA!9!q\f\u0001\u0005\n\t\u0005\u0014A\u00037fC\u0012,'/S:sgR1!1\nB2\u0005KB\u0001B!\u000e\u0003^\u0001\u0007\u0011Q\u0015\u0005\t\u0005s\u0011i\u00061\u0001\u0002&\"9!\u0011\u000e\u0001\u0005\n\t-\u0014!H2iK\u000e\\W\u000b\u001d3bi\u0016dU-\u00193fe\u0006sG-S:s%\u0016\u001cX\u000f\u001c;\u0015\u0013M\u0013iG!\u001d\u0003v\t}\u0005\u0002\u0003B8\u0005O\u0002\rAa\u0013\u00029\u0015D\b/Z2uK\u0012\u001cVoY2fgN4W\u000f\u001c)beRLG/[8og\"9!1\u000fB4\u0001\u0004\u0001\u0015!G3ya\u0016\u001cG/\u001a3QCJ$\u0018\u000e^5p]N$vNU3uefD\u0001Ba\u001e\u0003h\u0001\u0007!\u0011P\u0001\u0019Kb\u0004Xm\u0019;fI\u001a\u000b\u0017\u000e\\3e!\u0006\u0014H/\u001b;j_:\u001c\bcBA8\u0005GA#1\u0010\t\b)\nu$\u0011QA7\u0013\r\u0011y\b\u0012\u0002\u0007)V\u0004H.\u001a\u001a1\t\t\r%Q\u0012\t\u0007\u0003_\u0012)I!#\n\t\t\u001d\u0015q\u000f\u0002\u0006\u00072\f7o\u001d\t\u0005\u0005\u0017\u0013i\t\u0004\u0001\u0005\u0019\t=%QOA\u0001\u0002\u0003\u0015\tA!%\u0003\u0007}#\u0013'\u0005\u0003\u0003\u0014\ne\u0005c\u0001+\u0003\u0016&\u0019!q\u0013#\u0003\u000f9{G\u000f[5oOB\u0019AKa'\n\u0007\tuEIA\u0002B]fD\u0001B!)\u0003h\u0001\u0007!1U\u0001\u001fC\u000e$X/\u00197Va\u0012\fG/\u001a'fC\u0012,'/\u00118e\u0013N\u0014(+Z:vYR\u0004BA!*\u0003::!!q\u0015B[\u001d\u0011\u0011IKa-\u000f\t\t-&\u0011W\u0007\u0003\u0005[S1Aa,\u0007\u0003\u0019a$o\\8u}%\tQ!\u0003\u0002\u0004\t%\u0019!q\u0017\u0002\u0002\u001b-\u000bgm[1[W\u000ec\u0017.\u001a8u\u0013\u0011\u0011YL!0\u00031U\u0003H-\u0019;f\u0019\u0016\fG-\u001a:B]\u0012L5O\u001d*fgVdGOC\u0002\u00038\nAaA!1\u0001\t\u0003i\u0016A\u0006;fgR,\u0006\u000fZ1uK2+\u0017\rZ3s\u0003:$\u0017j\u001d:)\u0007\t}&\u000fC\u0004\u0003H\u0002!IA!3\u0002)\rDWmY6HKR$\u0015\r^1SKN\u0004xN\\:f)\u001d\u0019&1\u001aBg\u0005\u001fD\u0001B!\b\u0003F\u0002\u0007!\u0011\u0005\u0005\u0007Y\n\u0015\u0007\u0019\u0001\u0015\t\u0011\tE'Q\u0019a\u0001\u0005'\f\u0001B]3ta>t7/\u001a\t\u0005\u0005+\u0014I.\u0004\u0002\u0003X*\u0019!\u0011\u0003\u0003\n\t\tm'q\u001b\u0002\u0010\u000f\u0016$H)\u0019;b%\u0016\u001c\bo\u001c8tK\"9!q\u001c\u0001\u0005\n\t\u0005\u0018!D3sCN,W*\u001a;bI\u0006$\u0018\r\u0006\u0003\u0003d\n%\b\u0003\u0002Bk\u0005KLAAa:\u0003X\nq1I]3bi\u0016\u0014Vm\u001d9p]N,\u0007\u0002\u0003Bi\u0005;\u0004\rAa9\t\r\t5\b\u0001\"\u0001^\u0003i!Xm\u001d;HKR$v\u000e]5dg\u0006sG\rU1si&$\u0018n\u001c8tQ\r\u0011YO\u001d\u0005\u0007\u0005g\u0004A\u0011A/\u0002OQ,7\u000f^\"sK\u0006$X-\u00118e\u000f\u0016$Hk\u001c9jGB\u000b'\u000f^5uS>t7\u000b^1uKN\u0014\u0016m\u001e\u0015\u0004\u0005c\u0014\bB\u0002B}\u0001\u0011\u0005Q,\u0001\u0010uKN$8+\u001a;U_BL7\rU1si&$\u0018n\u001c8Ti\u0006$Xm\u001d*bo\"\u001a!q\u001f:\t\r\t}\b\u0001\"\u0001^\u0003\u0001\"Xm\u001d;SK\u0006\u001c8/[4o!\u0006\u0014H/\u001b;j_:\u001c\u0018J\u001c)s_\u001e\u0014Xm]:)\u0007\tu(\u000f\u0003\u0004\u0004\u0006\u0001!\t!X\u0001\u001ci\u0016\u001cHoR3u)>\u0004\u0018n\u0019)beRLG/[8o'R\fG/Z:)\u0007\r\r!\u000fC\u0004\u0004\f\u0001!Ia!\u0004\u0002)\u0015\u0014\u0018m]3NKR\fG-\u0019;b\u0003:$7\u000b^1u)\u0011\u0019ya!\u0006\u0011\t\tU7\u0011C\u0005\u0005\u0007'\u00119NA\bTKR$\u0015\r^1SKN\u0004xN\\:f\u0011!\u0011\tn!\u0003A\u0002\r=\u0001BBB\r\u0001\u0011\u0005Q,\u0001\u000euKN$8i\u001c8ue>dG.\u001a:Fa>\u001c\u0007.T3uQ>$7\u000fK\u0002\u0004\u0018IDaaa\b\u0001\t\u0003i\u0016a\b;fgR\u001cuN\u001c;s_2dWM]'b]\u0006<W-\\3oi6+G\u000f[8eg\"\u001a1Q\u0004:\t\r\r\u0015\u0002\u0001\"\u0001^\u0003\r\"Xm\u001d;[\u001d>$Wm\u00115b]\u001e,\u0007*\u00198eY\u0016\u0014hi\u001c:ECR\f7\t[1oO\u0016D3aa\ts\u0011\u0019\u0019Y\u0003\u0001C\u0001;\u0006!B/Z:u\u00072,8\u000f^3s\u0013\u0012lU\r\u001e5pIND3a!\u000bs\u0011\u0019\u0019\t\u0004\u0001C\u0001;\u0006YB/Z:u\u0005J|7.\u001a:TKF,XM\\2f\u0013\u0012lU\r\u001e5pIND3aa\fs\u0011\u0019\u00199\u0004\u0001C\u0001;\u00069B/Z:u\u0007J,\u0017\r^3U_BdUM^3m!\u0006$\bn\u001d\u0015\u0004\u0007k\u0011\bBBB\u001f\u0001\u0011\u0005Q,A\u0012uKN$\bK]3gKJ\u0014X\r\u001a*fa2L7-Y#mK\u000e$\u0018n\u001c8NKRDw\u000eZ:)\u0007\rm\"\u000fC\u0004\u0004D\u0001!Ia!\u0012\u0002\u0019\u0011\fG/Y!t'R\u0014\u0018N\\4\u0015\t\u0005-8q\t\u0005\t\u0007\u0013\u001a\t\u00051\u0001\u0002n\u0005!\u0001/\u0019;i\u0011\u0019\u0019i\u0005\u0001C\u0001;\u0006QB/Z:u\t\u0016dWmZ1uS>tGk\\6f]6+G\u000f[8eg\"\u001a11\n:\t\r\rM\u0003\u0001\"\u0001^\u0003Y!Xm\u001d;D_:\u001cX/\\3s\u001f\u001a47/\u001a;QCRD\u0007fAB)e\"I1\u0011\f\u0001\u0012\u0002\u0013%11L\u0001\u001bGJ,\u0017\r^3Ce>\\WM]%oM>$C-\u001a4bk2$H%N\u000b\u0003\u0007;RC!a;\u0004`-\u00121\u0011\r\t\u0005\u0007G\u001ai'\u0004\u0002\u0004f)!1qMB5\u0003%)hn\u00195fG.,GMC\u0002\u0004l\u0011\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0019yg!\u001a\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class KafkaZkClientTest
extends ZooKeeperTestHarness {
    private final String group;
    private final String topic1;
    private final String topic2;
    private final TopicPartition topicPartition10 = new TopicPartition(this.topic1(), 0);
    private final TopicPartition topicPartition11 = new TopicPartition(this.topic1(), 1);
    private final TopicPartition topicPartition20 = new TopicPartition(this.topic2(), 0);
    private final Seq<TopicPartition> topicPartitions10_11 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), this.topicPartition11()}));
    private KafkaZkClient otherZkClient;
    private final TopicPartition topicPartition = new TopicPartition("topic", 0);
    private final Properties logProps = this.createLogProps(1024);
    private final scala.collection.immutable.Map<TopicPartition, LeaderIsrAndControllerEpoch> initialLeaderIsrAndControllerEpochs = this.kafka$zk$KafkaZkClientTest$$leaderIsrAndControllerEpochs(0, 0);
    private final scala.collection.immutable.Map<TopicPartition, LeaderAndIsr> initialLeaderIsrs = this.initialLeaderIsrAndControllerEpochs().mapValues((Function1)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final LeaderAndIsr apply(LeaderIsrAndControllerEpoch x$7) {
            return x$7.leaderAndIsr();
        }
    });

    private String group() {
        return this.group;
    }

    private String topic1() {
        return this.topic1;
    }

    private String topic2() {
        return this.topic2;
    }

    public TopicPartition topicPartition10() {
        return this.topicPartition10;
    }

    public TopicPartition topicPartition11() {
        return this.topicPartition11;
    }

    public TopicPartition topicPartition20() {
        return this.topicPartition20;
    }

    public Seq<TopicPartition> topicPartitions10_11() {
        return this.topicPartitions10_11;
    }

    public KafkaZkClient otherZkClient() {
        return this.otherZkClient;
    }

    public void otherZkClient_$eq(KafkaZkClient x$1) {
        this.otherZkClient = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.otherZkClient_$eq(KafkaZkClient$.MODULE$.apply(this.zkConnect(), BoxesRunTime.unboxToBoolean((Object)this.zkAclsEnabled().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return JaasUtils.isZkSecurityEnabled();
            }
        })), this.zkSessionTimeout(), this.zkConnectionTimeout(), this.zkMaxInFlightRequests(), Time.SYSTEM, KafkaZkClient$.MODULE$.apply$default$7(), KafkaZkClient$.MODULE$.apply$default$8()));
    }

    @Override
    @After
    public void tearDown() {
        if (this.otherZkClient() != null) {
            this.otherZkClient().close();
        }
        super.tearDown();
    }

    private TopicPartition topicPartition() {
        return this.topicPartition;
    }

    @Test
    public void testSetAndGetConsumerOffset() {
        long offset = 123L;
        Assert.assertTrue((boolean)this.zkClient().getConsumerOffset(this.group(), this.topicPartition()).isEmpty());
        this.zkClient().setOrCreateConsumerOffset(this.group(), this.topicPartition(), offset);
        Assert.assertEquals((long)offset, (long)BoxesRunTime.unboxToLong((Object)this.zkClient().getConsumerOffset(this.group(), this.topicPartition()).get()));
        this.zkClient().setOrCreateConsumerOffset(this.group(), this.topicPartition(), offset + 2L);
        Assert.assertEquals((long)(offset + 2L), (long)BoxesRunTime.unboxToLong((Object)this.zkClient().getConsumerOffset(this.group(), this.topicPartition()).get()));
    }

    @Test
    public void testGetConsumerOffsetNoData() {
        KafkaZkClient qual$1 = this.zkClient();
        String x$12 = ConsumerOffset$.MODULE$.path(this.group(), this.topicPartition().topic(), Predef$.MODULE$.int2Integer(this.topicPartition().partition()));
        byte[] x$13 = qual$1.createRecursive$default$2();
        boolean x$14 = qual$1.createRecursive$default$3();
        qual$1.createRecursive(x$12, x$13, x$14);
        Assert.assertTrue((boolean)this.zkClient().getConsumerOffset(this.group(), this.topicPartition()).isEmpty());
    }

    @Test
    public void testDeleteRecursive() {
        this.zkClient().deleteRecursive("/delete/does-not-exist");
        KafkaZkClient qual$2 = this.zkClient();
        String x$15 = "/delete/some/random/path";
        byte[] x$16 = qual$2.createRecursive$default$2();
        boolean x$17 = qual$2.createRecursive$default$3();
        qual$2.createRecursive(x$15, x$16, x$17);
        Assert.assertTrue((boolean)this.zkClient().pathExists("/delete/some/random/path"));
        this.zkClient().deleteRecursive("/delete");
        Assert.assertFalse((boolean)this.zkClient().pathExists("/delete/some/random/path"));
        Assert.assertFalse((boolean)this.zkClient().pathExists("/delete/some/random"));
        Assert.assertFalse((boolean)this.zkClient().pathExists("/delete/some"));
        Assert.assertFalse((boolean)this.zkClient().pathExists("/delete"));
        this.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.zkClient().deleteRecursive("delete-invalid-path");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
    }

    @Test
    public void testCreateRecursive() {
        KafkaZkClient qual$3 = this.zkClient();
        String x$18 = "/create-newrootpath";
        byte[] x$19 = qual$3.createRecursive$default$2();
        boolean x$20 = qual$3.createRecursive$default$3();
        qual$3.createRecursive(x$18, x$19, x$20);
        Assert.assertTrue((boolean)this.zkClient().pathExists("/create-newrootpath"));
        KafkaZkClient qual$4 = this.zkClient();
        String x$21 = "/create/some/random/long/path";
        byte[] x$22 = qual$4.createRecursive$default$2();
        boolean x$23 = qual$4.createRecursive$default$3();
        qual$4.createRecursive(x$21, x$22, x$23);
        Assert.assertTrue((boolean)this.zkClient().pathExists("/create/some/random/long/path"));
        KafkaZkClient qual$5 = this.zkClient();
        String x$24 = "/create/some/random/long/path";
        boolean x$25 = false;
        byte[] x$26 = qual$5.createRecursive$default$2();
        qual$5.createRecursive(x$24, x$26, x$25);
        this.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                KafkaZkClient qual$6 = this.$outer.zkClient();
                String x$27 = "create-invalid-path";
                byte[] x$28 = qual$6.createRecursive$default$2();
                boolean x$29 = qual$6.createRecursive$default$3();
                qual$6.createRecursive(x$27, x$28, x$29);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
    }

    @Test
    public void testTopicAssignmentMethods() {
        Assert.assertTrue((boolean)this.zkClient().getAllTopicsInCluster().isEmpty());
        Assert.assertFalse((boolean)this.zkClient().topicExists(this.topic1()));
        Assert.assertTrue((boolean)this.zkClient().getTopicPartitionCount(this.topic1()).isEmpty());
        Assert.assertTrue((boolean)this.zkClient().getPartitionAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()}))).isEmpty());
        Assert.assertTrue((boolean)this.zkClient().getPartitionsForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()}))).isEmpty());
        Assert.assertTrue((boolean)this.zkClient().getReplicasForPartition(new TopicPartition(this.topic1(), 2)).isEmpty());
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic1(), 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic1(), 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic1(), 2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))}));
        this.zkClient().createTopicAssignment(this.topic1(), assignment2);
        Assert.assertTrue((boolean)this.zkClient().topicExists(this.topic1()));
        scala.collection.immutable.Map expectedAssignment = (scala.collection.immutable.Map)assignment2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Seq<Object>> apply(Tuple2<TopicPartition, Seq<Object>> topicAssignment) {
                int partition = ((TopicPartition)topicAssignment._1()).partition();
                Seq assignment2 = (Seq)topicAssignment._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)assignment2);
            }
        }, Map$.MODULE$.canBuildFrom());
        Assert.assertEquals((long)assignment2.size(), (long)BoxesRunTime.unboxToInt((Object)this.zkClient().getTopicPartitionCount(this.topic1()).get()));
        Assert.assertEquals((Object)expectedAssignment, (Object)this.zkClient().getPartitionAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()}))).get((Object)this.topic1()).get());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Object)((TraversableOnce)this.zkClient().getPartitionsForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()}))).get((Object)this.topic1()).get()).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition(this.topic1(), 2)).toSet());
        scala.collection.immutable.Map updatedAssignment = (scala.collection.immutable.Map)assignment2.$minus((Object)new TopicPartition(this.topic1(), 2));
        this.zkClient().setTopicAssignment(this.topic1(), updatedAssignment);
        Assert.assertEquals((long)updatedAssignment.size(), (long)BoxesRunTime.unboxToInt((Object)this.zkClient().getTopicPartitionCount(this.topic1()).get()));
        scala.collection.immutable.Map secondAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic2(), 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic2(), 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}));
        this.zkClient().createTopicAssignment(this.topic2(), secondAssignment);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()})), (Object)this.zkClient().getAllTopicsInCluster().toSet());
    }

    @Test
    public void testGetDataAndVersion() {
        String path = "/testpath";
        Tuple2 tuple2 = this.zkClient().getDataAndVersion(path);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Option data0 = (Option)tuple2._1();
            int version0 = tuple2._2$mcI$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)data0, (Object)BoxesRunTime.boxToInteger((int)version0));
            Option data02 = (Option)tuple23._1();
            int version02 = tuple23._2$mcI$sp();
            Assert.assertTrue((boolean)data02.isEmpty());
            Assert.assertEquals((long)ZkVersion$.MODULE$.UnknownVersion(), (long)version02);
            KafkaZkClient qual$7 = this.zkClient();
            String x$30 = path;
            byte[] x$31 = qual$7.createRecursive$default$2();
            boolean x$32 = qual$7.createRecursive$default$3();
            qual$7.createRecursive(x$30, x$31, x$32);
            KafkaZkClient qual$8 = this.zkClient();
            String x$33 = path;
            byte[] x$34 = "version1".getBytes(StandardCharsets.UTF_8);
            int x$35 = 0;
            Option x$36 = qual$8.conditionalUpdatePath$default$4();
            qual$8.conditionalUpdatePath(x$33, x$34, x$35, x$36);
            Tuple2 tuple24 = this.zkClient().getDataAndVersion(path);
            if (tuple24 != null) {
                Tuple2 tuple25;
                Option data1 = (Option)tuple24._1();
                int version1 = tuple24._2$mcI$sp();
                Tuple2 tuple26 = tuple25 = new Tuple2((Object)data1, (Object)BoxesRunTime.boxToInteger((int)version1));
                Option data12 = (Option)tuple26._1();
                int version12 = tuple26._2$mcI$sp();
                Assert.assertEquals((Object)"version1", (Object)new String((byte[])data12.get(), StandardCharsets.UTF_8));
                Assert.assertEquals((long)1L, (long)version12);
                KafkaZkClient qual$9 = this.zkClient();
                String x$37 = path;
                byte[] x$38 = "version2".getBytes(StandardCharsets.UTF_8);
                int x$39 = 1;
                Option x$40 = qual$9.conditionalUpdatePath$default$4();
                qual$9.conditionalUpdatePath(x$37, x$38, x$39, x$40);
                Tuple2 tuple27 = this.zkClient().getDataAndVersion(path);
                if (tuple27 != null) {
                    Tuple2 tuple28;
                    Option data2 = (Option)tuple27._1();
                    int version2 = tuple27._2$mcI$sp();
                    Tuple2 tuple29 = tuple28 = new Tuple2((Object)data2, (Object)BoxesRunTime.boxToInteger((int)version2));
                    Option data22 = (Option)tuple29._1();
                    int version22 = tuple29._2$mcI$sp();
                    Assert.assertEquals((Object)"version2", (Object)new String((byte[])data22.get(), StandardCharsets.UTF_8));
                    Assert.assertEquals((long)2L, (long)version22);
                    return;
                }
                throw new MatchError((Object)tuple27);
            }
            throw new MatchError((Object)tuple24);
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testConditionalUpdatePath() {
        String path = "/testconditionalpath";
        KafkaZkClient qual$10 = this.zkClient();
        String x$41 = path;
        byte[] x$42 = "version0".getBytes(StandardCharsets.UTF_8);
        int x$43 = 0;
        Option x$44 = qual$10.conditionalUpdatePath$default$4();
        Tuple2 statusAndVersion = qual$10.conditionalUpdatePath(x$41, x$42, x$43, x$44);
        Assert.assertFalse((boolean)statusAndVersion._1$mcZ$sp());
        Assert.assertEquals((long)ZkVersion$.MODULE$.UnknownVersion(), (long)statusAndVersion._2$mcI$sp());
        KafkaZkClient qual$11 = this.zkClient();
        String x$45 = path;
        byte[] x$46 = qual$11.createRecursive$default$2();
        boolean x$47 = qual$11.createRecursive$default$3();
        qual$11.createRecursive(x$45, x$46, x$47);
        KafkaZkClient qual$12 = this.zkClient();
        String x$48 = path;
        byte[] x$49 = "version1".getBytes(StandardCharsets.UTF_8);
        int x$50 = 0;
        Option x$51 = qual$12.conditionalUpdatePath$default$4();
        statusAndVersion = qual$12.conditionalUpdatePath(x$48, x$49, x$50, x$51);
        Assert.assertTrue((boolean)statusAndVersion._1$mcZ$sp());
        Assert.assertEquals((long)1L, (long)statusAndVersion._2$mcI$sp());
        KafkaZkClient qual$13 = this.zkClient();
        String x$52 = path;
        byte[] x$53 = "version2".getBytes(StandardCharsets.UTF_8);
        int x$54 = 2;
        Option x$55 = qual$13.conditionalUpdatePath$default$4();
        statusAndVersion = qual$13.conditionalUpdatePath(x$52, x$53, x$54, x$55);
        Assert.assertFalse((boolean)statusAndVersion._1$mcZ$sp());
        Assert.assertEquals((long)ZkVersion$.MODULE$.UnknownVersion(), (long)statusAndVersion._2$mcI$sp());
    }

    @Test
    public void testCreateSequentialPersistentPath() {
        String path = "/testpath";
        KafkaZkClient qual$14 = this.zkClient();
        String x$56 = path;
        byte[] x$57 = qual$14.createRecursive$default$2();
        boolean x$58 = qual$14.createRecursive$default$3();
        qual$14.createRecursive(x$56, x$57, x$58);
        String result = this.zkClient().createSequentialPersistentPath(new StringBuilder().append((Object)path).append((Object)"/sequence_").toString(), null);
        Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/sequence_0000000000"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})), (Object)result);
        Assert.assertTrue((boolean)this.zkClient().pathExists(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/sequence_0000000000"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path}))));
        Assert.assertEquals((Object)None$.MODULE$, this.dataAsString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/sequence_0000000000"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path}))));
        result = this.zkClient().createSequentialPersistentPath(new StringBuilder().append((Object)path).append((Object)"/sequence_").toString(), "some value".getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/sequence_0000000001"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})), (Object)result);
        Assert.assertTrue((boolean)this.zkClient().pathExists(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/sequence_0000000001"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path}))));
        Assert.assertEquals((Object)new Some((Object)"some value"), this.dataAsString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/sequence_0000000001"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path}))));
    }

    @Test
    public void testPropagateIsrChanges() {
        KafkaZkClient qual$15 = this.zkClient();
        String x$59 = "/isr_change_notification";
        byte[] x$60 = qual$15.createRecursive$default$2();
        boolean x$61 = qual$15.createRecursive$default$3();
        qual$15.createRecursive(x$59, x$60, x$61);
        this.zkClient().propagateIsrChanges((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic-a", 0), new TopicPartition("topic-b", 0)})));
        String expectedPath = "/isr_change_notification/isr_change_0000000000";
        Assert.assertTrue((boolean)this.zkClient().pathExists(expectedPath));
        Assert.assertEquals((Object)new Some((Object)"{\"version\":1,\"partitions\":[{\"topic\":\"topic-a\",\"partition\":0},{\"topic\":\"topic-b\",\"partition\":0}]}"), this.dataAsString(expectedPath));
        this.zkClient().propagateIsrChanges((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic-b", 0)})));
        expectedPath = "/isr_change_notification/isr_change_0000000001";
        Assert.assertTrue((boolean)this.zkClient().pathExists(expectedPath));
        Assert.assertEquals((Object)new Some((Object)"{\"version\":1,\"partitions\":[{\"topic\":\"topic-b\",\"partition\":0}]}"), this.dataAsString(expectedPath));
    }

    @Test
    public void testIsrChangeNotificationGetters() {
        Assert.assertEquals((String)"Failed for non existing parent ZK node", (Object)Seq$.MODULE$.empty(), (Object)this.zkClient().getAllIsrChangeNotifications());
        Assert.assertEquals((String)"Failed for non existing parent ZK node", (Object)Seq$.MODULE$.empty(), (Object)this.zkClient().getPartitionsFromIsrChangeNotifications((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000"}))));
        KafkaZkClient qual$16 = this.zkClient();
        String x$62 = "/isr_change_notification";
        byte[] x$63 = qual$16.createRecursive$default$2();
        boolean x$64 = qual$16.createRecursive$default$3();
        qual$16.createRecursive(x$62, x$63, x$64);
        this.zkClient().propagateIsrChanges((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), this.topicPartition11()})));
        this.zkClient().propagateIsrChanges((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10()})));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000", "0000000001"})), (Object)this.zkClient().getAllIsrChangeNotifications().toSet());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), this.topicPartition11(), this.topicPartition10()})), (Object)this.zkClient().getPartitionsFromIsrChangeNotifications((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000", "0000000001"}))));
    }

    @Test
    public void testIsrChangeNotificationsDeletion() {
        this.zkClient().deleteIsrChangeNotifications((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000"})));
        KafkaZkClient qual$17 = this.zkClient();
        String x$65 = "/isr_change_notification";
        byte[] x$66 = qual$17.createRecursive$default$2();
        boolean x$67 = qual$17.createRecursive$default$3();
        qual$17.createRecursive(x$65, x$66, x$67);
        this.zkClient().propagateIsrChanges((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), this.topicPartition11()})));
        this.zkClient().propagateIsrChanges((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10()})));
        this.zkClient().propagateIsrChanges((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition11()})));
        this.zkClient().deleteIsrChangeNotifications((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000001"})));
        this.zkClient().deleteIsrChangeNotifications((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000001"})));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000", "0000000002"})), (Object)this.zkClient().getAllIsrChangeNotifications().toSet());
        this.zkClient().deleteIsrChangeNotifications();
        Assert.assertEquals((Object)Seq$.MODULE$.empty(), (Object)this.zkClient().getAllIsrChangeNotifications());
    }

    @Test
    public void testPropagateLogDir() {
        KafkaZkClient qual$18 = this.zkClient();
        String x$68 = "/log_dir_event_notification";
        byte[] x$69 = qual$18.createRecursive$default$2();
        boolean x$70 = qual$18.createRecursive$default$3();
        qual$18.createRecursive(x$68, x$69, x$70);
        int brokerId = 3;
        this.zkClient().propagateLogDirEvent(brokerId);
        String expectedPath = "/log_dir_event_notification/log_dir_event_0000000000";
        Assert.assertTrue((boolean)this.zkClient().pathExists(expectedPath));
        Assert.assertEquals((Object)new Some((Object)"{\"version\":1,\"broker\":3,\"event\":1}"), this.dataAsString(expectedPath));
        this.zkClient().propagateLogDirEvent(brokerId);
        expectedPath = "/log_dir_event_notification/log_dir_event_0000000001";
        Assert.assertTrue((boolean)this.zkClient().pathExists(expectedPath));
        Assert.assertEquals((Object)new Some((Object)"{\"version\":1,\"broker\":3,\"event\":1}"), this.dataAsString(expectedPath));
        int anotherBrokerId = 4;
        this.zkClient().propagateLogDirEvent(anotherBrokerId);
        expectedPath = "/log_dir_event_notification/log_dir_event_0000000002";
        Assert.assertTrue((boolean)this.zkClient().pathExists(expectedPath));
        Assert.assertEquals((Object)new Some((Object)"{\"version\":1,\"broker\":4,\"event\":1}"), this.dataAsString(expectedPath));
    }

    @Test
    public void testLogDirGetters() {
        Assert.assertEquals((String)"getAllLogDirEventNotifications failed for non existing parent ZK node", (Object)Seq$.MODULE$.empty(), (Object)this.zkClient().getAllLogDirEventNotifications());
        Assert.assertEquals((String)"getBrokerIdsFromLogDirEvents failed for non existing parent ZK node", (Object)Seq$.MODULE$.empty(), (Object)this.zkClient().getBrokerIdsFromLogDirEvents((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000"}))));
        KafkaZkClient qual$19 = this.zkClient();
        String x$71 = "/log_dir_event_notification";
        byte[] x$72 = qual$19.createRecursive$default$2();
        boolean x$73 = qual$19.createRecursive$default$3();
        qual$19.createRecursive(x$71, x$72, x$73);
        int brokerId = 3;
        this.zkClient().propagateLogDirEvent(brokerId);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), (Object)this.zkClient().getBrokerIdsFromLogDirEvents((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000"}))));
        this.zkClient().propagateLogDirEvent(brokerId);
        int anotherBrokerId = 4;
        this.zkClient().propagateLogDirEvent(anotherBrokerId);
        Seq notifications012 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000", "0000000001", "0000000002"}));
        Assert.assertEquals((Object)notifications012.toSet(), (Object)this.zkClient().getAllLogDirEventNotifications().toSet());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 3, 4})), (Object)this.zkClient().getBrokerIdsFromLogDirEvents(notifications012));
    }

    @Test
    public void testLogDirEventNotificationsDeletion() {
        this.zkClient().deleteLogDirEventNotifications((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000", "0000000002"})));
        KafkaZkClient qual$20 = this.zkClient();
        String x$74 = "/log_dir_event_notification";
        byte[] x$75 = qual$20.createRecursive$default$2();
        boolean x$76 = qual$20.createRecursive$default$3();
        qual$20.createRecursive(x$74, x$75, x$76);
        int brokerId = 3;
        int anotherBrokerId = 4;
        this.zkClient().propagateLogDirEvent(brokerId);
        this.zkClient().propagateLogDirEvent(brokerId);
        this.zkClient().propagateLogDirEvent(anotherBrokerId);
        this.zkClient().deleteLogDirEventNotifications((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000", "0000000002"})));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000001"})), (Object)this.zkClient().getAllLogDirEventNotifications());
        this.zkClient().propagateLogDirEvent(anotherBrokerId);
        this.zkClient().deleteLogDirEventNotifications();
        Assert.assertEquals((Object)Seq$.MODULE$.empty(), (Object)this.zkClient().getAllLogDirEventNotifications());
    }

    @Test
    public void testSetGetAndDeletePartitionReassignment() {
        KafkaZkClient qual$21 = this.zkClient();
        String x$77 = AdminZNode$.MODULE$.path();
        byte[] x$78 = qual$21.createRecursive$default$2();
        boolean x$79 = qual$21.createRecursive$default$3();
        qual$21.createRecursive(x$77, x$78, x$79);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)this.zkClient().getPartitionReassignment());
        scala.collection.immutable.Map reassignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic_a", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic_a", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic_b", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic_c", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 3})))}));
        this.zkClient().setOrCreatePartitionReassignment((Map)reassignment);
        Assert.assertEquals((Object)reassignment, (Object)this.zkClient().getPartitionReassignment());
        scala.collection.immutable.Map updatedReassingment = (scala.collection.immutable.Map)reassignment.$minus((Object)new TopicPartition("topic_b", 0));
        this.zkClient().setOrCreatePartitionReassignment((Map)updatedReassingment);
        Assert.assertEquals((Object)updatedReassingment, (Object)this.zkClient().getPartitionReassignment());
        this.zkClient().deletePartitionReassignment();
        Assert.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)this.zkClient().getPartitionReassignment());
        this.zkClient().createPartitionReassignment(reassignment);
        Assert.assertEquals((Object)reassignment, (Object)this.zkClient().getPartitionReassignment());
    }

    @Test
    public void testGetDataAndStat() {
        String path = "/testpath";
        Tuple2 tuple2 = this.zkClient().getDataAndStat(path);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Option data0 = (Option)tuple2._1();
            Stat version0 = (Stat)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)data0, (Object)version0);
            Option data02 = (Option)tuple23._1();
            Stat version02 = (Stat)tuple23._2();
            Assert.assertTrue((boolean)data02.isEmpty());
            Assert.assertEquals((long)0L, (long)version02.getVersion());
            KafkaZkClient qual$22 = this.zkClient();
            String x$80 = path;
            byte[] x$81 = qual$22.createRecursive$default$2();
            boolean x$82 = qual$22.createRecursive$default$3();
            qual$22.createRecursive(x$80, x$81, x$82);
            KafkaZkClient qual$23 = this.zkClient();
            String x$83 = path;
            byte[] x$84 = "version1".getBytes(StandardCharsets.UTF_8);
            int x$85 = 0;
            Option x$86 = qual$23.conditionalUpdatePath$default$4();
            qual$23.conditionalUpdatePath(x$83, x$84, x$85, x$86);
            Tuple2 tuple24 = this.zkClient().getDataAndStat(path);
            if (tuple24 != null) {
                Tuple2 tuple25;
                Option data1 = (Option)tuple24._1();
                Stat version1 = (Stat)tuple24._2();
                Tuple2 tuple26 = tuple25 = new Tuple2((Object)data1, (Object)version1);
                Option data12 = (Option)tuple26._1();
                Stat version12 = (Stat)tuple26._2();
                Assert.assertEquals((Object)"version1", (Object)new String((byte[])data12.get(), StandardCharsets.UTF_8));
                Assert.assertEquals((long)1L, (long)version12.getVersion());
                KafkaZkClient qual$24 = this.zkClient();
                String x$87 = path;
                byte[] x$88 = "version2".getBytes(StandardCharsets.UTF_8);
                int x$89 = 1;
                Option x$90 = qual$24.conditionalUpdatePath$default$4();
                qual$24.conditionalUpdatePath(x$87, x$88, x$89, x$90);
                Tuple2 tuple27 = this.zkClient().getDataAndStat(path);
                if (tuple27 != null) {
                    Tuple2 tuple28;
                    Option data2 = (Option)tuple27._1();
                    Stat version2 = (Stat)tuple27._2();
                    Tuple2 tuple29 = tuple28 = new Tuple2((Object)data2, (Object)version2);
                    Option data22 = (Option)tuple29._1();
                    Stat version22 = (Stat)tuple29._2();
                    Assert.assertEquals((Object)"version2", (Object)new String((byte[])data22.get(), StandardCharsets.UTF_8));
                    Assert.assertEquals((long)2L, (long)version22.getVersion());
                    return;
                }
                throw new MatchError((Object)tuple27);
            }
            throw new MatchError((Object)tuple24);
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testGetChildren() {
        String path = "/testpath";
        Assert.assertTrue((boolean)this.zkClient().getChildren(path).isEmpty());
        KafkaZkClient qual$25 = this.zkClient();
        String x$91 = "/testpath/child1";
        byte[] x$92 = qual$25.createRecursive$default$2();
        boolean x$93 = qual$25.createRecursive$default$3();
        qual$25.createRecursive(x$91, x$92, x$93);
        KafkaZkClient qual$26 = this.zkClient();
        String x$94 = "/testpath/child2";
        byte[] x$95 = qual$26.createRecursive$default$2();
        boolean x$96 = qual$26.createRecursive$default$3();
        qual$26.createRecursive(x$94, x$95, x$96);
        KafkaZkClient qual$27 = this.zkClient();
        String x$97 = "/testpath/child3";
        byte[] x$98 = qual$27.createRecursive$default$2();
        boolean x$99 = qual$27.createRecursive$default$3();
        qual$27.createRecursive(x$97, x$98, x$99);
        Seq children = this.zkClient().getChildren(path);
        Assert.assertEquals((long)3L, (long)children.size());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"child1", "child2", "child3"})), (Object)children.toSet());
    }

    @Test
    public void testAclManagementMethods() {
        ZkAclStore$.MODULE$.stores().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;

            public final void apply(ZkAclStore store) {
                Assert.assertFalse((boolean)this.$outer.zkClient().pathExists(store.aclPath()));
                Assert.assertFalse((boolean)this.$outer.zkClient().pathExists(store.changeStore().aclChangePath()));
                ResourceType$.MODULE$.values().foreach((Function1)new Serializable(this, store){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testAclManagementMethods$1 $outer;
                    private final ZkAclStore store$1;

                    public final void apply(ResourceType resource) {
                        Assert.assertFalse((boolean)this.$outer.kafka$zk$KafkaZkClientTest$$anonfun$$$outer().zkClient().pathExists(this.store$1.path(resource)));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.store$1 = store$1;
                    }
                });
            }

            public /* synthetic */ KafkaZkClientTest kafka$zk$KafkaZkClientTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.zkClient().createAclPaths();
        ZkAclStore$.MODULE$.stores().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;

            public final void apply(ZkAclStore store) {
                Assert.assertTrue((boolean)this.$outer.zkClient().pathExists(store.aclPath()));
                Assert.assertTrue((boolean)this.$outer.zkClient().pathExists(store.changeStore().aclChangePath()));
                ResourceType$.MODULE$.values().foreach((Function1)new Serializable(this, store){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testAclManagementMethods$2 $outer;
                    private final ZkAclStore store$2;

                    public final void apply(ResourceType resource) {
                        Assert.assertTrue((boolean)this.$outer.kafka$zk$KafkaZkClientTest$$anonfun$$$outer().zkClient().pathExists(this.store$2.path(resource)));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.store$2 = store$2;
                    }
                });
                Resource resource1 = new Resource((ResourceType)Topic$.MODULE$, UUID.randomUUID().toString(), store.patternType());
                Resource resource2 = new Resource((ResourceType)Topic$.MODULE$, UUID.randomUUID().toString(), store.patternType());
                SimpleAclAuthorizer.VersionedAcls versionedAcls = this.$outer.zkClient().getVersionedAclsForResource(resource1);
                Assert.assertTrue((boolean)versionedAcls.acls().isEmpty());
                Assert.assertEquals((long)ZkVersion$.MODULE$.UnknownVersion(), (long)versionedAcls.zkVersion());
                Assert.assertFalse((boolean)this.$outer.zkClient().resourceExists(resource1));
                Acl acl1 = new Acl(new KafkaPrincipal("User", "alice"), (PermissionType)Deny$.MODULE$, "host1", (Operation)Read$.MODULE$);
                Acl acl2 = new Acl(new KafkaPrincipal("User", "bob"), (PermissionType)Allow$.MODULE$, "*", (Operation)Read$.MODULE$);
                Acl acl3 = new Acl(new KafkaPrincipal("User", "bob"), (PermissionType)Deny$.MODULE$, "host1", (Operation)Read$.MODULE$);
                Assert.assertFalse((boolean)this.$outer.zkClient().conditionalSetAclsForResource(resource1, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl3})), 0)._1$mcZ$sp());
                Assert.assertTrue((boolean)this.$outer.zkClient().createAclsForResourceIfNotExists(resource1, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2})))._1$mcZ$sp());
                Assert.assertTrue((boolean)this.$outer.zkClient().createAclsForResourceIfNotExists(resource2, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl3})))._1$mcZ$sp());
                Assert.assertFalse((boolean)this.$outer.zkClient().createAclsForResourceIfNotExists(resource2, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl3})))._1$mcZ$sp());
                versionedAcls = this.$outer.zkClient().getVersionedAclsForResource(resource1);
                Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2})), (Object)versionedAcls.acls());
                Assert.assertEquals((long)0L, (long)versionedAcls.zkVersion());
                Assert.assertTrue((boolean)this.$outer.zkClient().resourceExists(resource1));
                Assert.assertTrue((boolean)this.$outer.zkClient().conditionalSetAclsForResource(resource1, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl3})), 0)._1$mcZ$sp());
                versionedAcls = this.$outer.zkClient().getVersionedAclsForResource(resource1);
                Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl3})), (Object)versionedAcls.acls());
                Assert.assertEquals((long)1L, (long)versionedAcls.zkVersion());
                scala.collection.immutable.Set set = ((TraversableOnce)ResourceType$.MODULE$.values().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(ResourceType rt) {
                        return rt.name();
                    }
                }, Seq$.MODULE$.canBuildFrom())).toSet();
                scala.collection.immutable.Set set2 = this.$outer.zkClient().getResourceTypes(store.patternType()).toSet();
                Assert.assertTrue((!(set != null ? !set.equals(set2) : set2 != null) ? 1 : 0) != 0);
                Seq resourceNames = this.$outer.zkClient().getResourceNames(store.patternType(), (ResourceType)Topic$.MODULE$);
                Assert.assertEquals((long)2L, (long)resourceNames.size());
                GenTraversable genTraversable = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{resource1.name(), resource2.name()}));
                scala.collection.immutable.Set set3 = resourceNames.toSet();
                Assert.assertTrue((!(genTraversable != null ? !genTraversable.equals(set3) : set3 != null) ? 1 : 0) != 0);
                Assert.assertTrue((boolean)this.$outer.zkClient().deleteResource(resource1));
                Assert.assertFalse((boolean)this.$outer.zkClient().resourceExists(resource1));
                Assert.assertFalse((boolean)this.$outer.zkClient().conditionalDelete(resource2, 10));
                Assert.assertTrue((boolean)this.$outer.zkClient().conditionalDelete(resource2, 0));
                this.$outer.zkClient().createAclChangeNotification(new Resource((ResourceType)Group$.MODULE$, "resource1", store.patternType()));
                this.$outer.zkClient().createAclChangeNotification(new Resource((ResourceType)Topic$.MODULE$, "resource2", store.patternType()));
                Assert.assertEquals((long)2L, (long)this.$outer.zkClient().getChildren(store.changeStore().aclChangePath()).size());
                this.$outer.zkClient().deleteAclChangeNotifications();
                Assert.assertTrue((boolean)this.$outer.zkClient().getChildren(store.changeStore().aclChangePath()).isEmpty());
            }

            public /* synthetic */ KafkaZkClientTest kafka$zk$KafkaZkClientTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testDeletePath() {
        String path = "/a/b/c";
        KafkaZkClient qual$28 = this.zkClient();
        String x$100 = path;
        byte[] x$101 = qual$28.createRecursive$default$2();
        boolean x$102 = qual$28.createRecursive$default$3();
        qual$28.createRecursive(x$100, x$101, x$102);
        this.zkClient().deletePath(path);
        Assert.assertFalse((boolean)this.zkClient().pathExists(path));
    }

    @Test
    public void testDeleteTopicZNode() {
        this.zkClient().deleteTopicZNode(this.topic1());
        KafkaZkClient qual$29 = this.zkClient();
        String x$103 = TopicZNode$.MODULE$.path(this.topic1());
        byte[] x$104 = qual$29.createRecursive$default$2();
        boolean x$105 = qual$29.createRecursive$default$3();
        qual$29.createRecursive(x$103, x$104, x$105);
        this.zkClient().deleteTopicZNode(this.topic1());
        Assert.assertFalse((boolean)this.zkClient().pathExists(TopicZNode$.MODULE$.path(this.topic1())));
    }

    @Test
    public void testDeleteTopicPathMethods() {
        Assert.assertFalse((boolean)this.zkClient().isTopicMarkedForDeletion(this.topic1()));
        Assert.assertTrue((boolean)this.zkClient().getTopicDeletions().isEmpty());
        this.zkClient().createDeleteTopicPath(this.topic1());
        this.zkClient().createDeleteTopicPath(this.topic2());
        Assert.assertTrue((boolean)this.zkClient().isTopicMarkedForDeletion(this.topic1()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()})), (Object)this.zkClient().getTopicDeletions().toSet());
        this.zkClient().deleteTopicDeletions((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()})));
        Assert.assertTrue((boolean)this.zkClient().getTopicDeletions().isEmpty());
    }

    private void assertPathExistenceAndData(String expectedPath, String data) {
        Assert.assertTrue((boolean)this.zkClient().pathExists(expectedPath));
        Assert.assertEquals((Object)new Some((Object)data), this.dataAsString(expectedPath));
    }

    @Test
    public void testCreateTokenChangeNotification() {
        this.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.zkClient().createTokenChangeNotification("delegationToken");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(KeeperException.NoNodeException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 544));
        this.zkClient().createDelegationTokenPaths();
        this.zkClient().createTokenChangeNotification("delegationToken");
        this.assertPathExistenceAndData("/delegation_token/token_changes/token_change_0000000000", "delegationToken");
    }

    @Test
    public void testEntityConfigManagementMethods() {
        Assert.assertTrue((boolean)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic1()).isEmpty());
        this.zkClient().setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic1(), this.logProps());
        Assert.assertEquals((Object)this.logProps(), (Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic1()));
        this.logProps().remove(LogConfig$.MODULE$.CleanupPolicyProp());
        this.zkClient().setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic1(), this.logProps());
        Assert.assertEquals((Object)this.logProps(), (Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic1()));
        this.zkClient().setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic2(), this.logProps());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()})), (Object)this.zkClient().getAllEntitiesWithConfig(ConfigType$.MODULE$.Topic()).toSet());
        this.zkClient().deleteTopicConfigs((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()})));
        Assert.assertTrue((boolean)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic1()).isEmpty());
    }

    @Test
    public void testCreateConfigChangeNotification() {
        Assert.assertFalse((boolean)this.zkClient().pathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path()));
        this.zkClient().createConfigChangeNotification(ConfigEntityZNode$.MODULE$.path(ConfigType$.MODULE$.Topic(), this.topic1()));
        this.assertPathExistenceAndData("/config/changes/config_change_0000000000", "{\"version\":2,\"entity_path\":\"/config/topics/topic1\"}");
        this.zkClient().createConfigChangeNotification(ConfigEntityZNode$.MODULE$.path(ConfigType$.MODULE$.Topic(), this.topic2()));
        this.assertPathExistenceAndData("/config/changes/config_change_0000000001", "{\"version\":2,\"entity_path\":\"/config/topics/topic2\"}");
    }

    /*
     * WARNING - void declaration
     */
    private Properties createLogProps(int bytesProp) {
        void var2_2;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)bytesProp)).toString());
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)bytesProp)).toString());
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        return var2_2;
    }

    private Properties logProps() {
        return this.logProps;
    }

    @Test
    public void testGetLogConfigs() {
        LogConfig emptyConfig = new LogConfig(Collections.emptyMap(), LogConfig$.MODULE$.apply$default$2());
        Assert.assertEquals((String)"Non existent config, no defaults", (Object)new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1()), (Object)emptyConfig)})), (Object)Predef$.MODULE$.Map().empty()), (Object)this.zkClient().getLogConfigs((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()})), Collections.emptyMap()));
        Properties logProps2 = this.createLogProps(2048);
        this.zkClient().setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic1(), this.logProps());
        Assert.assertEquals((String)"One existing and one non-existent topic", (Object)new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1()), (Object)new LogConfig((java.util.Map)this.logProps(), LogConfig$.MODULE$.apply$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic2()), (Object)emptyConfig)})), (Object)Predef$.MODULE$.Map().empty()), (Object)this.zkClient().getLogConfigs((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()})), Collections.emptyMap()));
        this.zkClient().setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic2(), logProps2);
        Assert.assertEquals((String)"Two existing topics", (Object)new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1()), (Object)new LogConfig((java.util.Map)this.logProps(), LogConfig$.MODULE$.apply$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic2()), (Object)new LogConfig((java.util.Map)logProps2, LogConfig$.MODULE$.apply$default$2()))})), (Object)Predef$.MODULE$.Map().empty()), (Object)this.zkClient().getLogConfigs((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()})), Collections.emptyMap()));
        Properties logProps1WithMoreValues = this.createLogProps(1024);
        logProps1WithMoreValues.put(LogConfig$.MODULE$.SegmentJitterMsProp(), "100");
        logProps1WithMoreValues.put(LogConfig$.MODULE$.SegmentBytesProp(), "1024");
        Assert.assertEquals((String)"Config with defaults", (Object)new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1()), (Object)new LogConfig((java.util.Map)logProps1WithMoreValues, LogConfig$.MODULE$.apply$default$2()))})), (Object)Predef$.MODULE$.Map().empty()), (Object)this.zkClient().getLogConfigs((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()})), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentJitterMsProp()), (Object)"100"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentBytesProp()), (Object)"128")}))).asJava()));
    }

    private BrokerInfo createBrokerInfo(int id, String host, int port, SecurityProtocol securityProtocol, Option<String> rack) {
        return BrokerInfo$.MODULE$.apply(new Broker(id, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{new EndPoint(host, port, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol)})), rack), ApiVersion$.MODULE$.latestVersion(), port + 10);
    }

    private Option<String> createBrokerInfo$default$5() {
        return None$.MODULE$;
    }

    @Test
    public void testRegisterBrokerInfo() {
        this.zkClient().createTopLevelPaths();
        BrokerInfo brokerInfo = this.createBrokerInfo(1, "test.host", 9999, SecurityProtocol.PLAINTEXT, this.createBrokerInfo$default$5());
        BrokerInfo differentBrokerInfoWithSameId = this.createBrokerInfo(1, "test.host2", 9995, SecurityProtocol.SSL, this.createBrokerInfo$default$5());
        this.zkClient().registerBrokerInZk(brokerInfo);
        Assert.assertEquals((Object)new Some((Object)brokerInfo.broker()), (Object)this.zkClient().getBroker(1));
        Assert.assertEquals((String)"Other ZK clients can read broker info", (Object)new Some((Object)brokerInfo.broker()), (Object)this.otherZkClient().getBroker(1));
        this.zkClient().registerBrokerInZk(differentBrokerInfoWithSameId);
        Assert.assertEquals((Object)new Some((Object)brokerInfo.broker()), (Object)this.zkClient().getBroker(1));
        this.intercept((Function0)new Serializable(this, differentBrokerInfoWithSameId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;
            private final BrokerInfo differentBrokerInfoWithSameId$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.otherZkClient().registerBrokerInZk(this.differentBrokerInfoWithSameId$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.differentBrokerInfoWithSameId$1 = differentBrokerInfoWithSameId$1;
            }
        }, ClassTag$.MODULE$.apply(KeeperException.NodeExistsException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 648));
        Assert.assertEquals((Object)new Some((Object)brokerInfo.broker()), (Object)this.zkClient().getBroker(1));
    }

    @Test
    public void testGetBrokerMethods() {
        this.zkClient().createTopLevelPaths();
        Assert.assertEquals((Object)Seq$.MODULE$.empty(), (Object)this.zkClient().getAllBrokersInCluster());
        Assert.assertEquals((Object)Seq$.MODULE$.empty(), (Object)this.zkClient().getSortedBrokerList());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getBroker(0));
        BrokerInfo brokerInfo0 = this.createBrokerInfo(0, "test.host0", 9998, SecurityProtocol.PLAINTEXT, this.createBrokerInfo$default$5());
        BrokerInfo brokerInfo1 = this.createBrokerInfo(1, "test.host1", 9999, SecurityProtocol.SSL, this.createBrokerInfo$default$5());
        this.zkClient().registerBrokerInZk(brokerInfo1);
        this.otherZkClient().registerBrokerInZk(brokerInfo0);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)this.zkClient().getSortedBrokerList());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{brokerInfo0.broker(), brokerInfo1.broker()})), (Object)this.zkClient().getAllBrokersInCluster());
        Assert.assertEquals((Object)new Some((Object)brokerInfo0.broker()), (Object)this.zkClient().getBroker(0));
    }

    @Test
    public void testUpdateBrokerInfo() {
        this.zkClient().createTopLevelPaths();
        BrokerInfo originalBrokerInfo = this.createBrokerInfo(1, "test.host", 9999, SecurityProtocol.PLAINTEXT, this.createBrokerInfo$default$5());
        this.intercept((Function0)new Serializable(this, originalBrokerInfo){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;
            private final BrokerInfo originalBrokerInfo$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.zkClient().updateBrokerInfoInZk(this.originalBrokerInfo$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.originalBrokerInfo$1 = originalBrokerInfo$1;
            }
        }, ClassTag$.MODULE$.apply(KeeperException.NoNodeException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 682));
        this.zkClient().registerBrokerInZk(originalBrokerInfo);
        BrokerInfo updatedBrokerInfo = this.createBrokerInfo(1, "test.host2", 9995, SecurityProtocol.SSL, this.createBrokerInfo$default$5());
        this.zkClient().updateBrokerInfoInZk(updatedBrokerInfo);
        Assert.assertEquals((Object)new Some((Object)updatedBrokerInfo.broker()), (Object)this.zkClient().getBroker(1));
        this.otherZkClient().updateBrokerInfoInZk(originalBrokerInfo);
        Assert.assertEquals((Object)new Some((Object)originalBrokerInfo.broker()), (Object)this.otherZkClient().getBroker(1));
    }

    /*
     * WARNING - void declaration
     */
    private Stat statWithVersion(int version) {
        void var2_2;
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        stat.setVersion(version);
        return var2_2;
    }

    public scala.collection.immutable.Map<TopicPartition, LeaderIsrAndControllerEpoch> kafka$zk$KafkaZkClientTest$$leaderIsrAndControllerEpochs(int state, int zkVersion) {
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition10()), (Object)new LeaderIsrAndControllerEpoch(new LeaderAndIsr(1, state, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2 + state, 3 + state})), zkVersion), 4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition11()), (Object)new LeaderIsrAndControllerEpoch(new LeaderAndIsr(0, state + 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1 + state, 2 + state})), zkVersion), 4))}));
    }

    public scala.collection.immutable.Map<TopicPartition, LeaderIsrAndControllerEpoch> initialLeaderIsrAndControllerEpochs() {
        return this.initialLeaderIsrAndControllerEpochs;
    }

    public scala.collection.immutable.Map<TopicPartition, LeaderAndIsr> initialLeaderIsrs() {
        return this.initialLeaderIsrs;
    }

    private scala.collection.immutable.Map<TopicPartition, LeaderAndIsr> leaderIsrs(int state, int zkVersion) {
        return this.kafka$zk$KafkaZkClientTest$$leaderIsrAndControllerEpochs(state, zkVersion).mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LeaderAndIsr apply(LeaderIsrAndControllerEpoch x$8) {
                return x$8.leaderAndIsr();
            }
        });
    }

    private void checkUpdateLeaderAndIsrResult(scala.collection.immutable.Map<TopicPartition, LeaderAndIsr> expectedSuccessfulPartitions, Seq<TopicPartition> expectedPartitionsToRetry, scala.collection.immutable.Map<TopicPartition, Tuple2<Class<?>, String>> expectedFailedPartitions, KafkaZkClient.UpdateLeaderAndIsrResult actualUpdateLeaderAndIsrResult) {
        scala.collection.immutable.Map failedPartitionsExcerpt = actualUpdateLeaderAndIsrResult.failedPartitions().mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Class<Exception>, String> apply(Exception e) {
                return new Tuple2(e.getClass(), (Object)e.getMessage());
            }
        });
        Assert.assertEquals((String)"Permanently failed updates do not match expected", expectedFailedPartitions, (Object)failedPartitionsExcerpt);
        Assert.assertEquals((String)"Retriable updates (due to BADVERSION) do not match expected", expectedPartitionsToRetry, (Object)actualUpdateLeaderAndIsrResult.partitionsToRetry());
        Assert.assertEquals((String)"Successful updates do not match expected", expectedSuccessfulPartitions, (Object)actualUpdateLeaderAndIsrResult.successfulPartitions());
    }

    @Test
    public void testUpdateLeaderAndIsr() {
        KafkaZkClient qual$30 = this.zkClient();
        String x$106 = TopicZNode$.MODULE$.path(this.topic1());
        byte[] x$107 = qual$30.createRecursive$default$2();
        boolean x$108 = qual$30.createRecursive$default$3();
        qual$30.createRecursive(x$106, x$107, x$108);
        this.checkUpdateLeaderAndIsrResult((scala.collection.immutable.Map<TopicPartition, LeaderAndIsr>)Predef$.MODULE$.Map().empty(), (Seq<TopicPartition>)((Seq)ArrayBuffer$.MODULE$.empty()), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition10()), (Object)new Tuple2(KeeperException.NoNodeException.class, (Object)"KeeperErrorCode = NoNode for /brokers/topics/topic1/partitions/0/state")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition11()), (Object)new Tuple2(KeeperException.NoNodeException.class, (Object)"KeeperErrorCode = NoNode for /brokers/topics/topic1/partitions/1/state"))})), this.zkClient().updateLeaderAndIsr(this.initialLeaderIsrs(), 4));
        this.zkClient().createTopicPartitionStatesRaw(this.initialLeaderIsrAndControllerEpochs());
        this.checkUpdateLeaderAndIsrResult(this.leaderIsrs(1, 1), (Seq<TopicPartition>)((Seq)ArrayBuffer$.MODULE$.empty()), Predef$.MODULE$.Map().empty(), this.zkClient().updateLeaderAndIsr(this.leaderIsrs(1, 0), 4));
        this.checkUpdateLeaderAndIsrResult((scala.collection.immutable.Map<TopicPartition, LeaderAndIsr>)Predef$.MODULE$.Map().empty(), (Seq<TopicPartition>)((Seq)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), this.topicPartition11()}))), Predef$.MODULE$.Map().empty(), this.zkClient().updateLeaderAndIsr(this.leaderIsrs(1, 0), 4));
        scala.collection.immutable.Map mixedState = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition10()), (Object)new LeaderAndIsr(1, 2, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5})), 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition11()), (Object)new LeaderAndIsr(0, 2, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), 0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition20()), (Object)new LeaderAndIsr(0, 2, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), 0))}));
        this.checkUpdateLeaderAndIsrResult((scala.collection.immutable.Map<TopicPartition, LeaderAndIsr>)this.leaderIsrs(2, 2).filterKeys((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;

            public final boolean apply(TopicPartition x$9) {
                TopicPartition topicPartition = x$9;
                TopicPartition topicPartition2 = this.$outer.topicPartition10();
                return !(topicPartition != null ? !topicPartition.equals(topicPartition2) : topicPartition2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }), (Seq<TopicPartition>)((Seq)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition11()}))), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition20()), (Object)new Tuple2(KeeperException.NoNodeException.class, (Object)"KeeperErrorCode = NoNode for /brokers/topics/topic2/partitions/0/state"))})), this.zkClient().updateLeaderAndIsr(mixedState, 4));
    }

    public void kafka$zk$KafkaZkClientTest$$checkGetDataResponse(scala.collection.immutable.Map<TopicPartition, LeaderIsrAndControllerEpoch> leaderIsrAndControllerEpochs, TopicPartition topicPartition, GetDataResponse response) {
        int zkVersion = ((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochs.apply((Object)topicPartition)).leaderAndIsr().zkVersion();
        Assert.assertEquals((Object)KeeperException.Code.OK, (Object)response.resultCode());
        Assert.assertEquals((Object)TopicPartitionStateZNode$.MODULE$.path(topicPartition), (Object)response.path());
        Assert.assertEquals((Object)new Some((Object)topicPartition), (Object)response.ctx());
        Assert.assertEquals((Object)new Some(leaderIsrAndControllerEpochs.apply((Object)topicPartition)), (Object)TopicPartitionStateZNode$.MODULE$.decode(response.data(), this.statWithVersion(zkVersion)));
    }

    public CreateResponse kafka$zk$KafkaZkClientTest$$eraseMetadata(CreateResponse response) {
        ResponseMetadata x$109 = new ResponseMetadata(0L, 0L);
        KeeperException.Code x$110 = response.copy$default$1();
        String x$111 = response.copy$default$2();
        Option x$112 = response.copy$default$3();
        String x$113 = response.copy$default$4();
        return response.copy(x$110, x$111, x$112, x$113, x$109);
    }

    @Test
    public void testGetTopicsAndPartitions() {
        Assert.assertTrue((boolean)this.zkClient().getAllTopicsInCluster().isEmpty());
        Assert.assertTrue((boolean)this.zkClient().getAllPartitions().isEmpty());
        KafkaZkClient qual$31 = this.zkClient();
        String x$114 = TopicZNode$.MODULE$.path(this.topic1());
        byte[] x$115 = qual$31.createRecursive$default$2();
        boolean x$116 = qual$31.createRecursive$default$3();
        qual$31.createRecursive(x$114, x$115, x$116);
        KafkaZkClient qual$32 = this.zkClient();
        String x$117 = TopicZNode$.MODULE$.path(this.topic2());
        byte[] x$118 = qual$32.createRecursive$default$2();
        boolean x$119 = qual$32.createRecursive$default$3();
        qual$32.createRecursive(x$117, x$118, x$119);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()})), (Object)this.zkClient().getAllTopicsInCluster().toSet());
        Assert.assertTrue((boolean)this.zkClient().getAllPartitions().isEmpty());
        this.zkClient().createTopicPartitionStatesRaw(this.initialLeaderIsrAndControllerEpochs());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), this.topicPartition11()})), (Object)this.zkClient().getAllPartitions());
    }

    @Test
    public void testCreateAndGetTopicPartitionStatesRaw() {
        KafkaZkClient qual$33 = this.zkClient();
        String x$120 = TopicZNode$.MODULE$.path(this.topic1());
        byte[] x$121 = qual$33.createRecursive$default$2();
        boolean x$122 = qual$33.createRecursive$default$3();
        qual$33.createRecursive(x$120, x$121, x$122);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateResponse[]{new CreateResponse(KeeperException.Code.OK, TopicPartitionStateZNode$.MODULE$.path(this.topicPartition10()), (Option)new Some((Object)this.topicPartition10()), TopicPartitionStateZNode$.MODULE$.path(this.topicPartition10()), new ResponseMetadata(0L, 0L)), new CreateResponse(KeeperException.Code.OK, TopicPartitionStateZNode$.MODULE$.path(this.topicPartition11()), (Option)new Some((Object)this.topicPartition11()), TopicPartitionStateZNode$.MODULE$.path(this.topicPartition11()), new ResponseMetadata(0L, 0L))})), (Object)((TraversableOnce)this.zkClient().createTopicPartitionStatesRaw(this.initialLeaderIsrAndControllerEpochs()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;

            public final CreateResponse apply(CreateResponse response) {
                return this.$outer.kafka$zk$KafkaZkClientTest$$eraseMetadata(response);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).toList());
        Seq getResponses = this.zkClient().getTopicPartitionStatesRaw(this.topicPartitions10_11());
        Assert.assertEquals((long)2L, (long)getResponses.size());
        ((IterableLike)this.topicPartitions10_11().zip((GenIterable)getResponses, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;

            public final void apply(Tuple2<TopicPartition, GetDataResponse> x0$1) {
                Tuple2<TopicPartition, GetDataResponse> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    GetDataResponse r = (GetDataResponse)tuple2._2();
                    this.$outer.kafka$zk$KafkaZkClientTest$$checkGetDataResponse(this.$outer.initialLeaderIsrAndControllerEpochs(), tp, r);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateResponse[]{new CreateResponse(KeeperException.Code.NODEEXISTS, TopicPartitionStateZNode$.MODULE$.path(this.topicPartition10()), (Option)new Some((Object)this.topicPartition10()), null, new ResponseMetadata(0L, 0L)), new CreateResponse(KeeperException.Code.NODEEXISTS, TopicPartitionStateZNode$.MODULE$.path(this.topicPartition11()), (Option)new Some((Object)this.topicPartition11()), null, new ResponseMetadata(0L, 0L))})), (Object)((TraversableOnce)this.zkClient().createTopicPartitionStatesRaw(this.initialLeaderIsrAndControllerEpochs()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;

            public final CreateResponse apply(CreateResponse response) {
                return this.$outer.kafka$zk$KafkaZkClientTest$$eraseMetadata(response);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).toList());
    }

    @Test
    public void testSetTopicPartitionStatesRaw() {
        KafkaZkClient qual$34 = this.zkClient();
        String x$123 = TopicZNode$.MODULE$.path(this.topic1());
        byte[] x$124 = qual$34.createRecursive$default$2();
        boolean x$125 = qual$34.createRecursive$default$3();
        qual$34.createRecursive(x$123, x$124, x$125);
        Assert.assertEquals((Object)this.expectedSetDataResponses$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), this.topicPartition11()}), KeeperException.Code.NONODE, null), (Object)((TraversableOnce)this.zkClient().setTopicPartitionStatesRaw(this.initialLeaderIsrAndControllerEpochs()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final SetDataResponse apply(SetDataResponse x$10) {
                ResponseMetadata x$126 = new ResponseMetadata(0L, 0L);
                KeeperException.Code x$127 = x$10.copy$default$1();
                String x$128 = x$10.copy$default$2();
                Option x$129 = x$10.copy$default$3();
                Stat x$130 = x$10.copy$default$4();
                return x$10.copy(x$127, x$128, x$129, x$130, x$126);
            }
        }, Seq$.MODULE$.canBuildFrom())).toList());
        this.zkClient().createTopicPartitionStatesRaw(this.initialLeaderIsrAndControllerEpochs());
        Assert.assertEquals((Object)this.expectedSetDataResponses$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), this.topicPartition11()}), KeeperException.Code.OK, this.statWithVersion(1)), (Object)((TraversableOnce)this.zkClient().setTopicPartitionStatesRaw(this.kafka$zk$KafkaZkClientTest$$leaderIsrAndControllerEpochs(1, 0)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;

            public final SetDataResponse apply(SetDataResponse response) {
                return this.$outer.kafka$zk$KafkaZkClientTest$$eraseMetadataAndStat(response);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).toList());
        Seq getResponses = this.zkClient().getTopicPartitionStatesRaw(this.topicPartitions10_11());
        Assert.assertEquals((long)2L, (long)getResponses.size());
        ((IterableLike)this.topicPartitions10_11().zip((GenIterable)getResponses, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;

            public final void apply(Tuple2<TopicPartition, GetDataResponse> x0$2) {
                Tuple2<TopicPartition, GetDataResponse> tuple2 = x0$2;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    GetDataResponse r = (GetDataResponse)tuple2._2();
                    this.$outer.kafka$zk$KafkaZkClientTest$$checkGetDataResponse(this.$outer.kafka$zk$KafkaZkClientTest$$leaderIsrAndControllerEpochs(1, 0), tp, r);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)this.expectedSetDataResponses$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), this.topicPartition11()}), KeeperException.Code.OK, this.statWithVersion(2)), (Object)((TraversableOnce)this.otherZkClient().setTopicPartitionStatesRaw(this.kafka$zk$KafkaZkClientTest$$leaderIsrAndControllerEpochs(2, 1)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;

            public final SetDataResponse apply(SetDataResponse response) {
                return this.$outer.kafka$zk$KafkaZkClientTest$$eraseMetadataAndStat(response);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).toList());
    }

    @Test
    public void testReassignPartitionsInProgress() {
        Assert.assertFalse((boolean)this.zkClient().reassignPartitionsInProgress());
        KafkaZkClient qual$35 = this.zkClient();
        String x$131 = ReassignPartitionsZNode$.MODULE$.path();
        byte[] x$132 = qual$35.createRecursive$default$2();
        boolean x$133 = qual$35.createRecursive$default$3();
        qual$35.createRecursive(x$131, x$132, x$133);
        Assert.assertTrue((boolean)this.zkClient().reassignPartitionsInProgress());
    }

    @Test
    public void testGetTopicPartitionStates() {
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getTopicPartitionState(this.topicPartition10()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getLeaderForPartition(this.topicPartition10()));
        KafkaZkClient qual$36 = this.zkClient();
        String x$134 = TopicZNode$.MODULE$.path(this.topic1());
        byte[] x$135 = qual$36.createRecursive$default$2();
        boolean x$136 = qual$36.createRecursive$default$3();
        qual$36.createRecursive(x$134, x$135, x$136);
        this.zkClient().createTopicPartitionStatesRaw(this.initialLeaderIsrAndControllerEpochs());
        Assert.assertEquals(this.initialLeaderIsrAndControllerEpochs(), (Object)this.zkClient().getTopicPartitionStates((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), this.topicPartition11()}))));
        Assert.assertEquals((Object)new Some(this.initialLeaderIsrAndControllerEpochs().apply((Object)this.topicPartition10())), (Object)this.zkClient().getTopicPartitionState(this.topicPartition10()));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)this.zkClient().getLeaderForPartition(this.topicPartition10()));
        TopicPartition notExistingPartition = new TopicPartition(this.topic1(), 2);
        Assert.assertTrue((boolean)this.zkClient().getTopicPartitionStates((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{notExistingPartition}))).isEmpty());
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition10()), this.initialLeaderIsrAndControllerEpochs().apply((Object)this.topicPartition10()))})), (Object)this.zkClient().getTopicPartitionStates((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), notExistingPartition}))));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getTopicPartitionState(notExistingPartition));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getLeaderForPartition(notExistingPartition));
    }

    public SetDataResponse kafka$zk$KafkaZkClientTest$$eraseMetadataAndStat(SetDataResponse response) {
        Stat stat = response.stat() == null ? null : this.statWithVersion(response.stat().getVersion());
        ResponseMetadata x$137 = new ResponseMetadata(0L, 0L);
        Stat x$138 = stat;
        KeeperException.Code x$139 = response.copy$default$1();
        String x$140 = response.copy$default$2();
        Option x$141 = response.copy$default$3();
        return response.copy(x$139, x$140, x$141, x$138, x$137);
    }

    @Test
    public void testControllerEpochMethods() {
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getControllerEpoch());
        Assert.assertEquals((String)"Setting non existing nodes should return NONODE results", (Object)new SetDataResponse(KeeperException.Code.NONODE, ControllerEpochZNode$.MODULE$.path(), (Option)None$.MODULE$, null, new ResponseMetadata(0L, 0L)), (Object)this.kafka$zk$KafkaZkClientTest$$eraseMetadataAndStat(this.zkClient().setControllerEpochRaw(1, 0)));
        Assert.assertEquals((String)"Creating non existing nodes is OK", (Object)new CreateResponse(KeeperException.Code.OK, ControllerEpochZNode$.MODULE$.path(), (Option)None$.MODULE$, ControllerEpochZNode$.MODULE$.path(), new ResponseMetadata(0L, 0L)), (Object)this.kafka$zk$KafkaZkClientTest$$eraseMetadata(this.zkClient().createControllerEpochRaw(0)));
        Assert.assertEquals((long)0L, (long)((Tuple2)this.zkClient().getControllerEpoch().get())._1$mcI$sp());
        Assert.assertEquals((String)"Attemt to create existing nodes should return NODEEXISTS", (Object)new CreateResponse(KeeperException.Code.NODEEXISTS, ControllerEpochZNode$.MODULE$.path(), (Option)None$.MODULE$, null, new ResponseMetadata(0L, 0L)), (Object)this.kafka$zk$KafkaZkClientTest$$eraseMetadata(this.zkClient().createControllerEpochRaw(0)));
        Assert.assertEquals((String)"Updating existing nodes is OK", (Object)new SetDataResponse(KeeperException.Code.OK, ControllerEpochZNode$.MODULE$.path(), (Option)None$.MODULE$, this.statWithVersion(1), new ResponseMetadata(0L, 0L)), (Object)this.kafka$zk$KafkaZkClientTest$$eraseMetadataAndStat(this.zkClient().setControllerEpochRaw(1, 0)));
        Assert.assertEquals((long)1L, (long)((Tuple2)this.zkClient().getControllerEpoch().get())._1$mcI$sp());
        Assert.assertEquals((String)"Updating with wrong ZK version returns BADVERSION", (Object)new SetDataResponse(KeeperException.Code.BADVERSION, ControllerEpochZNode$.MODULE$.path(), (Option)None$.MODULE$, null, new ResponseMetadata(0L, 0L)), (Object)this.kafka$zk$KafkaZkClientTest$$eraseMetadataAndStat(this.zkClient().setControllerEpochRaw(1, 0)));
    }

    @Test
    public void testControllerManagementMethods() {
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getControllerId());
        this.zkClient().checkedEphemeralCreate(ControllerZNode$.MODULE$.path(), ControllerZNode$.MODULE$.encode(1, 123456L));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)this.zkClient().getControllerId());
        this.zkClient().deleteController();
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getControllerId());
    }

    @Test
    public void testZNodeChangeHandlerForDataChange() {
        String mockPath = "/foo";
        CountDownLatch znodeChangeHandlerCountDownLatch = new CountDownLatch(1);
        ZNodeChangeHandler zNodeChangeHandler = new ZNodeChangeHandler(this, mockPath, znodeChangeHandlerCountDownLatch){
            private final String path;
            private final CountDownLatch znodeChangeHandlerCountDownLatch$1;

            public void handleDeletion() {
                ZNodeChangeHandler.class.handleDeletion((ZNodeChangeHandler)this);
            }

            public void handleDataChange() {
                ZNodeChangeHandler.class.handleDataChange((ZNodeChangeHandler)this);
            }

            public void handleCreation() {
                this.znodeChangeHandlerCountDownLatch$1.countDown();
            }

            public String path() {
                return this.path;
            }
            {
                this.znodeChangeHandlerCountDownLatch$1 = znodeChangeHandlerCountDownLatch$1;
                ZNodeChangeHandler.class.$init$((ZNodeChangeHandler)this);
                this.path = mockPath$1;
            }
        };
        this.zkClient().registerZNodeChangeHandlerAndCheckExistence(zNodeChangeHandler);
        KafkaZkClient qual$37 = this.zkClient();
        String x$142 = mockPath;
        byte[] x$143 = qual$37.createRecursive$default$2();
        boolean x$144 = qual$37.createRecursive$default$3();
        qual$37.createRecursive(x$142, x$143, x$144);
        Assert.assertTrue((String)"Failed to receive create notification", (boolean)znodeChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testClusterIdMethods() {
        String clusterId = CoreUtils$.MODULE$.generateUuidAsBase64();
        this.zkClient().createOrGetClusterId(clusterId);
        Assert.assertEquals((Object)clusterId, (Object)this.zkClient().getClusterId().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;

            public final Nothing$ apply() {
                return this.$outer.fail("No cluster id found", new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 975));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
    }

    @Test
    public void testBrokerSequenceIdMethods() {
        int sequenceId = this.zkClient().generateBrokerSequenceId();
        Assert.assertEquals((long)(sequenceId + 1), (long)this.zkClient().generateBrokerSequenceId());
    }

    @Test
    public void testCreateTopLevelPaths() {
        this.zkClient().createTopLevelPaths();
        ZkData$.MODULE$.PersistentZkPaths().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;

            public final void apply(String path) {
                Assert.assertTrue((boolean)this.$outer.zkClient().pathExists(path));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testPreferredReplicaElectionMethods() {
        Assert.assertTrue((boolean)this.zkClient().getPreferredReplicaElection().isEmpty());
        scala.collection.immutable.Set electionPartitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic1(), 0), new TopicPartition(this.topic1(), 1)}));
        this.zkClient().createPreferredReplicaElection(electionPartitions);
        Assert.assertEquals((Object)electionPartitions, (Object)this.zkClient().getPreferredReplicaElection());
        this.intercept((Function0)new Serializable(this, electionPartitions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;
            private final scala.collection.immutable.Set electionPartitions$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.zkClient().createPreferredReplicaElection(this.electionPartitions$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.electionPartitions$1 = electionPartitions$1;
            }
        }, ClassTag$.MODULE$.apply(KeeperException.NodeExistsException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1001));
        this.zkClient().deletePreferredReplicaElection();
        Assert.assertTrue((boolean)this.zkClient().getPreferredReplicaElection().isEmpty());
    }

    private Option<String> dataAsString(String path) {
        Tuple2 tuple2 = this.zkClient().getDataAndStat(path);
        if (tuple2 != null) {
            Option data;
            Option option;
            Option data2 = option = (data = (Option)tuple2._1());
            return data2.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(byte[] x$11) {
                    return new String(x$11, StandardCharsets.UTF_8);
                }
            });
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testDelegationTokenMethods() {
        Assert.assertFalse((boolean)this.zkClient().pathExists(DelegationTokensZNode$.MODULE$.path()));
        Assert.assertFalse((boolean)this.zkClient().pathExists(DelegationTokenChangeNotificationZNode$.MODULE$.path()));
        this.zkClient().createDelegationTokenPaths();
        Assert.assertTrue((boolean)this.zkClient().pathExists(DelegationTokensZNode$.MODULE$.path()));
        Assert.assertTrue((boolean)this.zkClient().pathExists(DelegationTokenChangeNotificationZNode$.MODULE$.path()));
        String tokenId = "token1";
        KafkaPrincipal owner = SecurityUtils.parseKafkaPrincipal((String)"User:owner1");
        List renewers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{SecurityUtils.parseKafkaPrincipal((String)"User:renewer1"), SecurityUtils.parseKafkaPrincipal((String)"User:renewer1")}));
        TokenInformation tokenInfo = new TokenInformation(tokenId, owner, (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)renewers).asJava(), System.currentTimeMillis(), System.currentTimeMillis(), System.currentTimeMillis());
        byte[] bytes = new byte[20];
        Random$.MODULE$.nextBytes(bytes);
        DelegationToken token = new DelegationToken(tokenInfo, bytes);
        Assert.assertTrue((boolean)this.zkClient().getDelegationTokenInfo(tokenId).isEmpty());
        Assert.assertFalse((boolean)this.zkClient().deleteDelegationToken(tokenId));
        this.zkClient().setOrCreateDelegationToken(token);
        Assert.assertEquals((Object)tokenInfo, (Object)this.zkClient().getDelegationTokenInfo(tokenId).get());
        tokenInfo.setExpiryTimestamp(System.currentTimeMillis());
        this.zkClient().setOrCreateDelegationToken(token);
        Assert.assertEquals((Object)tokenInfo, (Object)this.zkClient().getDelegationTokenInfo(tokenId).get());
        Assert.assertTrue((boolean)this.zkClient().deleteDelegationToken(tokenId));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getDelegationTokenInfo(tokenId));
    }

    @Test
    public void testConsumerOffsetPath() {
        String consumerGroup = "test-group";
        String topic = "test-topic";
        int partition = 2;
        String expectedConsumerGroupOffsetsPath = this.getConsumersOffsetsZkPath$1(consumerGroup, topic, partition);
        String actualConsumerGroupOffsetsPath = ConsumerOffset$.MODULE$.path(consumerGroup, topic, Predef$.MODULE$.int2Integer(partition));
        Assert.assertEquals((Object)expectedConsumerGroupOffsetsPath, (Object)actualConsumerGroupOffsetsPath);
    }

    private final Seq expectedSetDataResponses$1(Seq topicPartitions, KeeperException.Code resultCode, Stat stat) {
        return (Seq)topicPartitions.map((Function1)new Serializable(this, resultCode, stat){
            public static final long serialVersionUID = 0L;
            private final KeeperException.Code resultCode$1;
            private final Stat stat$1;

            public final SetDataResponse apply(TopicPartition topicPartition) {
                return new SetDataResponse(this.resultCode$1, TopicPartitionStateZNode$.MODULE$.path(topicPartition), (Option)new Some((Object)topicPartition), this.stat$1, new ResponseMetadata(0L, 0L));
            }
            {
                this.resultCode$1 = resultCode$1;
                this.stat$1 = stat$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private final String getConsumersOffsetsZkPath$1(String consumerGroup, String topic, int partition) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/consumers/", "/offsets/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{consumerGroup, topic, BoxesRunTime.boxToInteger((int)partition)}));
    }

    public KafkaZkClientTest() {
        this.group = "my-group";
        this.topic1 = "topic1";
        this.topic2 = "topic2";
    }
}

