/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricPredicate;
import java.io.File;
import java.util.Properties;
import javax.management.ObjectName;
import kafka.admin.RackAwareMode;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.metrics.KafkaMetricsGroup$;
import kafka.server.BrokerTopicStats$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma\u0001B\u0001\u0003\u0001\u001d\u00111\"T3ue&\u001c7\u000fV3ti*\u00111\u0001B\u0001\b[\u0016$(/[2t\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0004\u0001!q\u0001CA\u0005\r\u001b\u0005Q!BA\u0006\u0005\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\n\u00055Q!AF&bM.\f7+\u001a:wKJ$Vm\u001d;ICJtWm]:\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u0005\u001daunZ4j]\u001eDQ!\u0006\u0001\u0005\u0002Y\ta\u0001P5oSRtD#A\f\u0011\u0005a\u0001Q\"\u0001\u0002\t\u000fi\u0001!\u0019!C\u00017\u0005Aa.^7O_\u0012,7/F\u0001\u001d!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\rIe\u000e\u001e\u0005\u0007G\u0001\u0001\u000b\u0011\u0002\u000f\u0002\u00139,XNT8eKN\u0004\u0003bB\u0013\u0001\u0005\u0004%\taG\u0001\t]Vl\u0007+\u0019:ug\"1q\u0005\u0001Q\u0001\nq\t\u0011B\\;n!\u0006\u0014Ho\u001d\u0011\t\u000f%\u0002!\u0019!C\u0001U\u0005yqN^3se&$\u0017N\\4Qe>\u00048/F\u0001,!\ta\u0013'D\u0001.\u0015\tqs&\u0001\u0003vi&d'\"\u0001\u0019\u0002\t)\fg/Y\u0005\u0003e5\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u0019!\u0004\u0001)A\u0005W\u0005\u0001rN^3se&$\u0017N\\4Qe>\u00048\u000f\t\u0005\u0006m\u0001!\taN\u0001\u0010O\u0016tWM]1uK\u000e{gNZ5hgV\t\u0001\bE\u0002:\u0003\u0012s!AO \u000f\u0005mrT\"\u0001\u001f\u000b\u0005u2\u0011A\u0002\u001fs_>$h(C\u0001 \u0013\t\u0001e$A\u0004qC\u000e\\\u0017mZ3\n\u0005\t\u001b%aA*fc*\u0011\u0001I\b\t\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000f\u0012\taa]3sm\u0016\u0014\u0018BA%G\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u000f-\u0003!\u0019!C\u00017\u0005Ia.T3tg\u0006<Wm\u001d\u0005\u0007\u001b\u0002\u0001\u000b\u0011\u0002\u000f\u0002\u00159lUm]:bO\u0016\u001c\b\u0005C\u0003P\u0001\u0011\u0005\u0001+A\u0013uKN$X*\u001a;sS\u000e\u001c(+\u001a9peR,'/\u00114uKJ$U\r\\3uS:<Gk\u001c9jGR\t\u0011\u000b\u0005\u0002\u001e%&\u00111K\b\u0002\u0005+:LG\u000f\u000b\u0002O+B\u0011akW\u0007\u0002/*\u0011\u0001,W\u0001\u0006UVt\u0017\u000e\u001e\u0006\u00025\u0006\u0019qN]4\n\u0005q;&\u0001\u0002+fgRDQA\u0018\u0001\u0005\u0002A\u000bA\u0007^3ti\n\u0013xn[3s)>\u0004\u0018nY'fiJL7m]+oe\u0016<\u0017n\u001d;fe\u0016$\u0017I\u001a;fe\u0012+G.\u001a;j]\u001e$v\u000e]5dQ\tiV\u000bC\u0003b\u0001\u0011\u0005\u0001+A\nuKN$8\t\\;ti\u0016\u0014\u0018\nZ'fiJL7\r\u000b\u0002a+\")A\r\u0001C\u0001!\u0006AB/Z:u/&tGm\\<t'RLH.\u001a+bO:\u000bW.Z:)\u0005\r,\u0006\"B4\u0001\t\u0003\u0001\u0016\u0001\t;fgR\u0014%o\\6feR{\u0007/[2NKR\u0014\u0018nY:CsR,7/\u00138PkRD#AZ+\t\u000b)\u0004A\u0011\u0001)\u0002+Q,7\u000f^\"p]R\u0014x\u000e\u001c7fe6+GO]5dg\"\u0012\u0011.\u0016\u0005\u0006[\u0002!\t\u0001U\u0001!i\u0016\u001cHoU3tg&|g.\u0012=qSJ,G*[:uK:,'/T3ue&\u001c7\u000f\u000b\u0002m+\")\u0001\u000f\u0001C\u0005c\u0006QQ.\u001a;fe\u000e{WO\u001c;\u0015\u0005I,\bCA\u000ft\u0013\t!hD\u0001\u0003M_:<\u0007\"\u0002<p\u0001\u00049\u0018AC7fiJL7MT1nKB\u0011\u0001p\u001f\b\u0003;eL!A\u001f\u0010\u0002\rA\u0013X\rZ3g\u0013\taXP\u0001\u0004TiJLgn\u001a\u0006\u0003uzAaa \u0001\u0005\n\u0005\u0005\u0011!\u0005;pa&\u001cW*\u001a;sS\u000e<%o\\;qgR!\u00111AA\b!\u0015\t)!a\u0003x\u001b\t\t9AC\u0002\u0002\ny\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti!a\u0002\u0003\u0007M+G\u000f\u0003\u0004\u0002\u0012y\u0004\ra^\u0001\u0006i>\u0004\u0018n\u0019")
public class MetricsTest
extends KafkaServerTestHarness {
    private final int numNodes;
    private final int numParts;
    private final Properties overridingProps = new Properties();
    private final int nMessages;

    public int numNodes() {
        return this.numNodes;
    }

    public int numParts() {
        return this.numParts;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        int x$15 = this.numNodes();
        String x$16 = this.zkConnect();
        boolean x$17 = true;
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfigs$default$3();
        Option<SecurityProtocol> x$19 = TestUtils$.MODULE$.createBrokerConfigs$default$5();
        Option<File> x$20 = TestUtils$.MODULE$.createBrokerConfigs$default$6();
        Option<Properties> x$21 = TestUtils$.MODULE$.createBrokerConfigs$default$7();
        boolean x$22 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$23 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$24 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$25 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        Map<Object, String> x$26 = TestUtils$.MODULE$.createBrokerConfigs$default$12();
        int x$27 = TestUtils$.MODULE$.createBrokerConfigs$default$13();
        boolean x$28 = TestUtils$.MODULE$.createBrokerConfigs$default$14();
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(x$15, x$16, x$18, x$17, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetricsTest $outer;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.$outer.overridingProps());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public int nMessages() {
        return this.nMessages;
    }

    @Test
    public void testMetricsReporterAfterDeletingTopic() {
        String topic = "test-topic-metric";
        AdminZkClient qual$1 = this.adminZkClient();
        String x$29 = topic;
        int x$30 = 1;
        int x$31 = 1;
        Properties x$32 = qual$1.createTopic$default$4();
        RackAwareMode x$33 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$29, x$30, x$31, x$32, x$33);
        this.adminZkClient().deleteTopic(topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, (Seq<KafkaServer>)this.servers());
        Assert.assertEquals((String)"Topic metrics exists after deleteTopic", (Object)Set$.MODULE$.empty(), this.topicMetricGroups(topic));
    }

    @Test
    public void testBrokerTopicMetricsUnregisteredAfterDeletingTopic() {
        String topic = "test-broker-topic-metric";
        AdminZkClient qual$2 = this.adminZkClient();
        String x$34 = topic;
        int x$35 = 2;
        int x$36 = 1;
        Properties x$37 = qual$2.createTopic$default$4();
        RackAwareMode x$38 = qual$2.createTopic$default$5();
        qual$2.createTopic(x$34, x$35, x$36, x$37, x$38);
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.generateAndProduceMessages$default$4(), TestUtils$.MODULE$.generateAndProduceMessages$default$5());
        Assert.assertTrue((String)"Topic metrics don't exist", (boolean)this.topicMetricGroups(topic).nonEmpty());
        this.servers().foreach((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$1;

            public final void apply(KafkaServer s) {
                Assert.assertNotNull((Object)s.brokerTopicStats().topicStats(this.topic$1));
            }
            {
                this.topic$1 = topic$1;
            }
        });
        this.adminZkClient().deleteTopic(topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, (Seq<KafkaServer>)this.servers());
        Assert.assertEquals((String)"Topic metrics exists after deleteTopic", (Object)Set$.MODULE$.empty(), this.topicMetricGroups(topic));
    }

    @Test
    public void testClusterIdMetric() {
        java.util.Map metrics = Metrics.defaultRegistry().allMetrics();
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$2) {
                String string = x$2.getMBeanName();
                String string2 = "kafka.server:type=KafkaServer,name=ClusterId";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }), (long)1L);
    }

    @Test
    public void testWindowsStyleTagNames() {
        String path = "C:\\windows-path\\kafka-logs";
        Map tags = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dir"), (Object)path)}));
        String expectedMBeanName = ((TraversableOnce)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)tags.keySet().head(), ObjectName.quote(path)}))).mkString("=");
        MetricName metric = KafkaMetricsGroup$.MODULE$.metricName("test-metric", tags);
        String $org_scalatest_assert_macro_left = metric.getMBeanName();
        String $org_scalatest_assert_macro_right = expectedMBeanName;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "endsWith", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.endsWith($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MetricsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
    }

    @Test
    public void testBrokerTopicMetricsBytesInOut() {
        String topic = "test-bytes-in-out";
        String replicationBytesIn = BrokerTopicStats$.MODULE$.ReplicationBytesInPerSec();
        String replicationBytesOut = BrokerTopicStats$.MODULE$.ReplicationBytesOutPerSec();
        String bytesIn = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",topic=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BrokerTopicStats$.MODULE$.BytesInPerSec(), topic}));
        String bytesOut = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",topic=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BrokerTopicStats$.MODULE$.BytesOutPerSec(), topic}));
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), "2");
        this.createTopic(topic, 1, this.numNodes(), topicConfig);
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.generateAndProduceMessages$default$4(), TestUtils$.MODULE$.generateAndProduceMessages$default$5());
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.servers().foreach((Function1)new Serializable(this, topic, topicPartition){
            public static final long serialVersionUID = 0L;
            private final String topic$2;
            private final TopicPartition topicPartition$1;

            public final void apply(KafkaServer server) {
                LogManager qual$3 = server.logManager();
                TopicPartition x$39 = new TopicPartition(this.topic$2, 0);
                boolean x$40 = qual$3.getLog$default$2();
                Option log2 = qual$3.getLog(x$39, x$40);
                int brokerId = server.config().brokerId();
                Option logSize = log2.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(Log x$3) {
                        return x$3.size();
                    }
                });
                Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected broker ", " to have a Log for ", " with positive size, actual: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)brokerId), this.topicPartition$1, logSize})), (boolean)BoxesRunTime.unboxToBoolean((Object)logSize.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(long x$4) {
                        return this.apply$mcZJ$sp(x$4);
                    }

                    public boolean apply$mcZJ$sp(long x$4) {
                        return x$4 > 0L;
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return false;
                    }
                })));
            }
            {
                this.topic$2 = topic$2;
                this.topicPartition$1 = topicPartition$1;
            }
        });
        long initialReplicationBytesIn = this.meterCount(replicationBytesIn);
        long initialReplicationBytesOut = this.meterCount(replicationBytesOut);
        long initialBytesIn = this.meterCount(bytesIn);
        long initialBytesOut = this.meterCount(bytesOut);
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.generateAndProduceMessages$default$4(), TestUtils$.MODULE$.generateAndProduceMessages$default$5());
        Assert.assertTrue((this.meterCount(replicationBytesIn) > initialReplicationBytesIn ? 1 : 0) != 0);
        Assert.assertTrue((this.meterCount(replicationBytesOut) > initialReplicationBytesOut ? 1 : 0) != 0);
        Assert.assertTrue((this.meterCount(bytesIn) > initialBytesIn ? 1 : 0) != 0);
        Assert.assertEquals((long)initialBytesOut, (long)this.meterCount(bytesOut));
        TestUtils$.MODULE$.consumeTopicRecords((Seq<KafkaServer>)this.servers(), topic, this.nMessages() * 2, TestUtils$.MODULE$.consumeTopicRecords$default$4(), TestUtils$.MODULE$.consumeTopicRecords$default$5(), TestUtils$.MODULE$.consumeTopicRecords$default$6(), TestUtils$.MODULE$.consumeTopicRecords$default$7());
        Assert.assertTrue((this.meterCount(bytesOut) > initialBytesOut ? 1 : 0) != 0);
    }

    @Test
    public void testControllerMetrics() {
        java.util.Map metrics = Metrics.defaultRegistry().allMetrics();
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$5) {
                String string = x$5.getMBeanName();
                String string2 = "kafka.controller:type=KafkaController,name=ActiveControllerCount";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$6) {
                String string = x$6.getMBeanName();
                String string2 = "kafka.controller:type=KafkaController,name=OfflinePartitionsCount";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$7) {
                String string = x$7.getMBeanName();
                String string2 = "kafka.controller:type=KafkaController,name=PreferredReplicaImbalanceCount";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$8) {
                String string = x$8.getMBeanName();
                String string2 = "kafka.controller:type=KafkaController,name=GlobalTopicCount";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$9) {
                String string = x$9.getMBeanName();
                String string2 = "kafka.controller:type=KafkaController,name=GlobalPartitionCount";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }), (long)1L);
    }

    @Test
    public void testSessionExpireListenerMetrics() {
        java.util.Map metrics = Metrics.defaultRegistry().allMetrics();
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$10) {
                String string = x$10.getMBeanName();
                String string2 = "kafka.server:type=SessionExpireListener,name=SessionState";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$11) {
                String string = x$11.getMBeanName();
                String string2 = "kafka.server:type=SessionExpireListener,name=ZooKeeperExpiresPerSec";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$12) {
                String string = x$12.getMBeanName();
                String string2 = "kafka.server:type=SessionExpireListener,name=ZooKeeperDisconnectsPerSec";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }), (long)1L);
    }

    private long meterCount(String metricName) {
        return ((Meter)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1)new Serializable(this, metricName){
            public static final long serialVersionUID = 0L;
            private final String metricName$1;

            public final boolean apply(MetricName x$13) {
                return x$13.getMBeanName().endsWith(this.metricName$1);
            }
            {
                this.metricName$1 = metricName$1;
            }
        }).values().headOption().getOrElse((Function0)new Serializable(this, metricName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetricsTest $outer;
            private final String metricName$1;

            public final Nothing$ apply() {
                return this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to find metric ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.metricName$1})), new Position("MetricsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.metricName$1 = metricName$1;
            }
        })).count();
    }

    private Set<String> topicMetricGroups(String topic) {
        Regex topicMetricRegex = new Regex(new StringBuilder().append((Object)".*BrokerTopicMetrics.*(").append((Object)topic).append((Object)")$").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        scala.collection.mutable.Set metricGroups = (scala.collection.mutable.Set)JavaConverters$.MODULE$.asScalaSetConverter(Metrics.defaultRegistry().groupedMetrics(MetricPredicate.ALL).keySet()).asScala();
        return (Set)metricGroups.filter((Function1)new Serializable(this, topicMetricRegex){
            public static final long serialVersionUID = 0L;
            private final Regex topicMetricRegex$1;

            public final boolean apply(String x$14) {
                return this.topicMetricRegex$1.pattern().matcher(x$14).matches();
            }
            {
                this.topicMetricRegex$1 = topicMetricRegex$1;
            }
        });
    }

    public MetricsTest() {
        this.numNodes = 2;
        this.numParts = 2;
        this.overridingProps().put(KafkaConfig$.MODULE$.NumPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.numParts())).toString());
        this.nMessages = 2;
    }
}

