/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import joptsimple.OptionSpec;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.utils.Exit$;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001e4A!\u0001\u0002\u0001\u000f\t\t#+Z1tg&<g\u000eU1si&$\u0018n\u001c8t\u0007>lW.\u00198e\u0003J<7\u000fV3ti*\u00111\u0001B\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tI\u0001#D\u0001\u000b\u0015\tYA\"A\u0003kk:LGO\u0003\u0002\u000e\u001d\u0005I1oY1mCR,7\u000f\u001e\u0006\u0002\u001f\u0005\u0019qN]4\n\u0005EQ!A\u0003&V]&$8+^5uK\")1\u0003\u0001C\u0001)\u00051A(\u001b8jiz\"\u0012!\u0006\t\u0003-\u0001i\u0011A\u0001\u0005\u00061\u0001!\t!G\u0001\u0006g\u0016$X\u000b\u001d\u000b\u00025A\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t!QK\\5uQ\t9\u0012\u0005\u0005\u0002#I5\t1E\u0003\u0002\f\u001d%\u0011Qe\t\u0002\u0007\u0005\u00164wN]3\t\u000b\u001d\u0002A\u0011A\r\u0002\u0011Q,\u0017M\u001d#po:D#AJ\u0015\u0011\u0005\tR\u0013BA\u0016$\u0005\u0015\te\r^3s\u0011\u0015i\u0003\u0001\"\u0001\u001a\u0003=\u001a\bn\\;mI\u000e{'O]3di2L\b+\u0019:tKZ\u000bG.\u001b3NS:LW.^7HK:,'/\u0019;f\u001fB$\u0018n\u001c8tQ\tas\u0006\u0005\u0002#a%\u0011\u0011g\t\u0002\u0005)\u0016\u001cH\u000fC\u00034\u0001\u0011\u0005\u0011$\u0001\u0018tQ>,H\u000eZ\"peJ,7\r\u001e7z!\u0006\u00148/\u001a,bY&$W*\u001b8j[VlW\t_3dkR,w\n\u001d;j_:\u001c\bF\u0001\u001a0\u0011\u00151\u0004\u0001\"\u0001\u001a\u00035\u001a\bn\\;mI\u000e{'O]3di2L\b+\u0019:tKZ\u000bG.\u001b3NS:LW.^7WKJLg-_(qi&|gn\u001d\u0015\u0003k=BQ!\u000f\u0001\u0005\u0002e\t!e\u001d5pk2$\u0017\t\u001c7poRC'o\u001c;uY\u0016|\u0005\u000f^5p]>sW\t_3dkR,\u0007F\u0001\u001d0\u0011\u0015a\u0004\u0001\"\u0001\u001a\u0003i\u0019\bn\\;mIV\u001bX\rR3gCVdGo]%g\u000b:\f'\r\\3eQ\tYt\u0006C\u0003@\u0001\u0011\u0005\u0011$\u0001\ntQ>,H\u000e\u001a$bS2LeMT8Be\u001e\u001c\bF\u0001 0\u0011\u0015\u0011\u0005\u0001\"\u0001\u001a\u0003Q\u0019\bn\\;mI\u001a\u000b\u0017\u000e\\%g\u00052\fgn[!sO\"\u0012\u0011i\f\u0005\u0006\u000b\u0002!\t!G\u0001&g\"|W\u000f\u001c3O_R\fE\u000e\\8x\u000bb,7-\u001e;f/&$\b\u000eV8qS\u000e\u001cx\n\u001d;j_:D#\u0001R\u0018\t\u000b!\u0003A\u0011A\r\u0002AMDw.\u001e7e\u001d>$\u0018\t\u001c7po\u0016CXmY;uK^KG\u000f\u001b\"s_.,'o\u001d\u0015\u0003\u000f>BQa\u0013\u0001\u0005\u0002e\taf\u001d5pk2$gj\u001c;BY2|w/\u0012=fGV$XmV5uQ>,HOU3bgNLwM\\7f]R|\u0005\u000f^5p]\"\u0012!j\f\u0005\u0006\u001d\u0002!\t!G\u00015g\"|W\u000f\u001c3O_R\fE\u000e\\8x\u000f\u0016tWM]1uK^KG\u000f[8vi\n\u0013xn[3sg\u0006sG\rV8qS\u000e\u001cx\n\u001d;j_:\u001c\bFA'0\u0011\u0015\t\u0006\u0001\"\u0001\u001a\u0003)\u001a\bn\\;mI:{G/\u00117m_^<UM\\3sCR,w+\u001b;i_V$(I]8lKJ\u001cx\n\u001d;j_:D#\u0001U\u0018\t\u000bQ\u0003A\u0011A\r\u0002SMDw.\u001e7e\u001d>$\u0018\t\u001c7po\u001e+g.\u001a:bi\u0016<\u0016\u000e\u001e5pkR$v\u000e]5dg>\u0003H/[8oQ\t\u0019v\u0006C\u0003X\u0001\u0011\u0005\u0011$\u0001\u0015tQ>,H\u000e\u001a(pi\u0006cGn\\<HK:,'/\u0019;f/&$\b\u000e\u00165s_R$H.Z(qi&|g\u000e\u000b\u0002W_!)!\f\u0001C\u00013\u0005a3\u000f[8vY\u0012tu\u000e^!mY><x)\u001a8fe\u0006$XmV5uQJ+\u0017m]:jO:lWM\u001c;PaRLwN\u001c\u0015\u00033>BQ!\u0018\u0001\u0005\u0002e\tQf\u001d5pk2$gj\u001c;BY2|wOV3sS\u001aLx+\u001b;i_V$(+Z1tg&<g.\\3oi>\u0003H/[8oQ\tav\u0006C\u0003a\u0001\u0011\u0005\u0011$A\u0015tQ>,H\u000e\u001a(pi\u0006cGn\\<Ce>\\WM]:MSN$x+\u001b;i-\u0016\u0014\u0018NZ=PaRLwN\u001c\u0015\u0003?>BQa\u0019\u0001\u0005\u0002e\tae\u001d5pk2$gj\u001c;BY2|w\u000f\u00165s_R$H.Z,ji\"4VM]5gs>\u0003H/[8oQ\t\u0011w\u0006C\u0003g\u0001\u0011\u0005\u0011$\u0001\u0013tQ>,H\u000e\u001a(pi\u0006cGn\\<U_BL7m](qi&|gnV5uQZ+'/\u001b4zQ\t)w\u0006C\u0003j\u0001\u0011\u0005!.\u0001\btQ>,H\u000e\u001a$bS2<\u0016\u000e\u001e5\u0015\u0007iYG\u000fC\u0003mQ\u0002\u0007Q.A\u0002ng\u001e\u0004\"A\\9\u000f\u0005my\u0017B\u00019\u001d\u0003\u0019\u0001&/\u001a3fM&\u0011!o\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Ad\u0002\"B;i\u0001\u00041\u0018\u0001B1sON\u00042aG<n\u0013\tAHDA\u0003BeJ\f\u0017\u0010")
public class ReassignPartitionsCommandArgsTest
extends JUnitSuite {
    @Before
    public void setUp() {
        Exit$.MODULE$.setExitProcedure((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(int x$1, Option<String> message) {
                throw new IllegalArgumentException((String)message.orNull(Predef$.MODULE$.$conforms()));
            }
        });
    }

    @After
    public void tearDown() {
        Exit$.MODULE$.resetExitProcedure();
    }

    @Test
    public void shouldCorrectlyParseValidMinimumGenerateOptions() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--generate", "--broker-list", "101,102", "--topics-to-move-json-file", "myfile.json"});
        ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(args);
    }

    @Test
    public void shouldCorrectlyParseValidMinimumExecuteOptions() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--execute", "--reassignment-json-file", "myfile.json"});
        ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(args);
    }

    @Test
    public void shouldCorrectlyParseValidMinimumVerifyOptions() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--verify", "--reassignment-json-file", "myfile.json"});
        ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(args);
    }

    @Test
    public void shouldAllowThrottleOptionOnExecute() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--execute", "--throttle", "100", "--reassignment-json-file", "myfile.json"});
        ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(args);
    }

    @Test
    public void shouldUseDefaultsIfEnabled() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--execute", "--reassignment-json-file", "myfile.json"});
        ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts = ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(args);
        Assert.assertEquals((long)10000L, (long)BoxesRunTime.unboxToLong((Object)opts.options().valueOf((OptionSpec)opts.timeoutOpt())));
        Assert.assertEquals((long)-1L, (long)BoxesRunTime.unboxToLong((Object)opts.options().valueOf((OptionSpec)opts.interBrokerThrottleOpt())));
    }

    @Test
    public void shouldFailIfNoArgs() {
        String[] args = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        this.shouldFailWith("This command moves topic partitions between replicas.", args);
    }

    @Test
    public void shouldFailIfBlankArg() {
        String[] args = (String[])((Object[])new String[]{" "});
        this.shouldFailWith("Command must include exactly one action: --generate, --execute or --verify", args);
    }

    @Test
    public void shouldNotAllowExecuteWithTopicsOption() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--execute", "--reassignment-json-file", "myfile.json", "--topics-to-move-json-file", "myfile.json"});
        this.shouldFailWith("Option \"[execute]\" can't be used with option\"[topics-to-move-json-file]\"", args);
    }

    @Test
    public void shouldNotAllowExecuteWithBrokers() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--execute", "--reassignment-json-file", "myfile.json", "--broker-list", "101,102"});
        this.shouldFailWith("Option \"[execute]\" can't be used with option\"[broker-list]\"", args);
    }

    @Test
    public void shouldNotAllowExecuteWithoutReassignmentOption() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--execute"});
        this.shouldFailWith("If --execute option is used, command must include --reassignment-json-file that was output during the --generate option", args);
    }

    @Test
    public void shouldNotAllowGenerateWithoutBrokersAndTopicsOptions() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--generate"});
        this.shouldFailWith("If --generate option is used, command must include both --topics-to-move-json-file and --broker-list options", args);
    }

    @Test
    public void shouldNotAllowGenerateWithoutBrokersOption() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--topics-to-move-json-file", "myfile.json", "--generate"});
        this.shouldFailWith("If --generate option is used, command must include both --topics-to-move-json-file and --broker-list options", args);
    }

    @Test
    public void shouldNotAllowGenerateWithoutTopicsOption() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--broker-list", "101,102", "--generate"});
        this.shouldFailWith("If --generate option is used, command must include both --topics-to-move-json-file and --broker-list options", args);
    }

    @Test
    public void shouldNotAllowGenerateWithThrottleOption() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--generate", "--broker-list", "101,102", "--throttle", "100", "--topics-to-move-json-file", "myfile.json"});
        this.shouldFailWith("Option \"[generate]\" can't be used with option\"[throttle]\"", args);
    }

    @Test
    public void shouldNotAllowGenerateWithReassignmentOption() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--generate", "--broker-list", "101,102", "--topics-to-move-json-file", "myfile.json", "--reassignment-json-file", "myfile.json"});
        this.shouldFailWith("Option \"[generate]\" can't be used with option\"[reassignment-json-file]\"", args);
    }

    @Test
    public void shouldNotAllowVerifyWithoutReassignmentOption() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--verify"});
        this.shouldFailWith("If --verify option is used, command must include --reassignment-json-file that was used during the --execute option", args);
    }

    @Test
    public void shouldNotAllowBrokersListWithVerifyOption() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--verify", "--broker-list", "100,101", "--reassignment-json-file", "myfile.json"});
        this.shouldFailWith("Option \"[verify]\" can't be used with option\"[broker-list]\"", args);
    }

    @Test
    public void shouldNotAllowThrottleWithVerifyOption() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--verify", "--throttle", "100", "--reassignment-json-file", "myfile.json"});
        this.shouldFailWith("Option \"[verify]\" can't be used with option\"[throttle]\"", args);
    }

    @Test
    public void shouldNotAllowTopicsOptionWithVerify() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--verify", "--reassignment-json-file", "myfile.json", "--topics-to-move-json-file", "myfile.json"});
        this.shouldFailWith("Option \"[verify]\" can't be used with option\"[topics-to-move-json-file]\"", args);
    }

    public void shouldFailWith(String msg, String[] args) {
        try {
            ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(args);
            throw this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should have failed with [", "] but no failure occurred."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{msg})), new Position("ReassignPartitionsCommandArgsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
        }
        catch (Exception exception) {
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected exception with message:\\n[", "]\\nbut was\\n[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{msg, exception.getMessage()})), (boolean)exception.getMessage().startsWith(msg));
            return;
        }
    }
}

