/*
 * Decompiled with CFR 0.152.
 */
package kafka;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import kafka.TestLinearWriteSpeed$;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogManager$;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.utils.Scheduler;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005}t!B\u0001\u0003\u0011\u0003)\u0011\u0001\u0006+fgRd\u0015N\\3be^\u0013\u0018\u000e^3Ta\u0016,GMC\u0001\u0004\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"AB\u0004\u000e\u0003\t1Q\u0001\u0003\u0002\t\u0002%\u0011A\u0003V3ti2Kg.Z1s/JLG/Z*qK\u0016$7CA\u0004\u000b!\tYa\"D\u0001\r\u0015\u0005i\u0011!B:dC2\f\u0017BA\b\r\u0005\u0019\te.\u001f*fM\")\u0011c\u0002C\u0001%\u00051A(\u001b8jiz\"\u0012!\u0002\u0005\u0006)\u001d!\t!F\u0001\u0005[\u0006Lg\u000e\u0006\u0002\u00173A\u00111bF\u0005\u000311\u0011A!\u00168ji\")!d\u0005a\u00017\u0005!\u0011M]4t!\rYADH\u0005\u0003;1\u0011Q!\u0011:sCf\u0004\"a\b\u0012\u000f\u0005-\u0001\u0013BA\u0011\r\u0003\u0019\u0001&/\u001a3fM&\u00111\u0005\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0005baa\u0002\u0014\b!\u0003\r\na\n\u0002\t/JLG/\u00192mKN\u0011QE\u0003\u0005\u0006S\u00152\tAK\u0001\u0006oJLG/\u001a\u000b\u0002WA\u00111\u0002L\u0005\u0003[1\u00111!\u00138u\u0011\u0015ySE\"\u00011\u0003\u0015\u0019Gn\\:f)\u00051b\u0001\u0002\u001a\b\u0001M\u0012A\"T7ba^\u0013\u0018\u000e^1cY\u0016\u001c2!\r\u00065!\t)T%D\u0001\b\u0011!9\u0014G!b\u0001\n\u0003A\u0014\u0001\u00024jY\u0016,\u0012!\u000f\t\u0003u}j\u0011a\u000f\u0006\u0003yu\n!![8\u000b\u0003y\nAA[1wC&\u0011\u0001i\u000f\u0002\u0005\r&dW\r\u0003\u0005Cc\t\u0005\t\u0015!\u0003:\u0003\u00151\u0017\u000e\\3!\u0011!!\u0015G!A!\u0002\u0013)\u0015\u0001B:ju\u0016\u0004\"a\u0003$\n\u0005\u001dc!\u0001\u0002'p]\u001eD\u0001\"S\u0019\u0003\u0006\u0004%\tAS\u0001\bG>tG/\u001a8u+\u0005Y\u0005C\u0001'P\u001b\u0005i%B\u0001(>\u0003\rq\u0017n\\\u0005\u0003!6\u0013!BQ=uK\n+hMZ3s\u0011!\u0011\u0016G!A!\u0002\u0013Y\u0015\u0001C2p]R,g\u000e\u001e\u0011\t\u000bE\tD\u0011\u0001+\u0015\tU3v\u000b\u0017\t\u0003kEBQaN*A\u0002eBQ\u0001R*A\u0002\u0015CQ!S*A\u0002-CqAW\u0019C\u0002\u0013\u00051,A\u0002sC\u001a,\u0012\u0001\u0018\t\u0003uuK!AX\u001e\u0003!I\u000bg\u000eZ8n\u0003\u000e\u001cWm]:GS2,\u0007B\u000212A\u0003%A,\u0001\u0003sC\u001a\u0004\u0003b\u000222\u0005\u0004%\taY\u0001\u0007EV4g-\u001a:\u0016\u0003\u0011\u0004\"\u0001T3\n\u0005\u0019l%\u0001E'baB,GMQ=uK\n+hMZ3s\u0011\u0019A\u0017\u0007)A\u0005I\u00069!-\u001e4gKJ\u0004\u0003\"B\u00152\t\u0003Q\u0003\"B\u00182\t\u0003\u0001d\u0001\u00027\b\u00015\u0014qb\u00115b]:,Gn\u0016:ji\u0006\u0014G.Z\n\u0004W*!\u0004\u0002C\u001cl\u0005\u000b\u0007I\u0011\u0001\u001d\t\u0011\t['\u0011!Q\u0001\neB\u0001\"S6\u0003\u0006\u0004%\tA\u0013\u0005\t%.\u0014\t\u0011)A\u0005\u0017\")\u0011c\u001bC\u0001gR\u0019A/\u001e<\u0011\u0005UZ\u0007\"B\u001cs\u0001\u0004I\u0004\"B%s\u0001\u0004Y\u0005b\u0002.l\u0005\u0004%\ta\u0017\u0005\u0007A.\u0004\u000b\u0011\u0002/\t\u000fi\\'\u0019!C\u0001w\u000691\r[1o]\u0016dW#\u0001?\u0011\u0007u\f\t!D\u0001\u007f\u0015\tyX*\u0001\u0005dQ\u0006tg.\u001a7t\u0013\r\t\u0019A \u0002\f\r&dWm\u00115b]:,G\u000eC\u0004\u0002\b-\u0004\u000b\u0011\u0002?\u0002\u0011\rD\u0017M\u001c8fY\u0002BQ!K6\u0005\u0002)BQaL6\u0005\u0002A2a!a\u0004\b\u0001\u0005E!a\u0003'pO^\u0013\u0018\u000e^1cY\u0016\u001cB!!\u0004\u000bi!Q\u0011QCA\u0007\u0005\u000b\u0007I\u0011\u0001\u001d\u0002\u0007\u0011L'\u000f\u0003\u0006\u0002\u001a\u00055!\u0011!Q\u0001\ne\nA\u0001Z5sA!Y\u0011QDA\u0007\u0005\u0003\u0005\u000b\u0011BA\u0010\u0003\u0019\u0019wN\u001c4jOB!\u0011\u0011EA\u0014\u001b\t\t\u0019CC\u0002\u0002&\t\t1\u0001\\8h\u0013\u0011\tI#a\t\u0003\u00131{wmQ8oM&<\u0007bCA\u0017\u0003\u001b\u0011\t\u0011)A\u0005\u0003_\t\u0011b]2iK\u0012,H.\u001a:\u0011\t\u0005E\u0012qG\u0007\u0003\u0003gQ1!!\u000e\u0003\u0003\u0015)H/\u001b7t\u0013\u0011\tI$a\r\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\bbCA\u001f\u0003\u001b\u0011)\u0019!C\u0001\u0003\u007f\t\u0001\"\\3tg\u0006<Wm]\u000b\u0003\u0003\u0003\u0002B!a\u0011\u0002X5\u0011\u0011Q\t\u0006\u0005\u0003\u000f\nI%\u0001\u0004sK\u000e|'\u000f\u001a\u0006\u0005\u0003\u0017\ni%\u0001\u0004d_6lwN\u001c\u0006\u0004\u0007\u0005=#\u0002BA)\u0003'\na!\u00199bG\",'BAA+\u0003\ry'oZ\u0005\u0005\u00033\n)EA\u0007NK6|'/\u001f*fG>\u0014Hm\u001d\u0005\f\u0003;\niA!A!\u0002\u0013\t\t%A\u0005nKN\u001c\u0018mZ3tA!9\u0011#!\u0004\u0005\u0002\u0005\u0005DCCA2\u0003K\n9'!\u001b\u0002lA\u0019Q'!\u0004\t\u000f\u0005U\u0011q\fa\u0001s!A\u0011QDA0\u0001\u0004\ty\u0002\u0003\u0005\u0002.\u0005}\u0003\u0019AA\u0018\u0011!\ti$a\u0018A\u0002\u0005\u0005\u0003BCA\u0013\u0003\u001b\u0011\r\u0011\"\u0001\u0002pU\u0011\u0011\u0011\u000f\t\u0005\u0003C\t\u0019(\u0003\u0003\u0002v\u0005\r\"a\u0001'pO\"I\u0011\u0011PA\u0007A\u0003%\u0011\u0011O\u0001\u0005Y><\u0007\u0005\u0003\u0004*\u0003\u001b!\tA\u000b\u0005\u0007_\u00055A\u0011\u0001\u0019")
public final class TestLinearWriteSpeed {
    public static void main(String[] stringArray) {
        TestLinearWriteSpeed$.MODULE$.main(stringArray);
    }

    public static interface Writable {
        public int write();

        public void close();
    }

    public static class LogWritable
    implements Writable {
        private final File dir;
        private final MemoryRecords messages;
        private final Log log;

        public File dir() {
            return this.dir;
        }

        public MemoryRecords messages() {
            return this.messages;
        }

        public Log log() {
            return this.log;
        }

        @Override
        public int write() {
            this.log().appendAsLeader(this.messages(), 0, this.log().appendAsLeader$default$3());
            return this.messages().sizeInBytes();
        }

        @Override
        public void close() {
            this.log().close();
            Utils.delete((File)this.log().dir());
        }

        public LogWritable(File dir, LogConfig config, Scheduler scheduler, MemoryRecords messages) {
            this.dir = dir;
            this.messages = messages;
            Utils.delete((File)dir);
            this.log = Log$.MODULE$.apply(dir, config, 0L, 0L, scheduler, new BrokerTopicStats(), Time.SYSTEM, 3600000, LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), new LogDirFailureChannel(10));
        }
    }

    public static class MmapWritable
    implements Writable {
        private final File file;
        private final ByteBuffer content;
        private final RandomAccessFile raf;
        private final MappedByteBuffer buffer;

        public File file() {
            return this.file;
        }

        public ByteBuffer content() {
            return this.content;
        }

        public RandomAccessFile raf() {
            return this.raf;
        }

        public MappedByteBuffer buffer() {
            return this.buffer;
        }

        @Override
        public int write() {
            this.buffer().put(this.content());
            this.content().rewind();
            return this.content().limit();
        }

        @Override
        public void close() {
            this.raf().close();
        }

        public MmapWritable(File file, long size2, ByteBuffer content) {
            this.file = file;
            this.content = content;
            file.deleteOnExit();
            this.raf = new RandomAccessFile(file, "rw");
            this.raf().setLength(size2);
            this.buffer = this.raf().getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, this.raf().length());
        }
    }

    public static class ChannelWritable
    implements Writable {
        private final File file;
        private final ByteBuffer content;
        private final RandomAccessFile raf;
        private final FileChannel channel;

        public File file() {
            return this.file;
        }

        public ByteBuffer content() {
            return this.content;
        }

        public RandomAccessFile raf() {
            return this.raf;
        }

        public FileChannel channel() {
            return this.channel;
        }

        @Override
        public int write() {
            this.channel().write(this.content());
            this.content().rewind();
            return this.content().limit();
        }

        @Override
        public void close() {
            this.raf().close();
        }

        public ChannelWritable(File file, ByteBuffer content) {
            this.file = file;
            this.content = content;
            file.deleteOnExit();
            this.raf = new RandomAccessFile(file, "rw");
            this.channel = this.raf().getChannel();
        }
    }
}

