/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.generated;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.Bytes;

public class GroupMetadataValue
implements ApiMessage {
    String protocolType;
    int generation;
    String protocol;
    String leader;
    long currentStateTimestamp;
    List<MemberMetadata> members;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("protocol_type", (Type)Type.STRING, ""), new Field("generation", (Type)Type.INT32, ""), new Field("protocol", (Type)Type.NULLABLE_STRING, ""), new Field("leader", (Type)Type.NULLABLE_STRING, ""), new Field("members", (Type)new ArrayOf((Type)MemberMetadata.SCHEMA_0), "")});
    public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("protocol_type", (Type)Type.STRING, ""), new Field("generation", (Type)Type.INT32, ""), new Field("protocol", (Type)Type.NULLABLE_STRING, ""), new Field("leader", (Type)Type.NULLABLE_STRING, ""), new Field("members", (Type)new ArrayOf((Type)MemberMetadata.SCHEMA_1), "")});
    public static final Schema SCHEMA_2 = new Schema(new Field[]{new Field("protocol_type", (Type)Type.STRING, ""), new Field("generation", (Type)Type.INT32, ""), new Field("protocol", (Type)Type.NULLABLE_STRING, ""), new Field("leader", (Type)Type.NULLABLE_STRING, ""), new Field("current_state_timestamp", (Type)Type.INT64, ""), new Field("members", (Type)new ArrayOf((Type)MemberMetadata.SCHEMA_1), "")});
    public static final Schema SCHEMA_3 = new Schema(new Field[]{new Field("protocol_type", (Type)Type.STRING, ""), new Field("generation", (Type)Type.INT32, ""), new Field("protocol", (Type)Type.NULLABLE_STRING, ""), new Field("leader", (Type)Type.NULLABLE_STRING, ""), new Field("current_state_timestamp", (Type)Type.INT64, ""), new Field("members", (Type)new ArrayOf((Type)MemberMetadata.SCHEMA_3), "")});
    public static final Schema SCHEMA_4 = new Schema(new Field[]{new Field("protocol_type", (Type)Type.COMPACT_STRING, ""), new Field("generation", (Type)Type.INT32, ""), new Field("protocol", (Type)Type.COMPACT_NULLABLE_STRING, ""), new Field("leader", (Type)Type.COMPACT_NULLABLE_STRING, ""), new Field("current_state_timestamp", (Type)Type.INT64, ""), new Field("members", (Type)new CompactArrayOf((Type)MemberMetadata.SCHEMA_4), ""), Field.TaggedFieldsSection.of((Object[])new Object[0])});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 4;

    public GroupMetadataValue(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public GroupMetadataValue() {
        this.protocolType = "";
        this.generation = 0;
        this.protocol = "";
        this.leader = "";
        this.currentStateTimestamp = -1L;
        this.members = new ArrayList<MemberMetadata>(0);
    }

    public short apiKey() {
        return -1;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 4;
    }

    public void read(Readable _readable, short _version) {
        int i;
        ArrayList<MemberMetadata> newCollection;
        int arrayLength;
        int length = _version >= 4 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
        if (length < 0) {
            throw new RuntimeException("non-nullable field protocolType was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field protocolType had invalid length " + length);
        }
        this.protocolType = _readable.readString(length);
        this.generation = _readable.readInt();
        length = _version >= 4 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
        if (length < 0) {
            this.protocol = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field protocol had invalid length " + length);
            }
            this.protocol = _readable.readString(length);
        }
        length = _version >= 4 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
        if (length < 0) {
            this.leader = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field leader had invalid length " + length);
            }
            this.leader = _readable.readString(length);
        }
        this.currentStateTimestamp = _version >= 2 ? _readable.readLong() : -1L;
        if (_version >= 4) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field members was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new MemberMetadata(_readable, _version));
            }
            this.members = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field members was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList<MemberMetadata>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new MemberMetadata(_readable, _version));
            }
            this.members = newCollection;
        }
        this._unknownTaggedFields = null;
        if (_version >= 4) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        Object _stringBytes = _cache.getSerializedValue((Object)this.protocolType);
        if (_version >= 4) {
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
        } else {
            _writable.writeShort((short)((byte[])_stringBytes).length);
        }
        _writable.writeByteArray((byte[])_stringBytes);
        _writable.writeInt(this.generation);
        if (this.protocol == null) {
            if (_version >= 4) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeShort((short)-1);
            }
        } else {
            _stringBytes = _cache.getSerializedValue((Object)this.protocol);
            if (_version >= 4) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
        }
        if (this.leader == null) {
            if (_version >= 4) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeShort((short)-1);
            }
        } else {
            _stringBytes = _cache.getSerializedValue((Object)this.leader);
            if (_version >= 4) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
        }
        if (_version >= 2) {
            _writable.writeLong(this.currentStateTimestamp);
        }
        if (_version >= 4) {
            _writable.writeUnsignedVarint(this.members.size() + 1);
            _stringBytes = this.members.iterator();
            while (_stringBytes.hasNext()) {
                MemberMetadata membersElement = (MemberMetadata)_stringBytes.next();
                membersElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.members.size());
            _stringBytes = this.members.iterator();
            while (_stringBytes.hasNext()) {
                MemberMetadata membersElement = (MemberMetadata)_stringBytes.next();
                membersElement.write(_writable, _cache, _version);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 4) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        byte[] _stringBytes = this.protocolType.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'protocolType' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.protocolType, _stringBytes);
        if (_version >= 4) {
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        } else {
            _size.addBytes(_stringBytes.length + 2);
        }
        _size.addBytes(4);
        if (this.protocol == null) {
            if (_version >= 4) {
                _size.addBytes(1);
            } else {
                _size.addBytes(2);
            }
        } else {
            _stringBytes = this.protocol.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'protocol' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.protocol, _stringBytes);
            if (_version >= 4) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
        }
        if (this.leader == null) {
            if (_version >= 4) {
                _size.addBytes(1);
            } else {
                _size.addBytes(2);
            }
        } else {
            _stringBytes = this.leader.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'leader' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.leader, _stringBytes);
            if (_version >= 4) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
        }
        if (_version >= 2) {
            _size.addBytes(8);
        }
        if (_version >= 4) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.members.size() + 1)));
        } else {
            _size.addBytes(4);
        }
        for (MemberMetadata membersElement : this.members) {
            membersElement.addSize(_size, _cache, _version);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 4) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GroupMetadataValue)) {
            return false;
        }
        GroupMetadataValue other = (GroupMetadataValue)obj;
        if (this.protocolType == null ? other.protocolType != null : !this.protocolType.equals(other.protocolType)) {
            return false;
        }
        if (this.generation != other.generation) {
            return false;
        }
        if (this.protocol == null ? other.protocol != null : !this.protocol.equals(other.protocol)) {
            return false;
        }
        if (this.leader == null ? other.leader != null : !this.leader.equals(other.leader)) {
            return false;
        }
        if (this.currentStateTimestamp != other.currentStateTimestamp) {
            return false;
        }
        if (this.members == null ? other.members != null : !this.members.equals(other.members)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.protocolType == null ? 0 : this.protocolType.hashCode());
        hashCode = 31 * hashCode + this.generation;
        hashCode = 31 * hashCode + (this.protocol == null ? 0 : this.protocol.hashCode());
        hashCode = 31 * hashCode + (this.leader == null ? 0 : this.leader.hashCode());
        hashCode = 31 * hashCode + ((int)(this.currentStateTimestamp >> 32) ^ (int)this.currentStateTimestamp);
        hashCode = 31 * hashCode + (this.members == null ? 0 : this.members.hashCode());
        return hashCode;
    }

    public GroupMetadataValue duplicate() {
        GroupMetadataValue _duplicate = new GroupMetadataValue();
        _duplicate.protocolType = this.protocolType;
        _duplicate.generation = this.generation;
        _duplicate.protocol = this.protocol == null ? null : this.protocol;
        _duplicate.leader = this.leader == null ? null : this.leader;
        _duplicate.currentStateTimestamp = this.currentStateTimestamp;
        ArrayList<MemberMetadata> newMembers = new ArrayList<MemberMetadata>(this.members.size());
        for (MemberMetadata _element : this.members) {
            newMembers.add(_element.duplicate());
        }
        _duplicate.members = newMembers;
        return _duplicate;
    }

    public String toString() {
        return "GroupMetadataValue(protocolType=" + (this.protocolType == null ? "null" : "'" + this.protocolType.toString() + "'") + ", generation=" + this.generation + ", protocol=" + (this.protocol == null ? "null" : "'" + this.protocol.toString() + "'") + ", leader=" + (this.leader == null ? "null" : "'" + this.leader.toString() + "'") + ", currentStateTimestamp=" + this.currentStateTimestamp + ", members=" + MessageUtil.deepToString(this.members.iterator()) + ")";
    }

    public String protocolType() {
        return this.protocolType;
    }

    public int generation() {
        return this.generation;
    }

    public String protocol() {
        return this.protocol;
    }

    public String leader() {
        return this.leader;
    }

    public long currentStateTimestamp() {
        return this.currentStateTimestamp;
    }

    public List<MemberMetadata> members() {
        return this.members;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public GroupMetadataValue setProtocolType(String v) {
        this.protocolType = v;
        return this;
    }

    public GroupMetadataValue setGeneration(int v) {
        this.generation = v;
        return this;
    }

    public GroupMetadataValue setProtocol(String v) {
        this.protocol = v;
        return this;
    }

    public GroupMetadataValue setLeader(String v) {
        this.leader = v;
        return this;
    }

    public GroupMetadataValue setCurrentStateTimestamp(long v) {
        this.currentStateTimestamp = v;
        return this;
    }

    public GroupMetadataValue setMembers(List<MemberMetadata> v) {
        this.members = v;
        return this;
    }

    public static class MemberMetadata
    implements Message {
        String memberId;
        String groupInstanceId;
        String clientId;
        String clientHost;
        int rebalanceTimeout;
        int sessionTimeout;
        byte[] subscription;
        byte[] assignment;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("member_id", (Type)Type.STRING, ""), new Field("client_id", (Type)Type.STRING, ""), new Field("client_host", (Type)Type.STRING, ""), new Field("session_timeout", (Type)Type.INT32, ""), new Field("subscription", (Type)Type.BYTES, ""), new Field("assignment", (Type)Type.BYTES, "")});
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 4;

        public MemberMetadata(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public MemberMetadata() {
            this.memberId = "";
            this.groupInstanceId = null;
            this.clientId = "";
            this.clientHost = "";
            this.rebalanceTimeout = 0;
            this.sessionTimeout = 0;
            this.subscription = Bytes.EMPTY;
            this.assignment = Bytes.EMPTY;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        public void read(Readable _readable, short _version) {
            int length = _version >= 4 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field memberId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field memberId had invalid length " + length);
            }
            this.memberId = _readable.readString(length);
            if (_version >= 3) {
                length = _version >= 4 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
                if (length < 0) {
                    this.groupInstanceId = null;
                } else {
                    if (length > Short.MAX_VALUE) {
                        throw new RuntimeException("string field groupInstanceId had invalid length " + length);
                    }
                    this.groupInstanceId = _readable.readString(length);
                }
            } else {
                this.groupInstanceId = null;
            }
            length = _version >= 4 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field clientId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field clientId had invalid length " + length);
            }
            this.clientId = _readable.readString(length);
            length = _version >= 4 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field clientHost was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field clientHost had invalid length " + length);
            }
            this.clientHost = _readable.readString(length);
            this.rebalanceTimeout = _version >= 1 ? _readable.readInt() : 0;
            this.sessionTimeout = _readable.readInt();
            length = _version >= 4 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            if (length < 0) {
                throw new RuntimeException("non-nullable field subscription was serialized as null");
            }
            byte[] newBytes = _readable.readArray(length);
            this.subscription = newBytes;
            length = _version >= 4 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            if (length < 0) {
                throw new RuntimeException("non-nullable field assignment was serialized as null");
            }
            newBytes = _readable.readArray(length);
            this.assignment = newBytes;
            this._unknownTaggedFields = null;
            if (_version >= 4) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.memberId);
            if (_version >= 4) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            if (_version >= 3) {
                if (this.groupInstanceId == null) {
                    if (_version >= 4) {
                        _writable.writeUnsignedVarint(0);
                    } else {
                        _writable.writeShort((short)-1);
                    }
                } else {
                    _stringBytes = _cache.getSerializedValue((Object)this.groupInstanceId);
                    if (_version >= 4) {
                        _writable.writeUnsignedVarint(_stringBytes.length + 1);
                    } else {
                        _writable.writeShort((short)_stringBytes.length);
                    }
                    _writable.writeByteArray(_stringBytes);
                }
            }
            _stringBytes = _cache.getSerializedValue((Object)this.clientId);
            if (_version >= 4) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            _stringBytes = _cache.getSerializedValue((Object)this.clientHost);
            if (_version >= 4) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            if (_version >= 1) {
                _writable.writeInt(this.rebalanceTimeout);
            }
            _writable.writeInt(this.sessionTimeout);
            if (_version >= 4) {
                _writable.writeUnsignedVarint(this.subscription.length + 1);
            } else {
                _writable.writeInt(this.subscription.length);
            }
            _writable.writeByteArray(this.subscription);
            if (_version >= 4) {
                _writable.writeUnsignedVarint(this.assignment.length + 1);
            } else {
                _writable.writeInt(this.assignment.length);
            }
            _writable.writeByteArray(this.assignment);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 4) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = this.memberId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'memberId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.memberId, _stringBytes);
            if (_version >= 4) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            if (_version >= 3) {
                if (this.groupInstanceId == null) {
                    if (_version >= 4) {
                        _size.addBytes(1);
                    } else {
                        _size.addBytes(2);
                    }
                } else {
                    _stringBytes = this.groupInstanceId.getBytes(StandardCharsets.UTF_8);
                    if (_stringBytes.length > Short.MAX_VALUE) {
                        throw new RuntimeException("'groupInstanceId' field is too long to be serialized");
                    }
                    _cache.cacheSerializedValue((Object)this.groupInstanceId, _stringBytes);
                    if (_version >= 4) {
                        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
                    } else {
                        _size.addBytes(_stringBytes.length + 2);
                    }
                }
            }
            if ((_stringBytes = this.clientId.getBytes(StandardCharsets.UTF_8)).length > Short.MAX_VALUE) {
                throw new RuntimeException("'clientId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.clientId, _stringBytes);
            if (_version >= 4) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            _stringBytes = this.clientHost.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'clientHost' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.clientHost, _stringBytes);
            if (_version >= 4) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            if (_version >= 1) {
                _size.addBytes(4);
            }
            _size.addBytes(4);
            _size.addBytes(this.subscription.length);
            if (_version >= 4) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.subscription.length + 1)));
            } else {
                _size.addBytes(4);
            }
            _size.addBytes(this.assignment.length);
            if (_version >= 4) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.assignment.length + 1)));
            } else {
                _size.addBytes(4);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 4) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MemberMetadata)) {
                return false;
            }
            MemberMetadata other = (MemberMetadata)obj;
            if (this.memberId == null ? other.memberId != null : !this.memberId.equals(other.memberId)) {
                return false;
            }
            if (this.groupInstanceId == null ? other.groupInstanceId != null : !this.groupInstanceId.equals(other.groupInstanceId)) {
                return false;
            }
            if (this.clientId == null ? other.clientId != null : !this.clientId.equals(other.clientId)) {
                return false;
            }
            if (this.clientHost == null ? other.clientHost != null : !this.clientHost.equals(other.clientHost)) {
                return false;
            }
            if (this.rebalanceTimeout != other.rebalanceTimeout) {
                return false;
            }
            if (this.sessionTimeout != other.sessionTimeout) {
                return false;
            }
            if (!Arrays.equals(this.subscription, other.subscription)) {
                return false;
            }
            if (!Arrays.equals(this.assignment, other.assignment)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.memberId == null ? 0 : this.memberId.hashCode());
            hashCode = 31 * hashCode + (this.groupInstanceId == null ? 0 : this.groupInstanceId.hashCode());
            hashCode = 31 * hashCode + (this.clientId == null ? 0 : this.clientId.hashCode());
            hashCode = 31 * hashCode + (this.clientHost == null ? 0 : this.clientHost.hashCode());
            hashCode = 31 * hashCode + this.rebalanceTimeout;
            hashCode = 31 * hashCode + this.sessionTimeout;
            hashCode = 31 * hashCode + Arrays.hashCode(this.subscription);
            hashCode = 31 * hashCode + Arrays.hashCode(this.assignment);
            return hashCode;
        }

        public MemberMetadata duplicate() {
            MemberMetadata _duplicate = new MemberMetadata();
            _duplicate.memberId = this.memberId;
            _duplicate.groupInstanceId = this.groupInstanceId == null ? null : this.groupInstanceId;
            _duplicate.clientId = this.clientId;
            _duplicate.clientHost = this.clientHost;
            _duplicate.rebalanceTimeout = this.rebalanceTimeout;
            _duplicate.sessionTimeout = this.sessionTimeout;
            _duplicate.subscription = MessageUtil.duplicate((byte[])this.subscription);
            _duplicate.assignment = MessageUtil.duplicate((byte[])this.assignment);
            return _duplicate;
        }

        public String toString() {
            return "MemberMetadata(memberId=" + (this.memberId == null ? "null" : "'" + this.memberId.toString() + "'") + ", groupInstanceId=" + (this.groupInstanceId == null ? "null" : "'" + this.groupInstanceId.toString() + "'") + ", clientId=" + (this.clientId == null ? "null" : "'" + this.clientId.toString() + "'") + ", clientHost=" + (this.clientHost == null ? "null" : "'" + this.clientHost.toString() + "'") + ", rebalanceTimeout=" + this.rebalanceTimeout + ", sessionTimeout=" + this.sessionTimeout + ", subscription=" + Arrays.toString(this.subscription) + ", assignment=" + Arrays.toString(this.assignment) + ")";
        }

        public String memberId() {
            return this.memberId;
        }

        public String groupInstanceId() {
            return this.groupInstanceId;
        }

        public String clientId() {
            return this.clientId;
        }

        public String clientHost() {
            return this.clientHost;
        }

        public int rebalanceTimeout() {
            return this.rebalanceTimeout;
        }

        public int sessionTimeout() {
            return this.sessionTimeout;
        }

        public byte[] subscription() {
            return this.subscription;
        }

        public byte[] assignment() {
            return this.assignment;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public MemberMetadata setMemberId(String v) {
            this.memberId = v;
            return this;
        }

        public MemberMetadata setGroupInstanceId(String v) {
            this.groupInstanceId = v;
            return this;
        }

        public MemberMetadata setClientId(String v) {
            this.clientId = v;
            return this;
        }

        public MemberMetadata setClientHost(String v) {
            this.clientHost = v;
            return this;
        }

        public MemberMetadata setRebalanceTimeout(int v) {
            this.rebalanceTimeout = v;
            return this;
        }

        public MemberMetadata setSessionTimeout(int v) {
            this.sessionTimeout = v;
            return this;
        }

        public MemberMetadata setSubscription(byte[] v) {
            this.subscription = v;
            return this;
        }

        public MemberMetadata setAssignment(byte[] v) {
            this.assignment = v;
            return this;
        }

        static {
            SCHEMA_2 = SCHEMA_1 = new Schema(new Field[]{new Field("member_id", (Type)Type.STRING, ""), new Field("client_id", (Type)Type.STRING, ""), new Field("client_host", (Type)Type.STRING, ""), new Field("rebalance_timeout", (Type)Type.INT32, ""), new Field("session_timeout", (Type)Type.INT32, ""), new Field("subscription", (Type)Type.BYTES, ""), new Field("assignment", (Type)Type.BYTES, "")});
            SCHEMA_3 = new Schema(new Field[]{new Field("member_id", (Type)Type.STRING, ""), new Field("group_instance_id", (Type)Type.NULLABLE_STRING, ""), new Field("client_id", (Type)Type.STRING, ""), new Field("client_host", (Type)Type.STRING, ""), new Field("rebalance_timeout", (Type)Type.INT32, ""), new Field("session_timeout", (Type)Type.INT32, ""), new Field("subscription", (Type)Type.BYTES, ""), new Field("assignment", (Type)Type.BYTES, "")});
            SCHEMA_4 = new Schema(new Field[]{new Field("member_id", (Type)Type.COMPACT_STRING, ""), new Field("group_instance_id", (Type)Type.COMPACT_NULLABLE_STRING, ""), new Field("client_id", (Type)Type.COMPACT_STRING, ""), new Field("client_host", (Type)Type.COMPACT_STRING, ""), new Field("rebalance_timeout", (Type)Type.INT32, ""), new Field("session_timeout", (Type)Type.INT32, ""), new Field("subscription", (Type)Type.COMPACT_BYTES, ""), new Field("assignment", (Type)Type.COMPACT_BYTES, ""), Field.TaggedFieldsSection.of((Object[])new Object[0])});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4};
        }
    }
}

