/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.integtestsupport;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.isis.applib.AppManifest;
import org.apache.isis.applib.fixtures.InstallableFixture;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationDefault;
import org.apache.isis.core.commons.resource.ResourceStreamSource;
import org.apache.isis.core.commons.resource.ResourceStreamSourceContextLoaderClassPath;
import org.apache.isis.core.metamodel.facetapi.MetaModelRefiner;
import org.apache.isis.core.metamodel.facetdecorator.FacetDecorator;
import org.apache.isis.core.metamodel.layoutmetadata.LayoutMetadataReader;
import org.apache.isis.core.metamodel.layoutmetadata.json.LayoutMetadataReaderFromJson;
import org.apache.isis.core.metamodel.metamodelvalidator.dflt.MetaModelValidatorDefault;
import org.apache.isis.core.metamodel.progmodel.ProgrammingModel;
import org.apache.isis.core.metamodel.services.ServicesInjectorSpi;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidator;
import org.apache.isis.core.runtime.authentication.AuthenticationManager;
import org.apache.isis.core.runtime.authentication.standard.AuthenticationManagerStandard;
import org.apache.isis.core.runtime.authentication.standard.Authenticator;
import org.apache.isis.core.runtime.authorization.AuthorizationManager;
import org.apache.isis.core.runtime.authorization.standard.AuthorizationManagerStandard;
import org.apache.isis.core.runtime.fixtures.FixturesInstaller;
import org.apache.isis.core.runtime.fixtures.FixturesInstallerFromConfiguration;
import org.apache.isis.core.runtime.persistence.internal.RuntimeContextFromSession;
import org.apache.isis.core.runtime.services.ServicesInstallerFromConfiguration;
import org.apache.isis.core.runtime.services.ServicesInstallerFromConfigurationAndAnnotation;
import org.apache.isis.core.runtime.system.DeploymentType;
import org.apache.isis.core.runtime.system.IsisSystemException;
import org.apache.isis.core.runtime.system.persistence.PersistenceSessionFactory;
import org.apache.isis.core.runtime.systemusinginstallers.IsisComponentProviderAbstract;
import org.apache.isis.core.runtime.transaction.facetdecorator.standard.StandardTransactionFacetDecorator;
import org.apache.isis.core.security.authentication.AuthenticatorBypass;
import org.apache.isis.objectstore.jdo.datanucleus.DataNucleusPersistenceMechanismInstaller;
import org.apache.isis.progmodels.dflt.JavaReflectorHelper;
import org.apache.isis.progmodels.dflt.ProgrammingModelFacetsJava5;

public class IsisComponentProviderDefault
extends IsisComponentProviderAbstract {
    private final ProgrammingModel programmingModel;
    private final MetaModelValidator metaModelValidator;

    public IsisComponentProviderDefault(DeploymentType deploymentType, AppManifest appManifestIfAny, List<Object> servicesOverride, List<InstallableFixture> fixturesOverride, IsisConfiguration configurationOverride, ProgrammingModel programmingModelOverride, MetaModelValidator metaModelValidatorOverride) {
        super(deploymentType, appManifestIfAny);
        String fixtureClassNamesCsv;
        this.configuration = IsisComponentProviderDefault.elseDefault(configurationOverride);
        if (this.appManifest != null) {
            this.putAppManifestKey(this.appManifest);
            this.registerPackageNames(this.appManifest);
            this.specifyServicesAndRegisteredEntitiesUsing(this.appManifest);
            List fixtureClasses = this.appManifest.getFixtures();
            fixtureClassNamesCsv = this.classNamesFrom(fixtureClasses);
            this.overrideConfigurationUsing(this.appManifest);
            this.services = this.createServices(this.configuration);
        } else {
            fixtureClassNamesCsv = this.classNamesFrom(fixturesOverride);
            this.services = IsisComponentProviderDefault.elseDefault(servicesOverride, this.configuration);
        }
        this.putConfigurationProperty("isis.fixtures", fixtureClassNamesCsv);
        this.fixturesInstaller = IsisComponentProviderDefault.createFixturesInstaller(this.configuration);
        this.authenticationManager = IsisComponentProviderDefault.createAuthenticationManager(this.configuration);
        this.authorizationManager = IsisComponentProviderDefault.createAuthorizationManager(this.configuration);
        this.programmingModel = IsisComponentProviderDefault.elseDefault(programmingModelOverride, this.configuration);
        this.metaModelValidator = IsisComponentProviderDefault.elseDefault(metaModelValidatorOverride);
    }

    private List<Object> createServices(IsisConfiguration configuration) {
        ServicesInstallerFromConfigurationAndAnnotation servicesInstaller = new ServicesInstallerFromConfigurationAndAnnotation();
        servicesInstaller.setConfiguration(configuration);
        return servicesInstaller.getServices();
    }

    protected void doPutConfigurationProperty(String key, String value) {
        IsisConfigurationDefault configurationDefault = (IsisConfigurationDefault)this.configuration;
        configurationDefault.put(key, value);
    }

    private static IsisConfigurationDefault elseDefault(IsisConfiguration configuration) {
        return configuration != null ? (IsisConfigurationDefault)configuration : new IsisConfigurationDefault((ResourceStreamSource)ResourceStreamSourceContextLoaderClassPath.create((String)"config"));
    }

    private static List<Object> elseDefault(List<Object> servicesOverride, IsisConfiguration configuration) {
        return servicesOverride != null ? servicesOverride : IsisComponentProviderDefault.createDefaultServices(configuration);
    }

    private static List<Object> createDefaultServices(IsisConfiguration configuration) {
        ServicesInstallerFromConfiguration servicesInstaller = new ServicesInstallerFromConfiguration();
        servicesInstaller.setConfiguration(configuration);
        return servicesInstaller.getServices();
    }

    private static ProgrammingModel elseDefault(ProgrammingModel programmingModel, IsisConfiguration configuration) {
        return programmingModel != null ? programmingModel : IsisComponentProviderDefault.createDefaultProgrammingModel(configuration);
    }

    private static ProgrammingModel createDefaultProgrammingModel(IsisConfiguration configuration) {
        ProgrammingModelFacetsJava5 programmingModel = new ProgrammingModelFacetsJava5();
        ProgrammingModel.Util.includeFacetFactories((IsisConfiguration)configuration, (ProgrammingModel)programmingModel);
        ProgrammingModel.Util.excludeFacetFactories((IsisConfiguration)configuration, (ProgrammingModel)programmingModel);
        return programmingModel;
    }

    private static MetaModelValidator elseDefault(MetaModelValidator metaModelValidator) {
        return metaModelValidator != null ? metaModelValidator : new MetaModelValidatorDefault();
    }

    private static FixturesInstaller createFixturesInstaller(IsisConfiguration configuration) {
        FixturesInstallerFromConfiguration fixturesInstallerFromConfiguration = new FixturesInstallerFromConfiguration();
        fixturesInstallerFromConfiguration.setConfiguration(configuration);
        return fixturesInstallerFromConfiguration;
    }

    private static AuthenticationManager createAuthenticationManager(IsisConfiguration configuration) {
        AuthenticationManagerStandard authenticationManager = new AuthenticationManagerStandard(configuration);
        AuthenticatorBypass authenticator = new AuthenticatorBypass(configuration);
        authenticationManager.addAuthenticator((Authenticator)authenticator);
        return authenticationManager;
    }

    private static AuthorizationManager createAuthorizationManager(IsisConfiguration configuration) {
        return new AuthorizationManagerStandard(configuration);
    }

    public DeploymentType getDeploymentType() {
        return this.deploymentType;
    }

    public IsisConfiguration getConfiguration() {
        return this.configuration;
    }

    public List<Object> provideServices() {
        return this.services;
    }

    public FixturesInstaller provideFixturesInstaller() {
        return this.fixturesInstaller;
    }

    public SpecificationLoaderSpi provideSpecificationLoaderSpi(Collection<MetaModelRefiner> metaModelRefiners) throws IsisSystemException {
        HashSet facetDecorators = Sets.newHashSet((Object[])new FacetDecorator[]{new StandardTransactionFacetDecorator(this.getConfiguration())});
        ArrayList layoutMetadataReaders = Lists.newArrayList((Object[])new LayoutMetadataReader[]{new LayoutMetadataReaderFromJson()});
        return JavaReflectorHelper.createObjectReflector((ProgrammingModel)this.programmingModel, metaModelRefiners, (Set)facetDecorators, (List)layoutMetadataReaders, (MetaModelValidator)this.metaModelValidator, (IsisConfiguration)this.getConfiguration());
    }

    public AuthenticationManager provideAuthenticationManager(DeploymentType deploymentType) {
        return this.authenticationManager;
    }

    public AuthorizationManager provideAuthorizationManager(DeploymentType deploymentType) {
        return this.authorizationManager;
    }

    public PersistenceSessionFactory providePersistenceSessionFactory(DeploymentType deploymentType, ServicesInjectorSpi servicesInjectorSpi, RuntimeContextFromSession runtimeContext) {
        DataNucleusPersistenceMechanismInstaller installer = new DataNucleusPersistenceMechanismInstaller();
        return installer.createPersistenceSessionFactory(deploymentType, servicesInjectorSpi, this.getConfiguration(), runtimeContext);
    }
}

