/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.zookeeper.org.apache.zookeeper.server.upgrade;

import java.io.File;
import java.io.IOException;
import org.apache.flink.shaded.zookeeper.org.apache.zookeeper.server.DataTree;
import org.apache.flink.shaded.zookeeper.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.flink.shaded.zookeeper.org.apache.zookeeper.server.upgrade.UpgradeSnapShotV1;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeMain {
    File snapShotDir;
    File dataDir;
    File bkupsnapShotDir;
    File bkupdataDir;
    File currentdataDir;
    File currentsnapShotDir;
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeMain.class);
    private static final String USAGE = "Usage: UpgradeMain dataDir snapShotDir";
    private static final int LASTVERSION = 1;
    private static final int CURRENTVERSION = 2;
    private static final String dirName = "version-";
    private static final String manual = "Please take manual steps to sanitize your database.\n Please read the upgrade manual";

    public UpgradeMain(File dataDir, File snapShotDir) {
        this.snapShotDir = snapShotDir;
        this.dataDir = dataDir;
        this.bkupdataDir = new File(dataDir, "version-1");
        this.bkupsnapShotDir = new File(snapShotDir, "version-1");
        this.currentsnapShotDir = new File(snapShotDir, "version-2");
        this.currentdataDir = new File(dataDir, "version-2");
    }

    private void createAllDirs() throws IOException {
        String error = "backup directory " + this.bkupdataDir + " already exists";
        LOG.info("Creating previous version data dir " + this.bkupdataDir);
        if (!this.bkupdataDir.mkdirs()) {
            LOG.error(error);
            LOG.error(manual);
            throw new IOException(error);
        }
        LOG.info("Creating previous version snapshot dir " + this.bkupdataDir);
        if (!this.bkupsnapShotDir.mkdirs() && !this.bkupsnapShotDir.exists()) {
            LOG.error(error);
            LOG.error(manual);
            throw new IOException(error);
        }
        error = "current directory " + this.currentdataDir + " already exists";
        LOG.info("Creating current data dir " + this.currentdataDir);
        if (!this.currentdataDir.mkdirs()) {
            LOG.error(error);
            LOG.error(manual);
            throw new IOException(error);
        }
        LOG.info("Creating current snapshot dir " + this.currentdataDir);
        if (!this.currentsnapShotDir.mkdirs() && !this.currentsnapShotDir.exists()) {
            LOG.error(error);
            LOG.error(manual);
            throw new IOException(error);
        }
    }

    void copyFiles(File srcDir, File dstDir, String filter) throws IOException {
        File[] list;
        for (File file : list = srcDir.listFiles()) {
            String name = file.getName();
            if (!name.startsWith(filter)) continue;
            File dest = new File(dstDir, name);
            LOG.info("Renaming " + file + " to " + dest);
            if (file.renameTo(dest)) continue;
            throw new IOException("Unable to rename " + file + " to " + dest);
        }
    }

    public void runUpgrade() throws IOException {
        if (!this.dataDir.exists()) {
            throw new IOException(this.dataDir + " does not exist");
        }
        if (!this.snapShotDir.exists()) {
            throw new IOException(this.snapShotDir + " does not exist");
        }
        this.createAllDirs();
        try {
            this.copyFiles(this.dataDir, this.bkupdataDir, "log");
            this.copyFiles(this.snapShotDir, this.bkupsnapShotDir, "snapshot");
        }
        catch (IOException io) {
            LOG.error("Failed in backing up.");
            throw io;
        }
        UpgradeSnapShotV1 upgrade = new UpgradeSnapShotV1(this.bkupdataDir, this.bkupsnapShotDir);
        LOG.info("Creating new data tree");
        DataTree dt = upgrade.getNewDataTree();
        FileTxnSnapLog filesnapLog = new FileTxnSnapLog(this.dataDir, this.snapShotDir);
        LOG.info("snapshotting the new datatree");
        filesnapLog.save(dt, upgrade.getSessionWithTimeOuts());
        LOG.info("Upgrade is complete");
    }

    public static void main(String[] argv) {
        if (argv.length < 2) {
            LOG.error(USAGE);
            System.exit(-1);
        }
        try {
            UpgradeMain upgrade = new UpgradeMain(new File(argv[0]), new File(argv[1]));
            upgrade.runUpgrade();
        }
        catch (Throwable th) {
            LOG.error("Upgrade Error: Please read the docs for manual failure recovery ", th);
        }
    }
}

