/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.akka.org.jboss.netty.channel.socket.nio;

import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.socket.nio.AbstractNioWorker;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.socket.nio.WorkerPool;
import org.apache.flink.shaded.akka.org.jboss.netty.logging.InternalLogger;
import org.apache.flink.shaded.akka.org.jboss.netty.logging.InternalLoggerFactory;
import org.apache.flink.shaded.akka.org.jboss.netty.util.ExternalResourceReleasable;
import org.apache.flink.shaded.akka.org.jboss.netty.util.internal.ExecutorUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNioWorkerPool<E extends AbstractNioWorker>
implements WorkerPool<E>,
ExternalResourceReleasable {
    private static final int INITIALIZATION_TIMEOUT = 10;
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractNioWorkerPool.class);
    private final AbstractNioWorker[] workers;
    private final AtomicInteger workerIndex = new AtomicInteger();
    private final Executor workerExecutor;
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    AbstractNioWorkerPool(Executor workerExecutor, int workerCount) {
        this(workerExecutor, workerCount, true);
    }

    AbstractNioWorkerPool(Executor workerExecutor, int workerCount, boolean autoInit) {
        if (workerExecutor == null) {
            throw new NullPointerException("workerExecutor");
        }
        if (workerCount <= 0) {
            throw new IllegalArgumentException("workerCount (" + workerCount + ") " + "must be a positive integer.");
        }
        this.workers = new AbstractNioWorker[workerCount];
        this.workerExecutor = workerExecutor;
        if (autoInit) {
            this.init();
        }
    }

    protected void init() {
        if (!this.initialized.compareAndSet(false, true)) {
            throw new IllegalStateException("initialized already");
        }
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i] = this.newWorker(this.workerExecutor);
        }
        this.waitForWorkerThreads();
    }

    private void waitForWorkerThreads() {
        long deadline = System.nanoTime() + TimeUnit.SECONDS.toNanos(10L);
        boolean warn = false;
        for (AbstractNioWorker worker : this.workers) {
            long waitTime = deadline - System.nanoTime();
            try {
                if (waitTime <= 0L) {
                    if (worker.thread != null) continue;
                    warn = true;
                    break;
                }
                if (worker.startupLatch.await(waitTime, TimeUnit.NANOSECONDS)) continue;
                warn = true;
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
            break;
        }
        if (warn) {
            logger.warn("Failed to get all worker threads ready within 10 second(s). Make sure to specify the executor which has more threads than the requested workerCount. If unsure, use Executors.newCachedThreadPool().");
        }
    }

    protected abstract E newWorker(Executor var1);

    @Override
    public E nextWorker() {
        return (E)this.workers[Math.abs(this.workerIndex.getAndIncrement() % this.workers.length)];
    }

    @Override
    public void rebuildSelectors() {
        for (AbstractNioWorker worker : this.workers) {
            worker.rebuildSelector();
        }
    }

    @Override
    public void releaseExternalResources() {
        this.shutdown();
        ExecutorUtil.shutdownNow(this.workerExecutor);
    }

    @Override
    public void shutdown() {
        for (AbstractNioWorker worker : this.workers) {
            worker.shutdown();
        }
    }
}

