/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.util.List;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.StateSnapshotTransformer;
import org.apache.flink.runtime.state.heap.AbstractStateTableSnapshot;
import org.apache.flink.runtime.state.heap.CopyOnWriteStateMapSnapshot;
import org.apache.flink.runtime.state.heap.CopyOnWriteStateTable;
import org.apache.flink.runtime.state.heap.StateMap;
import org.apache.flink.runtime.state.heap.StateMapSnapshot;

@Internal
public class CopyOnWriteStateTableSnapshot<K, N, S>
extends AbstractStateTableSnapshot<K, N, S> {
    private final int keyGroupOffset;
    @Nonnull
    private final List<CopyOnWriteStateMapSnapshot<K, N, S>> stateMapSnapshots;

    CopyOnWriteStateTableSnapshot(CopyOnWriteStateTable<K, N, S> owningStateTable, TypeSerializer<K> localKeySerializer, TypeSerializer<N> localNamespaceSerializer, TypeSerializer<S> localStateSerializer, StateSnapshotTransformer<S> stateSnapshotTransformer) {
        super(owningStateTable, localKeySerializer, localNamespaceSerializer, localStateSerializer, stateSnapshotTransformer);
        this.keyGroupOffset = owningStateTable.getKeyGroupOffset();
        this.stateMapSnapshots = owningStateTable.getStateMapSnapshotList();
    }

    @Override
    protected StateMapSnapshot<K, N, S, ? extends StateMap<K, N, S>> getStateMapSnapshotForKeyGroup(int keyGroup) {
        int indexOffset = keyGroup - this.keyGroupOffset;
        CopyOnWriteStateMapSnapshot<K, N, S> stateMapSnapshot = null;
        if (indexOffset >= 0 && indexOffset < this.stateMapSnapshots.size()) {
            stateMapSnapshot = this.stateMapSnapshots.get(indexOffset);
        }
        return stateMapSnapshot;
    }
}

