/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.runtime.state.StateBackendFactory;
import org.apache.flink.runtime.state.filesystem.FsStateBackend;

@PublicEvolving
public class FsStateBackendFactory
implements StateBackendFactory<FsStateBackend> {
    @Override
    public FsStateBackend createFromConfig(Configuration config, ClassLoader classLoader) throws IllegalConfigurationException {
        String checkpointDir = config.getString(CheckpointingOptions.CHECKPOINTS_DIRECTORY);
        if (checkpointDir == null) {
            throw new IllegalConfigurationException("Cannot create the file system state backend: The configuration does not specify the checkpoint directory '" + CheckpointingOptions.CHECKPOINTS_DIRECTORY.key() + '\'');
        }
        try {
            return new FsStateBackend(checkpointDir).configure(config, classLoader);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalConfigurationException("Invalid configuration for the state backend", (Throwable)e);
        }
    }
}

