/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@FunctionalInterface
@NotThreadSafe
public interface StateSnapshotTransformer<T> {
    @Nullable
    public T filterOrTransform(@Nullable T var1);

    public static interface StateSnapshotTransformFactory<T> {
        public static final StateSnapshotTransformFactory<?> NO_TRANSFORM = StateSnapshotTransformFactory.createNoTransform();

        public static <T> StateSnapshotTransformFactory<T> noTransform() {
            return NO_TRANSFORM;
        }

        public static <T> StateSnapshotTransformFactory<T> createNoTransform() {
            return new StateSnapshotTransformFactory<T>(){

                @Override
                public Optional<StateSnapshotTransformer<T>> createForDeserializedState() {
                    return Optional.empty();
                }

                @Override
                public Optional<StateSnapshotTransformer<byte[]>> createForSerializedState() {
                    return Optional.empty();
                }
            };
        }

        public Optional<StateSnapshotTransformer<T>> createForDeserializedState();

        public Optional<StateSnapshotTransformer<byte[]>> createForSerializedState();
    }

    public static interface CollectionStateSnapshotTransformer<T>
    extends StateSnapshotTransformer<T> {
        default public TransformStrategy getFilterStrategy() {
            return TransformStrategy.TRANSFORM_ALL;
        }

        public static enum TransformStrategy {
            TRANSFORM_ALL,
            STOP_ON_FIRST_INCLUDED;

        }
    }
}

