/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy.backpressure;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.util.Preconditions;

public class StackTraceSample {
    private final int sampleId;
    private final long startTime;
    private final long endTime;
    private final Map<ExecutionAttemptID, List<StackTraceElement[]>> stackTracesByTask;

    public StackTraceSample(int sampleId, long startTime, long endTime, Map<ExecutionAttemptID, List<StackTraceElement[]>> stackTracesByTask) {
        Preconditions.checkArgument((sampleId >= 0 ? 1 : 0) != 0, (Object)"Negative sample ID");
        Preconditions.checkArgument((startTime >= 0L ? 1 : 0) != 0, (Object)"Negative start time");
        Preconditions.checkArgument((endTime >= startTime ? 1 : 0) != 0, (Object)"End time before start time");
        this.sampleId = sampleId;
        this.startTime = startTime;
        this.endTime = endTime;
        this.stackTracesByTask = Collections.unmodifiableMap(stackTracesByTask);
    }

    public int getSampleId() {
        return this.sampleId;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public Map<ExecutionAttemptID, List<StackTraceElement[]>> getStackTraces() {
        return this.stackTracesByTask;
    }

    public String toString() {
        return "StackTraceSample{sampleId=" + this.sampleId + ", startTime=" + this.startTime + ", endTime=" + this.endTime + '}';
    }
}

