/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.clusterframework.ContaineredTaskManagerParameters;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceIDRetrievable;
import org.apache.flink.runtime.entrypoint.ClusterInformation;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.groups.JobManagerMetricGroup;
import org.apache.flink.runtime.resourcemanager.ResourceManager;
import org.apache.flink.runtime.resourcemanager.ResourceManagerFactory;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.taskexecutor.TaskManagerServices;

public abstract class ActiveResourceManagerFactory<T extends ResourceIDRetrievable>
implements ResourceManagerFactory<T> {
    @Override
    public ResourceManager<T> createResourceManager(Configuration configuration, ResourceID resourceId, RpcService rpcService, HighAvailabilityServices highAvailabilityServices, HeartbeatServices heartbeatServices, MetricRegistry metricRegistry, FatalErrorHandler fatalErrorHandler, ClusterInformation clusterInformation, @Nullable String webInterfaceUrl, JobManagerMetricGroup jobManagerMetricGroup) throws Exception {
        return this.createActiveResourceManager(ActiveResourceManagerFactory.createActiveResourceManagerConfiguration(configuration), resourceId, rpcService, highAvailabilityServices, heartbeatServices, metricRegistry, fatalErrorHandler, clusterInformation, webInterfaceUrl, jobManagerMetricGroup);
    }

    public static Configuration createActiveResourceManagerConfiguration(Configuration originalConfiguration) {
        int taskManagerMemoryMB = ConfigurationUtils.getTaskManagerHeapMemory((Configuration)originalConfiguration).getMebiBytes();
        long cutoffMB = ContaineredTaskManagerParameters.calculateCutoffMB(originalConfiguration, taskManagerMemoryMB);
        long processMemoryBytes = (long)taskManagerMemoryMB - cutoffMB << 20;
        long managedMemoryBytes = TaskManagerServices.getManagedMemoryFromProcessMemory(originalConfiguration, processMemoryBytes);
        Configuration resourceManagerConfig = new Configuration(originalConfiguration);
        resourceManagerConfig.setString(TaskManagerOptions.MANAGED_MEMORY_SIZE, managedMemoryBytes + "b");
        return resourceManagerConfig;
    }

    protected abstract ResourceManager<T> createActiveResourceManager(Configuration var1, ResourceID var2, RpcService var3, HighAvailabilityServices var4, HeartbeatServices var5, MetricRegistry var6, FatalErrorHandler var7, ClusterInformation var8, @Nullable String var9, JobManagerMetricGroup var10) throws Exception;
}

