/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import javax.annotation.Nonnull;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobmaster.slotpool.LocationPreferenceSlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.PreviousAllocationSlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.Scheduler;
import org.apache.flink.runtime.jobmaster.slotpool.SchedulerFactory;
import org.apache.flink.runtime.jobmaster.slotpool.SchedulerImpl;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPool;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;

public class DefaultSchedulerFactory
implements SchedulerFactory {
    @Nonnull
    private final SlotSelectionStrategy slotSelectionStrategy;

    public DefaultSchedulerFactory(@Nonnull SlotSelectionStrategy slotSelectionStrategy) {
        this.slotSelectionStrategy = slotSelectionStrategy;
    }

    @Override
    @Nonnull
    public Scheduler createScheduler(@Nonnull SlotPool slotPool) {
        return new SchedulerImpl(this.slotSelectionStrategy, slotPool);
    }

    @Nonnull
    private static SlotSelectionStrategy selectSlotSelectionStrategy(@Nonnull Configuration configuration) {
        if (configuration.getBoolean(CheckpointingOptions.LOCAL_RECOVERY)) {
            return PreviousAllocationSlotSelectionStrategy.INSTANCE;
        }
        return LocationPreferenceSlotSelectionStrategy.INSTANCE;
    }

    public static DefaultSchedulerFactory fromConfiguration(@Nonnull Configuration configuration) {
        return new DefaultSchedulerFactory(DefaultSchedulerFactory.selectSlotSelectionStrategy(configuration));
    }
}

