/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph.tasks;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.runtime.checkpoint.MasterTriggerRestoreHook;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.CheckpointCoordinatorConfiguration;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;

public class JobCheckpointingSettings
implements Serializable {
    private static final long serialVersionUID = -2593319571078198180L;
    private final List<JobVertexID> verticesToTrigger;
    private final List<JobVertexID> verticesToAcknowledge;
    private final List<JobVertexID> verticesToConfirm;
    private final CheckpointCoordinatorConfiguration checkpointCoordinatorConfiguration;
    @Nullable
    private final SerializedValue<StateBackend> defaultStateBackend;
    @Nullable
    private final SerializedValue<MasterTriggerRestoreHook.Factory[]> masterHooks;

    public JobCheckpointingSettings(List<JobVertexID> verticesToTrigger, List<JobVertexID> verticesToAcknowledge, List<JobVertexID> verticesToConfirm, CheckpointCoordinatorConfiguration checkpointCoordinatorConfiguration, @Nullable SerializedValue<StateBackend> defaultStateBackend) {
        this(verticesToTrigger, verticesToAcknowledge, verticesToConfirm, checkpointCoordinatorConfiguration, defaultStateBackend, null);
    }

    public JobCheckpointingSettings(List<JobVertexID> verticesToTrigger, List<JobVertexID> verticesToAcknowledge, List<JobVertexID> verticesToConfirm, CheckpointCoordinatorConfiguration checkpointCoordinatorConfiguration, @Nullable SerializedValue<StateBackend> defaultStateBackend, @Nullable SerializedValue<MasterTriggerRestoreHook.Factory[]> masterHooks) {
        this.verticesToTrigger = Objects.requireNonNull(verticesToTrigger);
        this.verticesToAcknowledge = Objects.requireNonNull(verticesToAcknowledge);
        this.verticesToConfirm = Objects.requireNonNull(verticesToConfirm);
        this.checkpointCoordinatorConfiguration = (CheckpointCoordinatorConfiguration)Preconditions.checkNotNull((Object)checkpointCoordinatorConfiguration);
        this.defaultStateBackend = defaultStateBackend;
        this.masterHooks = masterHooks;
    }

    public List<JobVertexID> getVerticesToTrigger() {
        return this.verticesToTrigger;
    }

    public List<JobVertexID> getVerticesToAcknowledge() {
        return this.verticesToAcknowledge;
    }

    public List<JobVertexID> getVerticesToConfirm() {
        return this.verticesToConfirm;
    }

    public CheckpointCoordinatorConfiguration getCheckpointCoordinatorConfiguration() {
        return this.checkpointCoordinatorConfiguration;
    }

    @Nullable
    public SerializedValue<StateBackend> getDefaultStateBackend() {
        return this.defaultStateBackend;
    }

    @Nullable
    public SerializedValue<MasterTriggerRestoreHook.Factory[]> getMasterHooks() {
        return this.masterHooks;
    }

    public String toString() {
        return String.format("SnapshotSettings: config=%s, trigger=%s, ack=%s, commit=%s", this.checkpointCoordinatorConfiguration, this.verticesToTrigger, this.verticesToAcknowledge, this.verticesToConfirm);
    }
}

