/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover.flip1.partitionrelease;

import java.util.HashSet;
import java.util.Set;
import org.apache.flink.runtime.executiongraph.failover.flip1.partitionrelease.PipelinedRegion;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.util.Preconditions;

class PipelinedRegionExecutionView {
    private final PipelinedRegion pipelinedRegion;
    private final Set<ExecutionVertexID> unfinishedVertices;

    PipelinedRegionExecutionView(PipelinedRegion pipelinedRegion) {
        this.pipelinedRegion = (PipelinedRegion)Preconditions.checkNotNull((Object)pipelinedRegion);
        this.unfinishedVertices = new HashSet<ExecutionVertexID>(pipelinedRegion.getExecutionVertexIds());
    }

    public boolean isFinished() {
        return this.unfinishedVertices.isEmpty();
    }

    public void vertexFinished(ExecutionVertexID executionVertexId) {
        Preconditions.checkArgument((boolean)this.pipelinedRegion.contains(executionVertexId));
        this.unfinishedVertices.remove(executionVertexId);
    }

    public void vertexUnfinished(ExecutionVertexID executionVertexId) {
        Preconditions.checkArgument((boolean)this.pipelinedRegion.contains(executionVertexId));
        this.unfinishedVertices.add(executionVertexId);
    }

    public PipelinedRegion getPipelinedRegion() {
        return this.pipelinedRegion;
    }
}

