/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.instance.SlotSharingGroupId;
import org.apache.flink.runtime.jobgraph.ScheduleMode;
import org.apache.flink.runtime.jobmanager.scheduler.ScheduledUnit;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.SlotProvider;
import org.apache.flink.util.Preconditions;

abstract class SlotProviderStrategy {
    protected final SlotProvider slotProvider;
    protected final boolean allowQueuedScheduling;

    SlotProviderStrategy(SlotProvider slotProvider, boolean allowQueuedScheduling) {
        this.slotProvider = (SlotProvider)Preconditions.checkNotNull((Object)slotProvider);
        this.allowQueuedScheduling = allowQueuedScheduling;
    }

    boolean isQueuedSchedulingAllowed() {
        return this.allowQueuedScheduling;
    }

    abstract CompletableFuture<LogicalSlot> allocateSlot(SlotRequestId var1, ScheduledUnit var2, SlotProfile var3);

    void cancelSlotRequest(SlotRequestId slotRequestId, @Nullable SlotSharingGroupId slotSharingGroupId, Throwable cause) {
        this.slotProvider.cancelSlotRequest(slotRequestId, slotSharingGroupId, cause);
    }

    static SlotProviderStrategy from(ScheduleMode scheduleMode, SlotProvider slotProvider, Time allocationTimeout, boolean allowQueuedScheduling) {
        switch (scheduleMode) {
            case LAZY_FROM_SOURCES_WITH_BATCH_SLOT_REQUEST: {
                return new BatchSlotProviderStrategy(slotProvider, allowQueuedScheduling);
            }
            case LAZY_FROM_SOURCES: 
            case EAGER: {
                return new NormalSlotProviderStrategy(slotProvider, allocationTimeout, allowQueuedScheduling);
            }
        }
        throw new IllegalArgumentException(String.format("Unknown scheduling mode: %s", new Object[]{scheduleMode}));
    }

    SlotProvider asSlotProvider() {
        return this.slotProvider;
    }

    static class NormalSlotProviderStrategy
    extends SlotProviderStrategy {
        private final Time allocationTimeout;

        NormalSlotProviderStrategy(SlotProvider slotProvider, Time allocationTimeout, boolean allowQueuedScheduling) {
            super(slotProvider, allowQueuedScheduling);
            this.allocationTimeout = (Time)Preconditions.checkNotNull((Object)allocationTimeout);
        }

        @Override
        public CompletableFuture<LogicalSlot> allocateSlot(SlotRequestId slotRequestId, ScheduledUnit scheduledUnit, SlotProfile slotProfile) {
            return this.slotProvider.allocateSlot(slotRequestId, scheduledUnit, slotProfile, this.allowQueuedScheduling, this.allocationTimeout);
        }
    }

    static class BatchSlotProviderStrategy
    extends SlotProviderStrategy {
        BatchSlotProviderStrategy(SlotProvider slotProvider, boolean allowQueuedScheduling) {
            super(slotProvider, allowQueuedScheduling);
        }

        @Override
        public CompletableFuture<LogicalSlot> allocateSlot(SlotRequestId slotRequestId, ScheduledUnit scheduledUnit, SlotProfile slotProfile) {
            return this.slotProvider.allocateBatchSlot(slotRequestId, scheduledUnit, slotProfile, this.allowQueuedScheduling);
        }
    }
}

