/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.dispatcher.ArchivedExecutionGraphStore;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.messages.webmonitor.JobDetails;
import org.apache.flink.runtime.messages.webmonitor.JobsOverview;
import org.apache.flink.runtime.webmonitor.WebMonitorUtils;

public class MemoryArchivedExecutionGraphStore
implements ArchivedExecutionGraphStore {
    private final Map<JobID, ArchivedExecutionGraph> serializableExecutionGraphs = new HashMap<JobID, ArchivedExecutionGraph>(4);

    @Override
    public int size() {
        return this.serializableExecutionGraphs.size();
    }

    @Override
    @Nullable
    public ArchivedExecutionGraph get(JobID jobId) {
        return this.serializableExecutionGraphs.get(jobId);
    }

    @Override
    public void put(ArchivedExecutionGraph serializableExecutionGraph) throws IOException {
        this.serializableExecutionGraphs.put(serializableExecutionGraph.getJobID(), serializableExecutionGraph);
    }

    @Override
    public JobsOverview getStoredJobsOverview() {
        Collection allJobStatus = this.serializableExecutionGraphs.values().stream().map(ArchivedExecutionGraph::getState).collect(Collectors.toList());
        return JobsOverview.create(allJobStatus);
    }

    @Override
    public Collection<JobDetails> getAvailableJobDetails() {
        return this.serializableExecutionGraphs.values().stream().map(WebMonitorUtils::createDetailsForJob).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public JobDetails getAvailableJobDetails(JobID jobId) {
        ArchivedExecutionGraph archivedExecutionGraph = this.serializableExecutionGraphs.get(jobId);
        if (archivedExecutionGraph != null) {
            return WebMonitorUtils.createDetailsForJob(archivedExecutionGraph);
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.serializableExecutionGraphs.clear();
    }
}

