/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobWriter;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategyFactory;
import org.apache.flink.runtime.io.network.partition.JobMasterPartitionTracker;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmaster.slotpool.SlotProvider;
import org.apache.flink.runtime.metrics.groups.JobManagerJobMetricGroup;
import org.apache.flink.runtime.rest.handler.legacy.backpressure.BackPressureStatsTracker;
import org.apache.flink.runtime.scheduler.ExecutionVertexVersioner;
import org.apache.flink.runtime.scheduler.SchedulerBase;
import org.apache.flink.runtime.shuffle.ShuffleMaster;
import org.slf4j.Logger;

public class LegacyScheduler
extends SchedulerBase {
    public LegacyScheduler(Logger log, JobGraph jobGraph, BackPressureStatsTracker backPressureStatsTracker, Executor ioExecutor, Configuration jobMasterConfiguration, SlotProvider slotProvider, ScheduledExecutorService futureExecutor, ClassLoader userCodeLoader, CheckpointRecoveryFactory checkpointRecoveryFactory, Time rpcTimeout, RestartStrategyFactory restartStrategyFactory, BlobWriter blobWriter, JobManagerJobMetricGroup jobManagerJobMetricGroup, Time slotRequestTimeout, ShuffleMaster<?> shuffleMaster, JobMasterPartitionTracker partitionTracker) throws Exception {
        super(log, jobGraph, backPressureStatsTracker, ioExecutor, jobMasterConfiguration, slotProvider, futureExecutor, userCodeLoader, checkpointRecoveryFactory, rpcTimeout, restartStrategyFactory, blobWriter, jobManagerJobMetricGroup, slotRequestTimeout, shuffleMaster, partitionTracker, new ExecutionVertexVersioner(), true);
    }

    @Override
    protected long getNumberOfRestarts() {
        return this.getExecutionGraph().getNumberOfRestarts();
    }

    @Override
    protected void startSchedulingInternal() {
        ExecutionGraph executionGraph = this.getExecutionGraph();
        try {
            executionGraph.scheduleForExecution();
        }
        catch (Throwable t) {
            executionGraph.failGlobal(t);
        }
    }

    @Override
    public void handleGlobalFailure(Throwable cause) {
        throw new IllegalStateException("Unexpected handleGlobalFailure(...) call");
    }
}

