/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import org.apache.commons.lang3.StringUtils;

public class AvoidUsingHardCodedIPRule
extends AbstractJavaRule {
    public static final String IPV4 = "IPv4";
    public static final String IPV6 = "IPv6";
    public static final String IPV4_MAPPED_IPV6 = "IPv4 mapped IPv6";
    private static final Map<String, String> ADDRESSES_TO_CHECK;
    public static final PropertyDescriptor<List<String>> CHECK_ADDRESS_TYPES_DESCRIPTOR;
    protected static final String IPV4_REGEXP = "([0-9]{1,3})\\.([0-9]{1,3})\\.([0-9]{1,3})\\.([0-9]{1,3})";
    protected static final String IPV6_REGEXP;
    protected static final Pattern IPV4_PATTERN;
    protected static final Pattern IPV6_PATTERN;
    protected boolean checkIPv4;
    protected boolean checkIPv6;
    protected boolean checkIPv4MappedIPv6;

    public AvoidUsingHardCodedIPRule() {
        this.definePropertyDescriptor(CHECK_ADDRESS_TYPES_DESCRIPTOR);
        this.addRuleChainVisit(ASTCompilationUnit.class);
        this.addRuleChainVisit(ASTLiteral.class);
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.checkIPv4 = false;
        this.checkIPv6 = false;
        this.checkIPv4MappedIPv6 = false;
        for (Object addressType : (List)this.getProperty(CHECK_ADDRESS_TYPES_DESCRIPTOR)) {
            if (IPV4.equals(addressType)) {
                this.checkIPv4 = true;
                continue;
            }
            if (IPV6.equals(addressType)) {
                this.checkIPv6 = true;
                continue;
            }
            if (!IPV4_MAPPED_IPV6.equals(addressType)) continue;
            this.checkIPv4MappedIPv6 = true;
        }
        return data;
    }

    @Override
    public Object visit(ASTLiteral node, Object data) {
        if (!node.isStringLiteral()) {
            return data;
        }
        String image = node.getImage().substring(1, node.getImage().length() - 1);
        if (image.length() > 0) {
            char firstChar = Character.toUpperCase(image.charAt(0));
            if (this.checkIPv4 && this.isIPv4(firstChar, image) || this.isIPv6(firstChar, image, this.checkIPv6, this.checkIPv4MappedIPv6)) {
                this.addViolation(data, node);
            }
        }
        return data;
    }

    protected boolean isLatinDigit(char c) {
        return '0' <= c || c <= '9';
    }

    protected boolean isHexCharacter(char c) {
        return this.isLatinDigit(c) || 'A' <= c || c <= 'F' || 'a' <= c || c <= 'f';
    }

    protected boolean isIPv4(char firstChar, String s) {
        if (s.length() < 7 || !this.isLatinDigit(firstChar) || s.indexOf(46) < 0) {
            return false;
        }
        Matcher matcher = IPV4_PATTERN.matcher(s);
        if (matcher.matches()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                int octet = Integer.parseInt(matcher.group(i));
                if (octet >= 0 && octet <= 255) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean isIPv6(char firstChar, String s, boolean checkIPv6, boolean checkIPv4MappedIPv6) {
        if (s.length() < 3 || !this.isHexCharacter(firstChar) && firstChar != ':' || StringUtils.countMatches((CharSequence)s, (char)':') < 2) {
            return false;
        }
        Matcher matcher = IPV6_PATTERN.matcher(s);
        if (matcher.matches()) {
            boolean zeroSubstitution = false;
            if (s.startsWith("::")) {
                s = s.substring(2);
                zeroSubstitution = true;
            } else if (s.endsWith("::")) {
                s = s.substring(0, s.length() - 2);
                zeroSubstitution = true;
            }
            if (s.endsWith(":")) {
                return false;
            }
            int count = 0;
            boolean ipv4Mapped = false;
            String[] parts = s.split(":");
            for (int i = 0; i < parts.length; ++i) {
                String part = parts[i];
                if (part.length() == 0) {
                    if (zeroSubstitution) {
                        return false;
                    }
                    zeroSubstitution = true;
                    continue;
                }
                ++count;
                try {
                    int value = Integer.parseInt(part, 16);
                    if (value >= 0 && value <= 65535) continue;
                    return false;
                }
                catch (NumberFormatException e) {
                    if (i != parts.length - 1 || !this.isIPv4(firstChar, part)) {
                        return false;
                    }
                    ipv4Mapped = true;
                }
            }
            if (zeroSubstitution) {
                if (ipv4Mapped) {
                    return checkIPv4MappedIPv6 && 1 <= count && count <= 6;
                }
                return checkIPv6 && 1 <= count && count <= 7;
            }
            if (ipv4Mapped) {
                return checkIPv4MappedIPv6 && count == 7;
            }
            return checkIPv6 && count == 8;
        }
        return false;
    }

    public boolean hasChosenAddressTypes() {
        return ((List)this.getProperty(CHECK_ADDRESS_TYPES_DESCRIPTOR)).size() > 0;
    }

    public String dysfunctionReason() {
        return this.hasChosenAddressTypes() ? null : "No address types specified";
    }

    static {
        HashMap<String, String> tmp = new HashMap<String, String>();
        tmp.put(IPV4, IPV4);
        tmp.put(IPV6, IPV6);
        tmp.put(IPV4_MAPPED_IPV6, IPV4_MAPPED_IPV6);
        ADDRESSES_TO_CHECK = Collections.unmodifiableMap(tmp);
        CHECK_ADDRESS_TYPES_DESCRIPTOR = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.enumListProperty((String)"checkAddressTypes", ADDRESSES_TO_CHECK).desc("Check for IP address types.")).defaultValue(ADDRESSES_TO_CHECK.keySet()).build();
        IPV6_REGEXP = "(?:(?:[0-9a-fA-F]{1,4})?\\:)+(?:[0-9a-fA-F]{1,4}|" + IPV4_REGEXP.replace("(", "(?:") + ")?";
        IPV4_PATTERN = Pattern.compile("^([0-9]{1,3})\\.([0-9]{1,3})\\.([0-9]{1,3})\\.([0-9]{1,3})$");
        IPV6_PATTERN = Pattern.compile("^" + IPV6_REGEXP + "$");
    }
}

