/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotationTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.rule.properties.BooleanProperty;

public class FieldDeclarationsShouldBeAtStartOfClassRule
extends AbstractJavaRule {
    private BooleanProperty ignoreEnumDeclarations = new BooleanProperty("ignoreEnumDeclarations", "Ignore Enum Declarations that precede fields.", Boolean.valueOf(true), 1.0f);
    private BooleanProperty ignoreAnonymousClassDeclarations = new BooleanProperty("ignoreAnonymousClassDeclarations", "Ignore Field Declarations, that are initialized with anonymous class declarations", Boolean.valueOf(true), 2.0f);

    public FieldDeclarationsShouldBeAtStartOfClassRule() {
        this.definePropertyDescriptor((PropertyDescriptor)this.ignoreEnumDeclarations);
        this.definePropertyDescriptor((PropertyDescriptor)this.ignoreAnonymousClassDeclarations);
    }

    @Override
    public Object visit(ASTFieldDeclaration node, Object data) {
        Node parent = node.jjtGetParent().jjtGetParent();
        for (int i = 0; i < parent.jjtGetNumChildren(); ++i) {
            Node child = parent.jjtGetChild(i);
            if (child.jjtGetNumChildren() > 0) {
                child = !(child.jjtGetChild(0) instanceof ASTAnnotation) || child.jjtGetNumChildren() == 1 ? child.jjtGetChild(0) : child.jjtGetChild(1);
            }
            if (child.equals(node)) break;
            if (child instanceof ASTFieldDeclaration || node.hasDescendantOfType(ASTClassOrInterfaceBodyDeclaration.class) && ((Boolean)this.getProperty((PropertyDescriptor)this.ignoreAnonymousClassDeclarations)).booleanValue()) continue;
            if (child instanceof ASTClassOrInterfaceDeclaration || child instanceof ASTMethodDeclaration || child instanceof ASTConstructorDeclaration || child instanceof ASTAnnotationTypeDeclaration) {
                this.addViolation(data, node);
                break;
            }
            if (!(child instanceof ASTEnumDeclaration) || ((Boolean)this.getProperty((PropertyDescriptor)this.ignoreEnumDeclarations)).booleanValue()) continue;
            this.addViolation(data, node);
            break;
        }
        return data;
    }
}

