/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties.modules;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.sourceforge.pmd.properties.PropertyDescriptorField;
import org.apache.commons.lang3.StringUtils;

public abstract class PackagedPropertyModule<T> {
    private static final Pattern PACKAGE_NAME_PATTERN = Pattern.compile("(\\w+)(\\.\\w+)*");
    private final String[] legalPackageNames;

    public PackagedPropertyModule(String[] legalPackageNames, List<T> defaults) {
        this.checkValidPackages(legalPackageNames);
        this.checkValidDefaults(defaults, legalPackageNames);
        this.legalPackageNames = legalPackageNames;
    }

    private void checkValidPackages(String[] legalNamePrefixes) throws IllegalArgumentException {
        if (legalNamePrefixes == null) {
            return;
        }
        for (String name : legalNamePrefixes) {
            if (name == null) {
                throw new IllegalArgumentException("Null is not allowed in the legal package names:" + Arrays.toString(legalNamePrefixes));
            }
            if (PACKAGE_NAME_PATTERN.matcher(name).matches()) continue;
            throw new IllegalArgumentException("One name is not a package: '" + name + "'");
        }
    }

    private void checkValidDefaults(List<T> items, String[] legalNamePrefixes) {
        if (legalNamePrefixes == null) {
            return;
        }
        HashSet<String> nameSet = new HashSet<String>();
        for (T item : items) {
            if (item == null) continue;
            nameSet.add(this.packageNameOf(item));
        }
        HashSet notAllowed = new HashSet(nameSet);
        block1: for (String name : nameSet) {
            for (String prefix : legalNamePrefixes) {
                if (!name.startsWith(prefix)) continue;
                notAllowed.remove(name);
                continue block1;
            }
        }
        if (notAllowed.isEmpty()) {
            return;
        }
        throw new IllegalArgumentException("Invalid items: " + notAllowed);
    }

    protected abstract String packageNameOf(T var1);

    public String valueErrorFor(T value) {
        if (this.legalPackageNames == null) {
            return null;
        }
        String name = this.packageNameOf(value);
        for (int i = 0; i < this.legalPackageNames.length; ++i) {
            if (!name.startsWith(this.legalPackageNames[i])) continue;
            return null;
        }
        return "Disallowed " + this.itemTypeName() + ": " + name;
    }

    protected abstract String itemTypeName();

    public String[] legalPackageNames() {
        return Arrays.copyOf(this.legalPackageNames, this.legalPackageNames.length);
    }

    public void addAttributesTo(Map<PropertyDescriptorField, String> attributes) {
        attributes.put(PropertyDescriptorField.LEGAL_PACKAGES, this.delimitedPackageNames());
    }

    private String delimitedPackageNames() {
        if (this.legalPackageNames == null || this.legalPackageNames.length == 0) {
            return "";
        }
        if (this.legalPackageNames.length == 1) {
            return this.legalPackageNames[0];
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.legalPackageNames[0]);
        for (int i = 1; i < this.legalPackageNames.length; ++i) {
            sb.append(' ').append(this.legalPackageNames[i]);
        }
        return sb.toString();
    }

    public String[] packageNamesIn(Map<PropertyDescriptorField, String> params) {
        return StringUtils.split((String)params.get((Object)PropertyDescriptorField.LEGAL_PACKAGES), (char)' ');
    }
}

