/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.properties.MultiValuePropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertySource;
import net.sourceforge.pmd.util.CollectionUtil;

public abstract class AbstractPropertySource
implements PropertySource {
    @Deprecated
    protected List<PropertyDescriptor<?>> propertyDescriptors = new ArrayList();
    @Deprecated
    protected Map<PropertyDescriptor<?>, Object> propertyValuesByDescriptor = new HashMap();

    @Deprecated
    protected List<PropertyDescriptor<?>> copyPropertyDescriptors() {
        return new ArrayList(this.propertyDescriptors);
    }

    @Deprecated
    protected Map<PropertyDescriptor<?>, Object> copyPropertyValues() {
        return new HashMap(this.propertyValuesByDescriptor);
    }

    @Override
    @Deprecated
    public Set<PropertyDescriptor<?>> ignoredProperties() {
        return Collections.emptySet();
    }

    @Override
    public void definePropertyDescriptor(PropertyDescriptor<?> propertyDescriptor) {
        if (this.getPropertyDescriptor(propertyDescriptor.name()) != null) {
            throw new IllegalArgumentException("There is already a PropertyDescriptor with name '" + propertyDescriptor.name() + "' defined on " + this.getPropertySourceType() + " " + this.getName() + ".");
        }
        this.propertyDescriptors.add(propertyDescriptor);
        Collections.sort(this.propertyDescriptors);
    }

    protected abstract String getPropertySourceType();

    @Override
    public PropertyDescriptor<?> getPropertyDescriptor(String name) {
        for (PropertyDescriptor<?> propertyDescriptor : this.propertyDescriptors) {
            if (!name.equals(propertyDescriptor.name())) continue;
            return propertyDescriptor;
        }
        return null;
    }

    @Override
    public boolean hasDescriptor(PropertyDescriptor<?> descriptor) {
        return this.propertyDescriptors.contains(descriptor);
    }

    @Override
    public final List<PropertyDescriptor<?>> getOverriddenPropertyDescriptors() {
        return new ArrayList(this.propertyValuesByDescriptor.keySet());
    }

    @Override
    public List<PropertyDescriptor<?>> getPropertyDescriptors() {
        return Collections.unmodifiableList(this.propertyDescriptors);
    }

    @Override
    public <T> T getProperty(PropertyDescriptor<T> propertyDescriptor) {
        this.checkValidPropertyDescriptor(propertyDescriptor);
        Object result = propertyDescriptor.defaultValue();
        if (this.propertyValuesByDescriptor.containsKey(propertyDescriptor)) {
            Object value = this.propertyValuesByDescriptor.get(propertyDescriptor);
            result = value;
        }
        return result;
    }

    @Override
    public boolean isPropertyOverridden(PropertyDescriptor<?> propertyDescriptor) {
        return this.propertyValuesByDescriptor.containsKey(propertyDescriptor);
    }

    @Override
    public <T> void setProperty(PropertyDescriptor<T> propertyDescriptor, T value) {
        this.checkValidPropertyDescriptor(propertyDescriptor);
        if (value instanceof List) {
            this.propertyValuesByDescriptor.put(propertyDescriptor, Collections.unmodifiableList((List)value));
        } else {
            this.propertyValuesByDescriptor.put(propertyDescriptor, value);
        }
    }

    @Override
    public <V> void setProperty(MultiValuePropertyDescriptor<V> propertyDescriptor, V ... values) {
        this.checkValidPropertyDescriptor(propertyDescriptor);
        this.propertyValuesByDescriptor.put(propertyDescriptor, Collections.unmodifiableList(Arrays.asList(values)));
    }

    private void checkValidPropertyDescriptor(PropertyDescriptor<?> propertyDescriptor) {
        if (!this.hasDescriptor(propertyDescriptor)) {
            throw new IllegalArgumentException("Property descriptor not defined for " + this.getPropertySourceType() + " " + this.getName() + ": " + propertyDescriptor);
        }
    }

    @Override
    public final Map<PropertyDescriptor<?>, Object> getOverriddenPropertiesByPropertyDescriptor() {
        return new HashMap(this.propertyValuesByDescriptor);
    }

    @Override
    public Map<PropertyDescriptor<?>, Object> getPropertiesByPropertyDescriptor() {
        if (this.propertyDescriptors.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap propertiesByPropertyDescriptor = new HashMap(this.propertyDescriptors.size());
        propertiesByPropertyDescriptor.putAll(this.propertyValuesByDescriptor);
        for (PropertyDescriptor<?> propertyDescriptor : this.propertyDescriptors) {
            if (propertiesByPropertyDescriptor.containsKey(propertyDescriptor)) continue;
            propertiesByPropertyDescriptor.put(propertyDescriptor, propertyDescriptor.defaultValue());
        }
        return Collections.unmodifiableMap(propertiesByPropertyDescriptor);
    }

    @Override
    @Deprecated
    public boolean usesDefaultValues() {
        Map<PropertyDescriptor<?>, Object> valuesByProperty = this.getPropertiesByPropertyDescriptor();
        if (valuesByProperty.isEmpty()) {
            return true;
        }
        for (Map.Entry<PropertyDescriptor<?>, Object> entry : valuesByProperty.entrySet()) {
            if (CollectionUtil.areEqual(entry.getKey().defaultValue(), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public void useDefaultValueFor(PropertyDescriptor<?> desc) {
        this.propertyValuesByDescriptor.remove(desc);
    }

    @Override
    public String dysfunctionReason() {
        return null;
    }
}

