/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.metrics;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.lang.metrics.MetricOption;

public class MetricOptions {
    private static final Map<MetricOptions, MetricOptions> POOL = new HashMap<MetricOptions, MetricOptions>();
    private static final MetricOptions EMPTY_OPTIONS = new MetricOptions();
    private Set<MetricOption> options;

    private MetricOptions() {
        this.options = Collections.emptySet();
    }

    private MetricOptions(Set<? extends MetricOption> opts) {
        switch (opts.size()) {
            case 0: {
                this.options = Collections.emptySet();
                break;
            }
            case 1: {
                this.options = Collections.singleton(opts.iterator().next());
                break;
            }
            default: {
                this.options = Collections.unmodifiableSet(opts);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricOptions other = (MetricOptions)o;
        return this.options.equals(other.options);
    }

    public int hashCode() {
        return this.options.hashCode();
    }

    public Set<MetricOption> getOptions() {
        return this.options;
    }

    public String toString() {
        return "MetricOptions{options=" + this.options + '}';
    }

    public static MetricOptions emptyOptions() {
        return EMPTY_OPTIONS;
    }

    public static MetricOptions ofOptions(Collection<? extends MetricOption> options) {
        MetricOptionsBuilder builder = new MetricOptionsBuilder();
        builder.addAll(options);
        return builder.build();
    }

    public static MetricOptions ofOptions(MetricOption option, MetricOption ... options) {
        MetricOptionsBuilder builder = new MetricOptionsBuilder();
        builder.add(option);
        for (MetricOption opt : options) {
            builder.add(opt);
        }
        return builder.build();
    }

    static {
        POOL.put(EMPTY_OPTIONS, EMPTY_OPTIONS);
    }

    private static class MetricOptionsBuilder {
        private Set<MetricOption> opts = new HashSet<MetricOption>();

        private MetricOptionsBuilder() {
        }

        void add(MetricOption option) {
            if (option != null) {
                this.opts.add(option);
            }
        }

        void addAll(Collection<? extends MetricOption> options) {
            if (options != null) {
                this.opts.addAll(options);
                this.opts.remove(null);
            }
        }

        MetricOptions build() {
            if (this.opts.isEmpty()) {
                return MetricOptions.emptyOptions();
            }
            MetricOptions result = new MetricOptions(this.opts);
            if (!POOL.containsKey(result)) {
                POOL.put(result, result);
            }
            return (MetricOptions)POOL.get(result);
        }
    }
}

