/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast.xpath;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.xpath.Attribute;

public class AttributeAxisIterator
implements Iterator<Attribute> {
    private static final ConcurrentMap<Class<?>, MethodWrapper[]> METHOD_CACHE = new ConcurrentHashMap();
    private static final Set<Class<?>> CONSIDERED_RETURN_TYPES = new HashSet<Class>(Arrays.asList(Integer.TYPE, Boolean.TYPE, Double.TYPE, String.class, Long.TYPE, Character.TYPE, Float.TYPE));
    private static final Set<String> FILTERED_OUT_NAMES = new HashSet<String>(Arrays.asList("toString", "getClass", "getXPathNodeName", "getTypeNameNode", "hashCode", "getImportedNameNode", "getScope"));
    private Attribute currObj;
    private MethodWrapper[] methodWrappers;
    private int position;
    private Node node;

    public AttributeAxisIterator(Node contextNode) {
        this.node = contextNode;
        if (!METHOD_CACHE.containsKey(contextNode.getClass())) {
            Method[] preFilter = contextNode.getClass().getMethods();
            ArrayList<MethodWrapper> postFilter = new ArrayList<MethodWrapper>();
            for (Method element : preFilter) {
                if (!this.isAttributeAccessor(element)) continue;
                postFilter.add(new MethodWrapper(element));
            }
            METHOD_CACHE.putIfAbsent(contextNode.getClass(), postFilter.toArray(new MethodWrapper[0]));
        }
        this.methodWrappers = (MethodWrapper[])METHOD_CACHE.get(contextNode.getClass());
        this.position = 0;
        this.currObj = this.getNextAttribute();
    }

    protected boolean isAttributeAccessor(Method method) {
        String methodName = method.getName();
        return CONSIDERED_RETURN_TYPES.contains(method.getReturnType()) && method.getParameterTypes().length == 0 && !methodName.startsWith("jjt") && !FILTERED_OUT_NAMES.contains(methodName);
    }

    @Override
    public Attribute next() {
        if (!this.hasNext()) {
            throw new IndexOutOfBoundsException();
        }
        Attribute ret = this.currObj;
        this.currObj = this.getNextAttribute();
        return ret;
    }

    @Override
    public boolean hasNext() {
        return this.currObj != null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private Attribute getNextAttribute() {
        if (this.methodWrappers == null || this.position == this.methodWrappers.length) {
            return null;
        }
        MethodWrapper m = this.methodWrappers[this.position++];
        return new Attribute(this.node, m.name, m.method);
    }

    private static class MethodWrapper {
        public Method method;
        public String name;

        MethodWrapper(Method m) {
            this.method = m;
            this.name = this.truncateMethodName(m.getName());
        }

        private String truncateMethodName(String n) {
            if (n.startsWith("get")) {
                return n.substring("get".length());
            }
            if (n.startsWith("is")) {
                return n.substring("is".length());
            }
            if (n.startsWith("has")) {
                return n.substring("has".length());
            }
            if (n.startsWith("uses")) {
                return n.substring("uses".length());
            }
            return n;
        }
    }
}

