/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.document;

import net.sourceforge.pmd.document.RegionByLine;

public class RegionByLineImp
implements RegionByLine {
    private final int beginLine;
    private final int endLine;
    private final int beginColumn;
    private final int endColumn;

    public RegionByLineImp(int beginLine, int endLine, int beginColumn, int endColumn) {
        this.beginLine = RegionByLineImp.requireNonNegative(beginLine);
        this.endLine = RegionByLineImp.requireNonNegative(endLine);
        this.beginColumn = RegionByLineImp.requireNonNegative(beginColumn);
        this.endColumn = RegionByLineImp.requireNonNegative(endColumn);
        this.requireLinesCorrectlyOrdered();
    }

    private void requireLinesCorrectlyOrdered() {
        if (this.beginLine > this.endLine) {
            throw new IllegalArgumentException("endLine must be equal or greater than beginLine");
        }
    }

    private static int requireNonNegative(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("parameter must be non-negative");
        }
        return value;
    }

    @Override
    public int getBeginLine() {
        return this.beginLine;
    }

    @Override
    public int getEndLine() {
        return this.endLine;
    }

    @Override
    public int getBeginColumn() {
        return this.beginColumn;
    }

    @Override
    public int getEndColumn() {
        return this.endColumn;
    }

    public String toString() {
        return "RegionByLineImp{beginLine=" + this.beginLine + ", endLine=" + this.endLine + ", beginColumn=" + this.beginColumn + ", endColumn=" + this.endColumn + '}';
    }
}

