/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import net.sourceforge.pmd.RuleSetNotFoundException;

public class ResourceLoader {
    public static final int TIMEOUT;
    private final ClassLoader classLoader;

    public ResourceLoader() {
        this(ResourceLoader.class.getClassLoader());
    }

    public ResourceLoader(ClassLoader cl) {
        this.classLoader = Objects.requireNonNull(cl);
    }

    public InputStream loadResourceAsStream(String name) throws RuleSetNotFoundException {
        File file = new File(name);
        if (file.exists()) {
            try {
                return Files.newInputStream(file.toPath(), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(name).openConnection();
            connection.setConnectTimeout(TIMEOUT);
            connection.setReadTimeout(TIMEOUT);
            return connection.getInputStream();
        }
        catch (Exception e) {
            try {
                return this.loadClassPathResourceAsStream(name);
            }
            catch (IOException iOException) {
                throw new RuleSetNotFoundException("Can't find resource " + name + ". Make sure the resource is a valid file or URL or is on the CLASSPATH");
            }
        }
    }

    public InputStream loadClassPathResourceAsStream(String name) throws IOException {
        URL resource = this.classLoader.getResource(name);
        if (resource == null) {
            return null;
        }
        URLConnection connection = resource.openConnection();
        connection.setUseCaches(false);
        return connection.getInputStream();
    }

    public InputStream loadClassPathResourceAsStreamOrThrow(String name) throws RuleSetNotFoundException {
        InputStream is = null;
        try {
            is = this.loadClassPathResourceAsStream(name);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (is == null) {
            throw new RuleSetNotFoundException("Can't find resource " + name + ". Make sure the resource is on the CLASSPATH");
        }
        return is;
    }

    static {
        int timeoutProperty = 5000;
        try {
            timeoutProperty = Integer.parseInt(System.getProperty("net.sourceforge.pmd.http.timeout", "5000"));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        TIMEOUT = timeoutProperty;
    }
}

