/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.metrics;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.lang.ast.QualifiableNode;
import net.sourceforge.pmd.lang.metrics.MetricKey;
import net.sourceforge.pmd.lang.metrics.MetricMemoizer;
import net.sourceforge.pmd.lang.metrics.MetricOptions;
import net.sourceforge.pmd.lang.metrics.MetricsComputer;
import net.sourceforge.pmd.lang.metrics.ParameterizedMetricKey;
import net.sourceforge.pmd.lang.metrics.ProjectMemoizer;
import net.sourceforge.pmd.lang.metrics.ResultOption;

public abstract class AbstractMetricsComputer<T extends QualifiableNode, O extends QualifiableNode>
implements MetricsComputer<T, O> {
    @Override
    public double computeForType(MetricKey<T> key, T node, boolean force, MetricOptions options, MetricMemoizer<T> memoizer) {
        ParameterizedMetricKey<T> paramKey = ParameterizedMetricKey.getInstance(key, options);
        Double prev = memoizer.getMemo(paramKey);
        if (!force && prev != null) {
            return prev;
        }
        double val = key.getCalculator().computeFor(node, options);
        memoizer.memoize(paramKey, val);
        return val;
    }

    @Override
    public double computeForOperation(MetricKey<O> key, O node, boolean force, MetricOptions options, MetricMemoizer<O> memoizer) {
        ParameterizedMetricKey<O> paramKey = ParameterizedMetricKey.getInstance(key, options);
        Double prev = memoizer.getMemo(paramKey);
        if (!force && prev != null) {
            return prev;
        }
        double val = key.getCalculator().computeFor(node, options);
        memoizer.memoize(paramKey, val);
        return val;
    }

    @Override
    public double computeWithResultOption(MetricKey<O> key, T node, boolean force, MetricOptions options, ResultOption option, ProjectMemoizer<T, O> stats) {
        List<O> ops = this.findOperations(node);
        ArrayList<Double> values = new ArrayList<Double>();
        for (QualifiableNode op : ops) {
            MetricMemoizer<O> opStats;
            double val;
            if (!key.supports(op) || (val = this.computeForOperation(key, op, force, options, opStats = stats.getOperationMemoizer(op.getQualifiedName()))) == Double.NaN) continue;
            values.add(val);
        }
        switch (option) {
            case SUM: {
                return AbstractMetricsComputer.sum(values);
            }
            case HIGHEST: {
                return AbstractMetricsComputer.highest(values);
            }
            case AVERAGE: {
                return AbstractMetricsComputer.average(values);
            }
        }
        return Double.NaN;
    }

    protected abstract List<O> findOperations(T var1);

    private static double sum(List<Double> values) {
        double sum = 0.0;
        for (double val : values) {
            sum += val;
        }
        return sum;
    }

    private static double highest(List<Double> values) {
        double highest = Double.NEGATIVE_INFINITY;
        for (double val : values) {
            if (!(val > highest)) continue;
            highest = val;
        }
        return highest == Double.NEGATIVE_INFINITY ? 0.0 : highest;
    }

    private static double average(List<Double> values) {
        return AbstractMetricsComputer.sum(values) / (double)values.size();
    }
}

