/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.LanguageVersionHandler;

public abstract class BaseLanguageModule
implements Language {
    protected String name;
    protected String shortName;
    protected String terseName;
    protected Class<?> ruleChainVisitorClass;
    protected List<String> extensions;
    protected Map<String, LanguageVersion> versions;
    protected LanguageVersion defaultVersion;

    public BaseLanguageModule(String name, String shortName, String terseName, Class<?> ruleChainVisitorClass, String ... extensions) {
        this.name = name;
        this.shortName = shortName;
        this.terseName = terseName;
        this.ruleChainVisitorClass = ruleChainVisitorClass;
        this.extensions = Arrays.asList(extensions);
    }

    protected void addVersion(String version, LanguageVersionHandler languageVersionHandler, boolean isDefault) {
        if (this.versions == null) {
            this.versions = new HashMap<String, LanguageVersion>();
        }
        LanguageVersion languageVersion = new LanguageVersion(this, version, languageVersionHandler);
        this.versions.put(version, languageVersion);
        if (isDefault) {
            this.defaultVersion = languageVersion;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getShortName() {
        return this.shortName != null ? this.shortName : this.name;
    }

    @Override
    public String getTerseName() {
        return this.terseName;
    }

    @Override
    public Class<?> getRuleChainVisitorClass() {
        return this.ruleChainVisitorClass;
    }

    @Override
    public List<String> getExtensions() {
        return Collections.unmodifiableList(this.extensions);
    }

    @Override
    public boolean hasExtension(String extension) {
        return this.extensions != null && this.extensions.contains(extension);
    }

    @Override
    public List<LanguageVersion> getVersions() {
        return new ArrayList<LanguageVersion>(this.versions.values());
    }

    @Override
    public boolean hasVersion(String version) {
        return this.versions != null && this.versions.containsKey(version);
    }

    @Override
    public LanguageVersion getVersion(String versionName) {
        if (this.versions != null) {
            return this.versions.get(versionName);
        }
        return null;
    }

    @Override
    public LanguageVersion getDefaultVersion() {
        return this.defaultVersion;
    }

    public String toString() {
        return "LanguageModule:" + this.name + "(" + this.getClass().getSimpleName() + ")";
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseLanguageModule)) {
            return false;
        }
        BaseLanguageModule other = (BaseLanguageModule)obj;
        return this.name.equals(other.name);
    }

    @Override
    public int compareTo(Language o) {
        return this.getName().compareTo(o.getName());
    }
}

