/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import net.sourceforge.pmd.util.CollectionUtil;

public final class StringUtil {
    private static final String[] EMPTY_STRINGS = new String[0];
    private static final boolean SUPPORTS_UTF8 = "yes".equals(System.getProperty("net.sourceforge.pmd.supportUTF8", "no"));

    private StringUtil() {
    }

    public static boolean startsWithAny(String text, String ... prefixes) {
        for (String prefix : prefixes) {
            if (!text.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnyOf(String text, String ... tests) {
        for (String test : tests) {
            if (!text.equals(test)) continue;
            return true;
        }
        return false;
    }

    public static String withoutPrefixes(String text, String ... prefixes) {
        for (String prefix : prefixes) {
            if (!text.startsWith(prefix)) continue;
            return text.substring(prefix.length());
        }
        return text;
    }

    public static boolean isEmpty(String value) {
        if (value == null || "".equals(value)) {
            return true;
        }
        for (int i = 0; i < value.length(); ++i) {
            if (Character.isWhitespace(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotEmpty(String value) {
        return !StringUtil.isEmpty(value);
    }

    public static boolean areSemanticEquals(String a, String b) {
        if (a == null) {
            return StringUtil.isEmpty(b);
        }
        if (b == null) {
            return StringUtil.isEmpty(a);
        }
        return a.equals(b);
    }

    public static String replaceString(String original, char oldChar, String newString) {
        int index = original.indexOf(oldChar);
        if (index < 0) {
            return original;
        }
        String replace = newString == null ? "" : newString;
        StringBuilder buf = new StringBuilder(Math.max(16, original.length() + replace.length()));
        int last = 0;
        while (index != -1) {
            buf.append(original.substring(last, index));
            buf.append(replace);
            last = index + 1;
            index = original.indexOf(oldChar, last);
        }
        buf.append(original.substring(last));
        return buf.toString();
    }

    public static String replaceString(String original, String oldString, String newString) {
        int index = original.indexOf(oldString);
        if (index < 0) {
            return original;
        }
        String replace = newString == null ? "" : newString;
        StringBuilder buf = new StringBuilder(Math.max(16, original.length() + replace.length()));
        int last = 0;
        while (index != -1) {
            buf.append(original.substring(last, index));
            buf.append(replace);
            last = index + oldString.length();
            index = original.indexOf(oldString, last);
        }
        buf.append(original.substring(last));
        return buf.toString();
    }

    @Deprecated
    public static void appendXmlEscaped(StringBuilder buf, String src) {
        StringUtil.appendXmlEscaped(buf, src, SUPPORTS_UTF8);
    }

    public static String escapeWhitespace(Object o) {
        if (o == null) {
            return null;
        }
        String s = String.valueOf(o);
        s = s.replace("\n", "\\n");
        s = s.replace("\r", "\\r");
        s = s.replace("\t", "\\t");
        return s;
    }

    public static String htmlEncode(String string) {
        String encoded = StringUtil.replaceString(string, '&', "&amp;");
        encoded = StringUtil.replaceString(encoded, '<', "&lt;");
        return StringUtil.replaceString(encoded, '>', "&gt;");
    }

    public static void appendXmlEscaped(StringBuilder buf, String src, boolean supportUTF8) {
        for (int i = 0; i < src.length(); ++i) {
            int c = src.charAt(i);
            if (c > 126) {
                if (!supportUTF8) {
                    int codepoint = c;
                    if (Character.isHighSurrogate((char)c)) {
                        char low = src.charAt(i + 1);
                        codepoint = Character.toCodePoint((char)c, low);
                        ++i;
                    }
                    buf.append("&#x").append(Integer.toHexString(codepoint)).append(';');
                    continue;
                }
                buf.append((char)c);
                continue;
            }
            if (c == 38) {
                buf.append("&amp;");
                continue;
            }
            if (c == 34) {
                buf.append("&quot;");
                continue;
            }
            if (c == 60) {
                buf.append("&lt;");
                continue;
            }
            if (c == 62) {
                buf.append("&gt;");
                continue;
            }
            buf.append((char)c);
        }
    }

    public static String[] substringsOf(String source, char delimiter) {
        if (source == null || source.length() == 0) {
            return EMPTY_STRINGS;
        }
        int delimiterCount = 0;
        int length = source.length();
        char[] chars = source.toCharArray();
        for (int i = 0; i < length; ++i) {
            if (chars[i] != delimiter) continue;
            ++delimiterCount;
        }
        if (delimiterCount == 0) {
            return new String[]{source};
        }
        String[] results = new String[delimiterCount + 1];
        int i = 0;
        int offset = 0;
        while (offset <= length) {
            int pos = source.indexOf(delimiter, offset);
            if (pos < 0) {
                pos = length;
            }
            results[i++] = pos == offset ? "" : source.substring(offset, pos);
            offset = pos + 1;
        }
        return results;
    }

    public static String[] substringsOf(String str, String separator) {
        if (str == null || str.length() == 0) {
            return EMPTY_STRINGS;
        }
        int index = str.indexOf(separator);
        if (index == -1) {
            return new String[]{str};
        }
        ArrayList<String> list = new ArrayList<String>();
        int currPos = 0;
        int len = separator.length();
        while (index != -1) {
            list.add(str.substring(currPos, index));
            currPos = index + len;
            index = str.indexOf(separator, currPos);
        }
        list.add(str.substring(currPos));
        return list.toArray(new String[list.size()]);
    }

    public static void asStringOn(StringBuffer sb, Iterator<?> iter, String separator) {
        if (!iter.hasNext()) {
            return;
        }
        sb.append(iter.next());
        while (iter.hasNext()) {
            sb.append(separator);
            sb.append(iter.next());
        }
    }

    public static void asStringOn(StringBuilder sb, Object[] items, String separator) {
        if (items == null || items.length == 0) {
            return;
        }
        sb.append(items[0]);
        for (int i = 1; i < items.length; ++i) {
            sb.append(separator);
            sb.append(items[i]);
        }
    }

    public static int lengthOfShortestIn(String[] strings) {
        if (CollectionUtil.isEmpty(strings)) {
            return 0;
        }
        int minLength = Integer.MAX_VALUE;
        for (int i = 0; i < strings.length; ++i) {
            if (strings[i] == null) {
                return 0;
            }
            minLength = Math.min(minLength, strings[i].length());
        }
        return minLength;
    }

    public static int maxCommonLeadingWhitespaceForAll(String[] strings) {
        int shortest = StringUtil.lengthOfShortestIn(strings);
        if (shortest == 0) {
            return 0;
        }
        char[] matches = new char[shortest];
        for (int m = 0; m < matches.length; ++m) {
            matches[m] = strings[0].charAt(m);
            if (!Character.isWhitespace(matches[m])) {
                return m;
            }
            for (int i = 0; i < strings.length; ++i) {
                String str = strings[i];
                if (str.charAt(m) == matches[m]) continue;
                return m;
            }
        }
        return shortest;
    }

    public static String[] trimStartOn(String[] strings, int trimDepth) {
        if (trimDepth == 0) {
            return strings;
        }
        String[] results = new String[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            results[i] = strings[i].substring(trimDepth);
        }
        return results;
    }

    public static String lpad(String s, int length) {
        String res = s;
        if (length - s.length() > 0) {
            char[] arr = new char[length - s.length()];
            Arrays.fill(arr, ' ');
            res = new StringBuilder(length).append(arr).append(s).toString();
        }
        return res;
    }

    public static boolean isSame(String s1, String s2, boolean trim, boolean ignoreCase, boolean standardizeWhitespace) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        if (trim) {
            s1 = s1.trim();
            s2 = s2.trim();
        }
        if (standardizeWhitespace) {
            s1 = s1.replaceAll("\\s+", " ");
            s2 = s2.replaceAll("\\s+", " ");
        }
        return ignoreCase ? s1.equalsIgnoreCase(s2) : s1.equals(s2);
    }

    public static String asString(Object[] items, String separator) {
        if (items == null || items.length == 0) {
            return "";
        }
        if (items.length == 1) {
            return items[0].toString();
        }
        StringBuilder sb = new StringBuilder(items[0].toString());
        for (int i = 1; i < items.length; ++i) {
            sb.append(separator).append(items[i]);
        }
        return sb.toString();
    }

    public static String[] getEmptyStrings() {
        return EMPTY_STRINGS;
    }
}

