/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSetReference;
import net.sourceforge.pmd.benchmark.Benchmark;
import net.sourceforge.pmd.benchmark.Benchmarker;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.RuleReference;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.StringUtil;
import net.sourceforge.pmd.util.filter.Filter;
import net.sourceforge.pmd.util.filter.Filters;

public class RuleSet {
    private static final Logger LOG = Logger.getLogger(RuleSet.class.getName());
    private List<Rule> rules = new ArrayList<Rule>();
    private String fileName;
    private String name = "";
    private String description = "";
    private List<String> excludePatterns = new ArrayList<String>(0);
    private List<String> includePatterns = new ArrayList<String>(0);
    private Filter<File> filter;

    public static RuleSet createFor(String name, Rule ... theRules) {
        RuleSet rs = new RuleSet();
        rs.setName(name);
        for (Rule rule : theRules) {
            rs.addRule(rule);
        }
        return rs;
    }

    public int size() {
        return this.rules.size();
    }

    public void addRule(Rule rule) {
        if (rule == null) {
            throw new IllegalArgumentException("Missing rule");
        }
        this.rules.add(rule);
    }

    public boolean addRuleReplaceIfExists(Rule rule) {
        if (rule == null) {
            throw new IllegalArgumentException("Missing rule");
        }
        boolean replaced = false;
        Iterator<Rule> it = this.rules.iterator();
        while (it.hasNext()) {
            Rule r = it.next();
            if (!r.getName().equals(rule.getName()) || r.getLanguage() != rule.getLanguage()) continue;
            it.remove();
            replaced = true;
        }
        this.addRule(rule);
        return replaced;
    }

    public boolean addRuleIfNotExists(Rule rule) {
        if (rule == null) {
            throw new IllegalArgumentException("Missing rule");
        }
        boolean exists = false;
        for (Rule r : this.rules) {
            if (!r.getName().equals(rule.getName()) || r.getLanguage() != rule.getLanguage()) continue;
            exists = true;
            break;
        }
        if (!exists) {
            this.addRule(rule);
        }
        return !exists;
    }

    public void addRuleByReference(String ruleSetFileName, Rule rule) {
        RuleReference ruleReference;
        if (StringUtil.isEmpty(ruleSetFileName)) {
            throw new RuntimeException("Adding a rule by reference is not allowed with an empty rule set file name.");
        }
        if (rule == null) {
            throw new IllegalArgumentException("Cannot add a null rule reference to a RuleSet");
        }
        if (rule instanceof RuleReference) {
            ruleReference = (RuleReference)rule;
        } else {
            RuleSetReference ruleSetReference = new RuleSetReference();
            ruleSetReference.setRuleSetFileName(ruleSetFileName);
            ruleReference = new RuleReference();
            ruleReference.setRule(rule);
            ruleReference.setRuleSetReference(ruleSetReference);
        }
        this.rules.add(ruleReference);
    }

    public Collection<Rule> getRules() {
        return this.rules;
    }

    public boolean usesDFA(Language language) {
        for (Rule r : this.rules) {
            if (!r.getLanguage().equals(language) || !r.usesDFA()) continue;
            return true;
        }
        return false;
    }

    public Rule getRuleByName(String ruleName) {
        for (Rule r : this.rules) {
            if (!r.getName().equals(ruleName)) continue;
            return r;
        }
        return null;
    }

    public void addRuleSet(RuleSet ruleSet) {
        this.rules.addAll(this.rules.size(), ruleSet.getRules());
    }

    public void addRuleSetByReference(RuleSet ruleSet, boolean allRules) {
        this.addRuleSetByReference(ruleSet, allRules, null);
    }

    public void addRuleSetByReference(RuleSet ruleSet, boolean allRules, String ... excludes) {
        if (StringUtil.isEmpty(ruleSet.getFileName())) {
            throw new RuntimeException("Adding a rule by reference is not allowed with an empty rule set file name.");
        }
        RuleSetReference ruleSetReference = new RuleSetReference(ruleSet.getFileName());
        ruleSetReference.setAllRules(allRules);
        if (excludes != null) {
            ruleSetReference.setExcludes(new HashSet<String>(Arrays.asList(excludes)));
        }
        for (Rule rule : ruleSet.getRules()) {
            RuleReference ruleReference = new RuleReference(rule, ruleSetReference);
            this.rules.add(ruleReference);
        }
    }

    public boolean applies(File file) {
        if (this.filter == null) {
            Filter<String> regexFilter = Filters.buildRegexFilterIncludeOverExclude(this.includePatterns, this.excludePatterns);
            this.filter = Filters.toNormalizedFileFilter(regexFilter);
        }
        return file != null ? this.filter.filter(file) : true;
    }

    public void start(RuleContext ctx) {
        for (Rule rule : this.rules) {
            rule.start(ctx);
        }
    }

    public void apply(List<? extends Node> acuList, RuleContext ctx) {
        long start = System.nanoTime();
        for (Rule rule : this.rules) {
            try {
                if (rule.usesRuleChain() || !RuleSet.applies(rule, ctx.getLanguageVersion())) continue;
                rule.apply(acuList, ctx);
                long end = System.nanoTime();
                Benchmarker.mark(Benchmark.Rule, rule.getName(), end - start, 1L);
                start = end;
            }
            catch (RuntimeException e) {
                if (ctx.isIgnoreExceptions()) {
                    if (!LOG.isLoggable(Level.WARNING)) continue;
                    LOG.log(Level.WARNING, "Exception applying rule " + rule.getName() + " on file " + ctx.getSourceCodeFilename() + ", continuing with next rule", e);
                    continue;
                }
                throw e;
            }
        }
    }

    public static boolean applies(Rule rule, LanguageVersion languageVersion) {
        LanguageVersion min = rule.getMinimumLanguageVersion();
        LanguageVersion max = rule.getMaximumLanguageVersion();
        return !(!rule.getLanguage().equals(languageVersion.getLanguage()) || min != null && min.compareTo(languageVersion) > 0 || max != null && max.compareTo(languageVersion) < 0);
    }

    public void end(RuleContext ctx) {
        for (Rule rule : this.rules) {
            rule.end(ctx);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof RuleSet)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        RuleSet ruleSet = (RuleSet)o;
        return this.getName().equals(ruleSet.getName()) && this.getRules().equals(ruleSet.getRules());
    }

    public int hashCode() {
        return this.getName().hashCode() + 13 * this.getRules().hashCode();
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getExcludePatterns() {
        return this.excludePatterns;
    }

    public void addExcludePattern(String aPattern) {
        if (this.excludePatterns.contains(aPattern)) {
            return;
        }
        this.excludePatterns.add(aPattern);
        this.patternsChanged();
    }

    public void addExcludePatterns(Collection<String> someExcludePatterns) {
        int added = CollectionUtil.addWithoutDuplicates(someExcludePatterns, this.excludePatterns);
        if (added > 0) {
            this.patternsChanged();
        }
    }

    public void setExcludePatterns(Collection<String> theExcludePatterns) {
        if (this.excludePatterns.equals(theExcludePatterns)) {
            return;
        }
        this.excludePatterns.clear();
        CollectionUtil.addWithoutDuplicates(theExcludePatterns, this.excludePatterns);
        this.patternsChanged();
    }

    public List<String> getIncludePatterns() {
        return this.includePatterns;
    }

    public void addIncludePattern(String aPattern) {
        if (this.includePatterns.contains(aPattern)) {
            return;
        }
        this.includePatterns.add(aPattern);
        this.patternsChanged();
    }

    public void addIncludePatterns(Collection<String> someIncludePatterns) {
        int added = CollectionUtil.addWithoutDuplicates(someIncludePatterns, this.includePatterns);
        if (added > 0) {
            this.patternsChanged();
        }
    }

    public void setIncludePatterns(Collection<String> theIncludePatterns) {
        if (this.includePatterns.equals(theIncludePatterns)) {
            return;
        }
        this.includePatterns.clear();
        CollectionUtil.addWithoutDuplicates(theIncludePatterns, this.includePatterns);
        this.patternsChanged();
    }

    private void patternsChanged() {
        this.filter = null;
    }

    public boolean usesTypeResolution(Language language) {
        for (Rule r : this.rules) {
            if (!r.getLanguage().equals(language) || !r.usesTypeResolution()) continue;
            return true;
        }
        return false;
    }

    public void removeDysfunctionalRules(Collection<Rule> collector) {
        Iterator<Rule> iter = this.rules.iterator();
        while (iter.hasNext()) {
            Rule rule = iter.next();
            if (rule.dysfunctionReason() == null) continue;
            iter.remove();
            collector.add(rule);
        }
    }
}

