/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageVersion;

public final class LanguageRegistry {
    private static LanguageRegistry instance = new LanguageRegistry();
    private Map<String, Language> languages = new HashMap<String, Language>();

    private LanguageRegistry() {
        ServiceLoader<Language> languageLoader = ServiceLoader.load(Language.class);
        for (Language language : languageLoader) {
            this.languages.put(language.getName(), language);
        }
    }

    public static LanguageRegistry getInstance() {
        return instance;
    }

    public static Collection<Language> getLanguages() {
        return LanguageRegistry.getInstance().languages.values();
    }

    public static Language getLanguage(String languageName) {
        return LanguageRegistry.getInstance().languages.get(languageName);
    }

    public static Language getDefaultLanguage() {
        return LanguageRegistry.getLanguage("Java");
    }

    public static Language findLanguageByTerseName(String terseName) {
        for (Language language : LanguageRegistry.getInstance().languages.values()) {
            if (!language.getTerseName().equals(terseName)) continue;
            return language;
        }
        return null;
    }

    public static LanguageVersion findLanguageVersionByTerseName(String terseName) {
        Language language;
        String version = null;
        if (terseName.contains(" ")) {
            version = terseName.substring(terseName.lastIndexOf(32) + 1);
            terseName = terseName.substring(0, terseName.lastIndexOf(32));
        }
        if ((language = LanguageRegistry.findLanguageByTerseName(terseName)) != null) {
            if (version == null) {
                return language.getDefaultVersion();
            }
            return language.getVersion(version);
        }
        return null;
    }

    public static List<Language> findByExtension(String extension) {
        ArrayList<Language> languages = new ArrayList<Language>();
        for (Language language : LanguageRegistry.getInstance().languages.values()) {
            if (!language.hasExtension(extension)) continue;
            languages.add(language);
        }
        return languages;
    }

    public static List<LanguageVersion> findAllVersions() {
        ArrayList<LanguageVersion> versions = new ArrayList<LanguageVersion>();
        for (Language language : LanguageRegistry.getLanguages()) {
            for (LanguageVersion languageVersion : language.getVersions()) {
                versions.add(languageVersion);
            }
        }
        return versions;
    }

    public static List<Language> findWithRuleSupport() {
        ArrayList<Language> languages = new ArrayList<Language>();
        for (Language language : LanguageRegistry.getInstance().languages.values()) {
            if (language.getRuleChainVisitorClass() == null) continue;
            languages.add(language);
        }
        return languages;
    }

    public static String commaSeparatedTerseNamesForLanguage(List<Language> languages) {
        StringBuilder builder = new StringBuilder();
        for (Language language : languages) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(language.getTerseName());
        }
        return builder.toString();
    }

    public static String commaSeparatedTerseNamesForLanguageVersion(List<LanguageVersion> languageVersions) {
        if (languageVersions == null || languageVersions.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(languageVersions.get(0).getTerseName());
        for (int i = 1; i < languageVersions.size(); ++i) {
            builder.append(", ").append(languageVersions.get(i).getTerseName());
        }
        return builder.toString();
    }
}

