/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.designer;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.util.StringUtil;
import net.sourceforge.pmd.util.designer.CodeEditorTextPane;

public class CreateXMLRulePanel
extends JPanel
implements ActionListener {
    private JTextField rulenameField = new JTextField(30);
    private JTextField rulemsgField = new JTextField(30);
    private JTextArea ruledescField = new JTextArea(5, 30);
    private JTextArea ruleXMLArea = new JTextArea(30, 30);
    private JTextArea xpathQueryArea = new JTextArea();
    private CodeEditorTextPane codeEditorPane = new CodeEditorTextPane();

    private static void appendLn(StringBuilder sb, String text) {
        sb.append(text).append(PMD.EOL);
    }

    public CreateXMLRulePanel(JTextArea xpathQueryArea, CodeEditorTextPane codeEditorPane) {
        this.xpathQueryArea = xpathQueryArea;
        this.codeEditorPane = codeEditorPane;
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.anchor = 13;
        gbc.weightx = 0.5;
        JLabel rulenameLabel = new JLabel("Rule name : ");
        gbl.setConstraints(rulenameLabel, gbc);
        this.add(rulenameLabel);
        gbc.weightx = 0.5;
        gbc.anchor = 17;
        gbc.gridx = 1;
        gbl.setConstraints(this.rulenameField, gbc);
        this.add(this.rulenameField);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 13;
        gbc.weightx = 0.5;
        JLabel rulemsgLabel = new JLabel("Rule msg : ");
        gbl.setConstraints(rulemsgLabel, gbc);
        this.add(rulemsgLabel);
        gbc.gridx = 1;
        gbc.anchor = 17;
        gbc.weightx = 0.5;
        gbl.setConstraints(this.rulemsgField, gbc);
        this.add(this.rulemsgField);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 13;
        gbc.weightx = 0.5;
        JLabel ruledescLabel = new JLabel("Rule desc : ");
        gbl.setConstraints(ruledescLabel, gbc);
        this.add(ruledescLabel);
        gbc.gridx = 1;
        gbc.anchor = 17;
        gbc.weightx = 0.5;
        this.ruledescField.setLineWrap(true);
        gbl.setConstraints(this.ruledescField, gbc);
        this.add(this.ruledescField);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.anchor = 11;
        JButton createRuleBtn = new JButton("Create rule XML");
        createRuleBtn.addActionListener(this);
        gbl.setConstraints(createRuleBtn, gbc);
        this.add(createRuleBtn);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.anchor = 11;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        JScrollPane ruleXMLPane = new JScrollPane(this.ruleXMLArea);
        gbl.setConstraints(ruleXMLPane, gbc);
        this.add(ruleXMLPane);
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent exception) {
        boolean hasXPathQuery = StringUtil.isNotEmpty(this.xpathQueryArea.getText());
        StringBuilder buffer = new StringBuilder(200);
        CreateXMLRulePanel.appendLn(buffer, "<rule  name=\"" + this.rulenameField.getText() + '\"');
        CreateXMLRulePanel.appendLn(buffer, "  message=\"" + this.rulemsgField.getText() + '\"');
        CreateXMLRulePanel.appendLn(buffer, "  class=\"" + (hasXPathQuery ? "net.sourceforge.pmd.lang.rule.XPathRule" : "") + "\">");
        CreateXMLRulePanel.appendLn(buffer, "  <description>");
        CreateXMLRulePanel.appendLn(buffer, "  " + this.ruledescField.getText());
        CreateXMLRulePanel.appendLn(buffer, "  </description>");
        if (hasXPathQuery) {
            CreateXMLRulePanel.appendLn(buffer, "  <properties>");
            CreateXMLRulePanel.appendLn(buffer, "    <property name=\"xpath\">");
            CreateXMLRulePanel.appendLn(buffer, "    <value>");
            CreateXMLRulePanel.appendLn(buffer, "<![CDATA[");
            CreateXMLRulePanel.appendLn(buffer, this.xpathQueryArea.getText());
            CreateXMLRulePanel.appendLn(buffer, "]]>");
            CreateXMLRulePanel.appendLn(buffer, "    </value>");
            CreateXMLRulePanel.appendLn(buffer, "    </property>");
            CreateXMLRulePanel.appendLn(buffer, "  </properties>");
        }
        CreateXMLRulePanel.appendLn(buffer, "  <priority>3</priority>");
        CreateXMLRulePanel.appendLn(buffer, "  <example>");
        CreateXMLRulePanel.appendLn(buffer, "<![CDATA[");
        CreateXMLRulePanel.appendLn(buffer, this.codeEditorPane.getText());
        CreateXMLRulePanel.appendLn(buffer, "]]>");
        CreateXMLRulePanel.appendLn(buffer, "  </example>");
        CreateXMLRulePanel.appendLn(buffer, "</rule>");
        this.ruleXMLArea.setText(buffer.toString());
        this.repaint();
    }
}

