/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.sourceforge.pmd.util.FileFinder;
import net.sourceforge.pmd.util.FileIterable;
import net.sourceforge.pmd.util.datasource.DataSource;
import net.sourceforge.pmd.util.datasource.FileDataSource;
import net.sourceforge.pmd.util.datasource.ZipDataSource;
import net.sourceforge.pmd.util.filter.AndFilter;
import net.sourceforge.pmd.util.filter.Filters;
import net.sourceforge.pmd.util.filter.OrFilter;

public final class FileUtil {
    private FileUtil() {
    }

    public static String getFileNameWithoutExtension(String fileName) {
        String name = fileName;
        int index = fileName.lastIndexOf(46);
        if (index != -1) {
            name = fileName.substring(0, index);
        }
        return name;
    }

    public static List<DataSource> collectFiles(String fileLocations, FilenameFilter filenameFilter) {
        ArrayList<DataSource> dataSources = new ArrayList<DataSource>();
        for (String fileLocation : fileLocations.split(",")) {
            FileUtil.collect(dataSources, fileLocation, filenameFilter);
        }
        return dataSources;
    }

    private static List<DataSource> collect(List<DataSource> dataSources, String fileLocation, FilenameFilter filenameFilter) {
        File file = new File(fileLocation);
        if (!file.exists()) {
            throw new RuntimeException("File " + file.getName() + " doesn't exist");
        }
        if (!file.isDirectory()) {
            if (fileLocation.endsWith(".zip") || fileLocation.endsWith(".jar")) {
                try {
                    ZipFile zipFile = new ZipFile(fileLocation);
                    Enumeration<? extends ZipEntry> e = zipFile.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry zipEntry = e.nextElement();
                        if (!filenameFilter.accept(null, zipEntry.getName())) continue;
                        dataSources.add(new ZipDataSource(zipFile, zipEntry));
                    }
                }
                catch (IOException ze) {
                    throw new RuntimeException("Archive file " + file.getName() + " can't be opened");
                }
            } else {
                dataSources.add(new FileDataSource(file));
            }
        } else {
            OrFilter<File> filter = new OrFilter<File>(Filters.toFileFilter(filenameFilter), new AndFilter(Filters.getDirectoryFilter(), Filters.toNormalizedFileFilter(Filters.buildRegexFilterExcludeOverInclude(null, Collections.singletonList("SCCS")))));
            FileFinder finder = new FileFinder();
            List<File> files = finder.findFilesFrom(file, Filters.toFilenameFilter(filter), true);
            for (File f : files) {
                dataSources.add(new FileDataSource(f));
            }
        }
        return dataSources;
    }

    public static boolean findPatternInFile(File file, String pattern) {
        Pattern regexp = Pattern.compile(pattern);
        Matcher matcher = regexp.matcher("");
        FileIterable it = new FileIterable(file);
        for (String line : it) {
            matcher.reset(line);
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }
}

