/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.ReportListener;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.RuleViolationComparator;
import net.sourceforge.pmd.SynchronizedReportListener;
import net.sourceforge.pmd.lang.dfa.report.ReportTree;
import net.sourceforge.pmd.stat.Metric;
import net.sourceforge.pmd.util.DateTimeUtil;
import net.sourceforge.pmd.util.EmptyIterator;
import net.sourceforge.pmd.util.NumericConstants;
import net.sourceforge.pmd.util.StringUtil;

public class Report
implements Iterable<RuleViolation> {
    private final ReportTree violationTree = new ReportTree();
    private final List<RuleViolation> violations = new ArrayList<RuleViolation>();
    private final Set<Metric> metrics = new HashSet<Metric>();
    private final List<SynchronizedReportListener> listeners = new ArrayList<SynchronizedReportListener>();
    private List<ProcessingError> errors;
    private List<RuleConfigurationError> configErrors;
    private Map<Integer, String> linesToSuppress = new HashMap<Integer, String>();
    private long start;
    private long end;
    private List<SuppressedViolation> suppressedRuleViolations = new ArrayList<SuppressedViolation>();

    public static Report createReport(RuleContext ctx, String fileName) {
        Report report = new Report();
        report.addSynchronizedListeners(ctx.getReport().getSynchronizedListeners());
        ctx.setReport(report);
        ctx.setSourceCodeFilename(fileName);
        ctx.setSourceCodeFile(new File(fileName));
        return report;
    }

    public void suppress(Map<Integer, String> lines) {
        this.linesToSuppress = lines;
    }

    private static String keyFor(RuleViolation rv) {
        return StringUtil.isNotEmpty(rv.getPackageName()) ? rv.getPackageName() + '.' + rv.getClassName() : "";
    }

    public Map<String, Integer> getCountSummary() {
        HashMap<String, Integer> summary = new HashMap<String, Integer>();
        for (RuleViolation rv : this.violationTree) {
            String key;
            Integer o = (Integer)summary.get(key = Report.keyFor(rv));
            summary.put(key, o == null ? NumericConstants.ONE : o + 1);
        }
        return summary;
    }

    public ReportTree getViolationTree() {
        return this.violationTree;
    }

    public Map<String, Integer> getSummary() {
        HashMap<String, Integer> summary = new HashMap<String, Integer>();
        for (RuleViolation rv : this.violations) {
            String name = rv.getRule().getName();
            if (!summary.containsKey(name)) {
                summary.put(name, NumericConstants.ZERO);
            }
            Integer count = (Integer)summary.get(name);
            summary.put(name, count + 1);
        }
        return summary;
    }

    public void addListener(ReportListener listener) {
        this.listeners.add(new SynchronizedReportListener(listener));
    }

    public List<SuppressedViolation> getSuppressedRuleViolations() {
        return this.suppressedRuleViolations;
    }

    public void addRuleViolation(RuleViolation violation) {
        int line = violation.getBeginLine();
        if (this.linesToSuppress.containsKey(line)) {
            this.suppressedRuleViolations.add(new SuppressedViolation(violation, true, this.linesToSuppress.get(line)));
            return;
        }
        if (violation.isSuppressed()) {
            this.suppressedRuleViolations.add(new SuppressedViolation(violation, false, null));
            return;
        }
        int index = Collections.binarySearch(this.violations, violation, RuleViolationComparator.INSTANCE);
        this.violations.add(index < 0 ? -index - 1 : index, violation);
        this.violationTree.addRuleViolation(violation);
        for (SynchronizedReportListener listener : this.listeners) {
            listener.ruleViolationAdded(violation);
        }
    }

    public void addMetric(Metric metric) {
        this.metrics.add(metric);
        for (SynchronizedReportListener listener : this.listeners) {
            listener.metricAdded(metric);
        }
    }

    public void addConfigError(RuleConfigurationError error) {
        if (this.configErrors == null) {
            this.configErrors = new ArrayList<RuleConfigurationError>();
        }
        this.configErrors.add(error);
    }

    public void addError(ProcessingError error) {
        if (this.errors == null) {
            this.errors = new ArrayList<ProcessingError>();
        }
        this.errors.add(error);
    }

    public void merge(Report r) {
        Iterator<ProcessingError> i = r.errors();
        while (i.hasNext()) {
            this.addError(i.next());
        }
        Iterator<Metric> m = r.metrics();
        while (m.hasNext()) {
            this.addMetric(m.next());
        }
        for (RuleViolation violation : r) {
            int index = Collections.binarySearch(this.violations, violation, RuleViolationComparator.INSTANCE);
            this.violations.add(index < 0 ? -index - 1 : index, violation);
            this.violationTree.addRuleViolation(violation);
        }
        Iterator<SuppressedViolation> s = r.getSuppressedRuleViolations().iterator();
        while (s.hasNext()) {
            this.suppressedRuleViolations.add(s.next());
        }
    }

    public boolean hasMetrics() {
        return !this.metrics.isEmpty();
    }

    public Iterator<Metric> metrics() {
        return this.metrics.iterator();
    }

    public boolean isEmpty() {
        return !this.violations.iterator().hasNext() && !this.hasErrors();
    }

    public boolean hasErrors() {
        return this.errors != null && !this.errors.isEmpty();
    }

    public boolean hasConfigErrors() {
        return this.configErrors != null && !this.configErrors.isEmpty();
    }

    public boolean treeIsEmpty() {
        return !this.violationTree.iterator().hasNext();
    }

    public Iterator<RuleViolation> treeIterator() {
        return this.violationTree.iterator();
    }

    @Override
    public Iterator<RuleViolation> iterator() {
        return this.violations.iterator();
    }

    public Iterator<ProcessingError> errors() {
        return this.errors == null ? EmptyIterator.instance() : this.errors.iterator();
    }

    public Iterator<RuleConfigurationError> configErrors() {
        return this.configErrors == null ? EmptyIterator.instance() : this.configErrors.iterator();
    }

    public int treeSize() {
        return this.violationTree.size();
    }

    public int size() {
        return this.violations.size();
    }

    public void start() {
        this.start = System.currentTimeMillis();
    }

    public void end() {
        this.end = System.currentTimeMillis();
    }

    public long getElapsedTimeInMillis() {
        return this.end - this.start;
    }

    public List<SynchronizedReportListener> getSynchronizedListeners() {
        return this.listeners;
    }

    public void addSynchronizedListeners(List<SynchronizedReportListener> synchronizedListeners) {
        this.listeners.addAll(synchronizedListeners);
    }

    public static class SuppressedViolation {
        private final RuleViolation rv;
        private final boolean isNOPMD;
        private final String userMessage;

        public SuppressedViolation(RuleViolation rv, boolean isNOPMD, String userMessage) {
            this.isNOPMD = isNOPMD;
            this.rv = rv;
            this.userMessage = userMessage;
        }

        public boolean suppressedByNOPMD() {
            return this.isNOPMD;
        }

        public boolean suppressedByAnnotation() {
            return !this.isNOPMD;
        }

        public RuleViolation getRuleViolation() {
            return this.rv;
        }

        public String getUserMessage() {
            return this.userMessage;
        }
    }

    public static class ProcessingError {
        private final String msg;
        private final String file;

        public ProcessingError(String msg, String file) {
            this.msg = msg;
            this.file = file;
        }

        public String getMsg() {
            return this.msg;
        }

        public String getFile() {
            return this.file;
        }
    }

    public static class RuleConfigurationError {
        private final Rule rule;
        private final String issue;

        public RuleConfigurationError(Rule theRule, String theIssue) {
            this.rule = theRule;
            this.issue = theIssue;
        }

        public Rule rule() {
            return this.rule;
        }

        public String issue() {
            return this.issue;
        }
    }

    public static class ReadableDuration {
        private final long duration;

        public ReadableDuration(long duration) {
            this.duration = duration;
        }

        public String getTime() {
            return DateTimeUtil.asHoursMinutesSeconds(this.duration);
        }
    }
}

