/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy.impl;

import com.google.common.collect.ImmutableList;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.nio.channels.spi.SelectorProvider;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import org.littleshoot.proxy.impl.CategorizedThreadFactory;

public class ProxyThreadPools {
    private final NioEventLoopGroup clientToProxyAcceptorPool;
    private final NioEventLoopGroup clientToProxyWorkerPool;
    private final NioEventLoopGroup proxyToServerWorkerPool;

    public ProxyThreadPools(SelectorProvider selectorProvider, int incomingAcceptorThreads, int incomingWorkerThreads, int outgoingWorkerThreads, String serverGroupName, int serverGroupId) {
        this.clientToProxyAcceptorPool = new NioEventLoopGroup(incomingAcceptorThreads, (ThreadFactory)new CategorizedThreadFactory(serverGroupName, "ClientToProxyAcceptor", serverGroupId), selectorProvider);
        this.clientToProxyWorkerPool = new NioEventLoopGroup(incomingWorkerThreads, (ThreadFactory)new CategorizedThreadFactory(serverGroupName, "ClientToProxyWorker", serverGroupId), selectorProvider);
        this.clientToProxyWorkerPool.setIoRatio(90);
        this.proxyToServerWorkerPool = new NioEventLoopGroup(outgoingWorkerThreads, (ThreadFactory)new CategorizedThreadFactory(serverGroupName, "ProxyToServerWorker", serverGroupId), selectorProvider);
        this.proxyToServerWorkerPool.setIoRatio(90);
    }

    public List<EventLoopGroup> getAllEventLoops() {
        return ImmutableList.of((Object)this.clientToProxyAcceptorPool, (Object)this.clientToProxyWorkerPool, (Object)this.proxyToServerWorkerPool);
    }

    public NioEventLoopGroup getClientToProxyAcceptorPool() {
        return this.clientToProxyAcceptorPool;
    }

    public NioEventLoopGroup getClientToProxyWorkerPool() {
        return this.clientToProxyWorkerPool;
    }

    public NioEventLoopGroup getProxyToServerWorkerPool() {
        return this.proxyToServerWorkerPool;
    }
}

