/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.metrics;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import io.grpc.ClientStreamTracer;
import io.grpc.Deadline;
import io.grpc.Metadata;
import io.grpc.Status;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;
import net.devh.boot.grpc.client.metrics.MetricsClientMeters;
import net.devh.boot.grpc.common.util.Constants;

final class MetricsClientStreamTracers {
    private static final Supplier<Stopwatch> STOPWATCH_SUPPLIER = Stopwatch::createUnstarted;
    private final Supplier<Stopwatch> stopwatchSupplier;
    private static final String INSTRUMENTATION_SOURCE_TAG_KEY = "instrumentation_source";
    private static final String INSTRUMENTATION_VERSION_TAG_KEY = "instrumentation_version";

    MetricsClientStreamTracers() {
        this(STOPWATCH_SUPPLIER);
    }

    MetricsClientStreamTracers(Supplier<Stopwatch> stopwatchSupplier) {
        this.stopwatchSupplier = (Supplier)Preconditions.checkNotNull(stopwatchSupplier, (Object)"stopwatchSupplier");
    }

    static final class CallAttemptsTracerFactory
    extends ClientStreamTracer.Factory {
        ClientTracer inboundMetricTracer;
        private final MetricsClientStreamTracers tracerModule;
        private final MetricsClientMeters metricsClientMeters;
        private final Stopwatch attemptStopwatch;
        private final Stopwatch clientCallStopWatch;
        private final String fullMethodName;
        private final Object lock = new Object();
        private final AtomicLong attemptsPerCall = new AtomicLong();
        private long callLatencyNanos;
        private Status status;
        @GuardedBy(value="lock")
        private boolean callEnded;
        @GuardedBy(value="lock")
        private int activeStreams;
        @GuardedBy(value="lock")
        private boolean finishedCallToBeRecorded;

        CallAttemptsTracerFactory(MetricsClientStreamTracers tracerModule, String fullMethodName, MetricsClientMeters metricsClientMeters) {
            this.tracerModule = (MetricsClientStreamTracers)Preconditions.checkNotNull((Object)tracerModule, (Object)"tracerModule");
            this.fullMethodName = (String)Preconditions.checkNotNull((Object)fullMethodName, (Object)"fullMethodName");
            this.metricsClientMeters = (MetricsClientMeters)Preconditions.checkNotNull((Object)metricsClientMeters, (Object)"metricsMeters");
            this.attemptStopwatch = tracerModule.stopwatchSupplier.get();
            this.clientCallStopWatch = tracerModule.stopwatchSupplier.get().start();
            ((Counter)this.metricsClientMeters.getAttemptCounter().withTags((Iterable)Tags.of((String[])new String[]{"grpc.method", fullMethodName, MetricsClientStreamTracers.INSTRUMENTATION_SOURCE_TAG_KEY, "grpc-spring", MetricsClientStreamTracers.INSTRUMENTATION_VERSION_TAG_KEY, Constants.VERSION}))).increment();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ClientStreamTracer newClientStreamTracer(ClientStreamTracer.StreamInfo info, Metadata metadata) {
            Object object = this.lock;
            synchronized (object) {
                if (this.finishedCallToBeRecorded) {
                    return new ClientStreamTracer(){};
                }
                if (++this.activeStreams == 1 && this.attemptStopwatch.isRunning()) {
                    this.attemptStopwatch.stop();
                }
            }
            if (this.attemptsPerCall.get() > 0L) {
                ((Counter)this.metricsClientMeters.getAttemptCounter().withTags((Iterable)Tags.of((String[])new String[]{"grpc.method", this.fullMethodName, MetricsClientStreamTracers.INSTRUMENTATION_SOURCE_TAG_KEY, "grpc-spring", MetricsClientStreamTracers.INSTRUMENTATION_VERSION_TAG_KEY, Constants.VERSION}))).increment();
            }
            if (!info.isTransparentRetry()) {
                this.attemptsPerCall.incrementAndGet();
            }
            return new ClientTracer(this, this.tracerModule, info, this.fullMethodName, this.metricsClientMeters);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void attemptEnded() {
            boolean shouldRecordFinishedCall = false;
            Object object = this.lock;
            synchronized (object) {
                if (--this.activeStreams == 0) {
                    this.attemptStopwatch.start();
                    if (this.callEnded && !this.finishedCallToBeRecorded) {
                        shouldRecordFinishedCall = true;
                        this.finishedCallToBeRecorded = true;
                    }
                }
            }
            if (shouldRecordFinishedCall) {
                this.recordFinishedCall();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void callEnded(Status status) {
            this.clientCallStopWatch.stop();
            this.status = status;
            boolean shouldRecordFinishedCall = false;
            Object object = this.lock;
            synchronized (object) {
                if (this.callEnded) {
                    return;
                }
                this.callEnded = true;
                if (this.activeStreams == 0 && !this.finishedCallToBeRecorded) {
                    shouldRecordFinishedCall = true;
                    this.finishedCallToBeRecorded = true;
                }
            }
            if (shouldRecordFinishedCall) {
                this.recordFinishedCall();
            }
        }

        void recordFinishedCall() {
            if (this.attemptsPerCall.get() == 0L) {
                ClientTracer tracer = new ClientTracer(this, this.tracerModule, null, this.fullMethodName, this.metricsClientMeters);
                tracer.attemptNanos = this.attemptStopwatch.elapsed(TimeUnit.NANOSECONDS);
                tracer.statusCode = this.status.getCode();
                tracer.recordFinishedAttempt();
            } else if (this.inboundMetricTracer != null) {
                this.inboundMetricTracer.recordFinishedAttempt();
            }
            this.callLatencyNanos = this.clientCallStopWatch.elapsed(TimeUnit.NANOSECONDS);
            Tags clientCallMetricTags = Tags.of((String[])new String[]{"grpc.method", this.fullMethodName, "grpc.status", this.status.getCode().toString(), MetricsClientStreamTracers.INSTRUMENTATION_SOURCE_TAG_KEY, "grpc-spring", MetricsClientStreamTracers.INSTRUMENTATION_VERSION_TAG_KEY, Constants.VERSION});
            ((Timer)this.metricsClientMeters.getClientCallDuration().withTags((Iterable)clientCallMetricTags)).record(this.callLatencyNanos, TimeUnit.NANOSECONDS);
        }
    }

    private static final class ClientTracer
    extends ClientStreamTracer {
        private final MetricsClientStreamTracers tracerModule;
        private final CallAttemptsTracerFactory attemptsState;
        private final MetricsClientMeters metricsClientMeters;
        private static final AtomicLongFieldUpdater<ClientTracer> outboundWireSizeUpdater = AtomicLongFieldUpdater.newUpdater(ClientTracer.class, "outboundWireSize");
        private static final AtomicLongFieldUpdater<ClientTracer> inboundWireSizeUpdater = AtomicLongFieldUpdater.newUpdater(ClientTracer.class, "inboundWireSize");
        private volatile long outboundWireSize;
        private volatile long inboundWireSize;
        private final ClientStreamTracer.StreamInfo info;
        private final String fullMethodName;
        final AtomicBoolean inboundReceivedOrClosed = new AtomicBoolean();
        final Stopwatch stopwatch;
        Status.Code statusCode;
        long attemptNanos;

        ClientTracer(CallAttemptsTracerFactory attemptsState, MetricsClientStreamTracers tracers, ClientStreamTracer.StreamInfo info, String fullMethodName, MetricsClientMeters metricsClientMeters) {
            this.attemptsState = attemptsState;
            this.tracerModule = tracers;
            this.info = info;
            this.fullMethodName = fullMethodName;
            this.metricsClientMeters = metricsClientMeters;
            this.stopwatch = tracers.stopwatchSupplier.get().start();
        }

        public void outboundWireSize(long bytes) {
            outboundWireSizeUpdater.getAndAdd(this, bytes);
        }

        public void inboundWireSize(long bytes) {
            inboundWireSizeUpdater.getAndAdd(this, bytes);
        }

        public void inboundMessage(int seqNo) {
            if (this.inboundReceivedOrClosed.compareAndSet(false, true)) {
                this.attemptsState.inboundMetricTracer = this;
            }
        }

        public void streamClosed(Status status) {
            this.stopwatch.stop();
            this.attemptNanos = this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
            Deadline deadline = this.info.getCallOptions().getDeadline();
            this.statusCode = status.getCode();
            if (this.statusCode == Status.Code.CANCELLED && deadline != null && deadline.isExpired()) {
                this.statusCode = Status.Code.DEADLINE_EXCEEDED;
            }
            this.attemptsState.attemptEnded();
            if (this.inboundReceivedOrClosed.compareAndSet(false, true)) {
                this.recordFinishedAttempt();
            }
        }

        void recordFinishedAttempt() {
            Tags attemptMetricTags = Tags.of((String[])new String[]{"grpc.method", this.fullMethodName, "grpc.status", this.statusCode.toString(), MetricsClientStreamTracers.INSTRUMENTATION_SOURCE_TAG_KEY, "grpc-spring", MetricsClientStreamTracers.INSTRUMENTATION_VERSION_TAG_KEY, Constants.VERSION});
            ((Timer)this.metricsClientMeters.getClientAttemptDuration().withTags((Iterable)attemptMetricTags)).record(this.attemptNanos, TimeUnit.NANOSECONDS);
            ((DistributionSummary)this.metricsClientMeters.getSentMessageSizeDistribution().withTags((Iterable)attemptMetricTags)).record((double)this.outboundWireSize);
            ((DistributionSummary)this.metricsClientMeters.getReceivedMessageSizeDistribution().withTags((Iterable)attemptMetricTags)).record((double)this.inboundWireSize);
        }
    }
}

